#include "spectrum.h"
#include "aminoacid.h"
#include "graph.h"
#include "batch.h"

struct Match {
	TwoValues<int> specPeak1, specPeak2;
	Match() { specPeak1.set(-1,-1); specPeak2.set(-1,-1);}
	Match(TwoValues<int> &p1, TwoValues<int> &p2) { specPeak1=p1; specPeak2=p2; }
	Match &set(TwoValues<int> &p1, TwoValues<int> &p2)  { specPeak1=p1; specPeak2=p2; return *this; }
	Match &set(int s1, int p1, int s2, int p2)  { specPeak1[0]=s1; specPeak1[1]=p1; specPeak2[0]=s2; specPeak2[1]=p2; return *this; }
	Match &operator=(Match other) { specPeak1=other.specPeak1; specPeak2=other.specPeak2; return *this;}
};

struct MatchEdge {
	float edgeMass;
	Match from, to;
	MatchEdge(float mass=0) { edgeMass=mass; }
	MatchEdge(float mass, Match m1, Match m2) { edgeMass=mass; from=m1; to=m2; }
};

struct SimpleEdge {
	float edgeMass,edgeScore;
	int specIdx;
	TwoValues<int> peaks;
	SimpleEdge(float mass=0) { edgeMass=mass; }
	SimpleEdge(float mass, float score, int in_specIdx, int peakIdx1, int peakIdx2) 
		{ set(mass, score, in_specIdx, peakIdx1, peakIdx2); }
	SimpleEdge &set(float mass, float score, int in_specIdx, int peakIdx1, int peakIdx2) 
		{ edgeMass=mass; edgeScore=score; specIdx=in_specIdx; peaks.set(peakIdx1,peakIdx2); return *this; }
	bool operator==(SimpleEdge &other)
		{ return specIdx==other.specIdx and peaks==other.peaks; }
	SimpleEdge &operator=(const SimpleEdge &other)
		{ specIdx=other.specIdx; peaks=other.peaks; edgeMass=other.edgeMass; edgeScore=other.edgeScore; return *this; }
    bool operator<(const SimpleEdge &other) { 
    	if(specIdx<other.specIdx or (specIdx==other.specIdx and peaks.values[0]<other.peaks.values[0]) or
    		 (specIdx==other.specIdx and peaks.values[0]==other.peaks.values[0] and peaks.values[1]<other.peaks.values[1]))
    		return true; 
    	return false; 
    }
};

class Vertex {
public:
	list<TwoValues<int> > specPeaks;
	list<MatchEdge> outMatchEdges;
	list<SimpleEdge> outEdges;
	bool compositeVertex;
	
	Vertex() { 
		reset();
	}
	Vertex(const Vertex &other);

	void addPeak(TwoValues<int> specPeak);
	void addMatchEdge(float edgeMass, Match from, Match to);
	void addEdge(float edgeMass, float edgeScore, int specIdx, int peakIdx1, int peakIdx2);
	void merge(Vertex &withVertex);
	void reset();
	unsigned int size() { return specPeaks.size(); }
	bool replaceEdge(int toSpecIdx, int toPeakIdx, int newPeakIdx, float addEdgeMass, float addEdgeScore);
};

class VertexSet {
	static const int SZEXPAND = 100;
	vector<int> freeVertices;
	int firstFreeVertex;
	void addFreeVertex(int idx) { freeVertices[idx]=firstFreeVertex; firstFreeVertex=idx; }
	int  getFreeVertex() { 
		if(firstFreeVertex==-1) {
			unsigned int oldSize = vertices.size();
			vertices.resize(vertices.size()+SZEXPAND);
			freeVertices.resize(freeVertices.size()+SZEXPAND);
			for(unsigned int i=oldSize; i<freeVertices.size()-1; i++) freeVertices[i]=i+1;
			freeVertices[freeVertices.size()-1]=-1;   firstFreeVertex = oldSize;
		}
		int t=firstFreeVertex; firstFreeVertex=freeVertices[t]; return t;
	}
	int mergeVertices(Match m);
	int addVertex(int specIdx, int peakIdx);
	int releaseVertex(int vertex) { vertices[vertex].reset(); addFreeVertex(vertex); return --numUsedVertices; }

	vector<int> scv_compVerts;
	vector<list<SimpleEdge> > scv_predEdges,scv_succEdges,scv_intnEdges,scv_compEdges;
	vector<TwoValues<list<SimpleEdge> > > scv_splitEdges; 

	void scv_addEdges(list<SimpleEdge> &edges, vector<TwoValues<bool> > &vertexAdjChanged);
	void scv_findSplitEdge(int cvIdx, int direction, float peakTol); 
	void scv_useSplitEdge(int cvIdx, int direction, vector<TwoValues<bool> > &vertexAdjChanged); 

public:
	static const short 
	            EST_EDGE_MULT = 0,
	            EST_EDGE_SCORES = 1,
	            EST_ABVERTEX_SCORES = 2;

	vector<vector<int> > peakToVertex;
	vector<Vertex> vertices;
	int numUsedVertices;
	SpecSet *specSet;
	
	VertexSet(SpecSet &specs, int numVertices) {
		peakToVertex.resize(specs.size());
		for(unsigned int i=0; i<peakToVertex.size(); i++) {
			peakToVertex[i].resize(specs[i].size());
			for(unsigned int j=0; j<peakToVertex[i].size(); j++) peakToVertex[i][j]=-1;
		}
		specSet = &specs;
		vertices.resize(numVertices);	freeVertices.resize(numVertices);	numUsedVertices=0;
		for(unsigned int i=0; i<freeVertices.size()-1; i++) freeVertices[i]=i+1;
		freeVertices[freeVertices.size()-1]=-1;   firstFreeVertex = 0;
	}
	VertexSet(const VertexSet &other);
	
	void addGlues(int specIdx1, int specIdx2, vector<TwoValues<int> > &matches, vector<MSGraph> *spectrumGraphs=0, bool addMissingEdges=false);
	void addEdges(vector<MSGraph> &spectrumGraphs, vector<bool> *usedSpectra=0);
	void addEndpointEdges(vector<Results_ASP> &aligns, vector<vector<TwoValues<int> > > &matches, vector<float> &modPos,
	                      AAJumps &jumps, float peakTol);
	void splitComposite(vector<MSGraph> &spectrumGraphs, float peakTol, vector<bool> *usedSpectra=0);
	void removeEndpoints(bool typeB, float peakTol);
	
	void buildGraph(MSGraph &g, AAJumps &jumps, float peakTol, vector<int> &vSet_index, 
	                short edgeScoreType=EST_EDGE_SCORES, vector<SpectrumPeakLabels> *labels=0);
	void consolidatePaths();
	
	void enumerateHeaviestPath(MSGraph &g, vector<int> &vSet_index, SpecSet &enumSpecs, vector<int> &enumSpecsIdx);

	void getMatchedPeaks(vector<int> &matchedVertices, vector<list<TwoValues<int> > > &putHere);
	
	void outputGraph(vector<SpectrumPeakLabels> *labels=0);
	void output_graphviz_ma(char *filename, vector<int> &matchedVertices);
};

void Save_abinfo(char *filename, SpecSet &specSet, vector<list<int> > &cSpectra, vector<bool> &specFlipped, vector<vector<list<TwoValues<int> > > > &abVertices);
