#ifndef ALIGNMENT_SCORING
#define ALIGNMENT_SCORING

#include "spectrum.h"
#include "aminoacid.h"

int FindMatchPeaksAll(Spectrum &spec1, Spectrum &spec2, float shift, float tolerance, vector<int> &idx1, vector<int> &idx2);
int FindMatchPeaksAll2(Spectrum &spec1, Spectrum &spec2, float shift, float tolerance, vector<int> &idx1, vector<int> &idx2);

void FindMatchPeaks(Spectrum &spec1, Spectrum &spec2, float shift, float tolerance, vector<int> &idx1, vector<int> &idx2);

TwoValues<int> computeShifts(Spectrum &spec1, Spectrum &spec2, float peakTol, float pmTol,
                     float minRatio, float minPeakAreaOvlp, int minNumMatchedPeaks,
                     AAJumps &validJumps, list<float> &shiftScores, list<TwoValues<unsigned int> > &shiftPairs, 
                     vector<list<TwoValues<int> > > &shiftMatchedPeaks, 
                     TwoValues<float> &bestCandidateScores, TwoValues<int> &bestCandidateMP, float minAbsShift=0);
void computeShifts_cleanup();

void computeShifts2(Spectrum &spec1, Spectrum &spec2, vector<float> &shiftsList, float resolution=0.1);

float ScoreOverlap6(Spectrum &spec1, vector<int> idx1all, Spectrum &spec2, vector<int> idx2all, 
                    float shift, float tolerance, vector<int> &idxMatched1, vector<int> &idxMatched2, 
                    float minIPdist = AAJumps::minAAmass, float *offsetPenalty=0);
float ScoreOverlap7(Spectrum &spec1, vector<int> idx1all, Spectrum &spec2, vector<int> idx2all, float shift, float tolerance, 
                     vector<int> &idxMatched1, vector<int> &idxMatched2, float symmetryOffset=0);

float getMaxSparseSet(Spectrum &spec, float tolerance, float pmOffset, vector<int> &idxMatched,
                       bool includeSymmetric=false);

#endif
