#ifndef AMINOACID_H
#define AMINOACID_H

#include "utils.h"

#include <vector>
#include <string>

using namespace std;

//
// getMasses - Transform zero terminated string into vector of amino acid masses
//
void getMasses(char *sequence, vector<float> &masses);

// Define sets of valid mass jumps based on amino acid and modifications masses
class AAJumps {
public:
    static const short NO_MODS=0, USE_MODS=1;
    static const double massHion =  1.0072763,
                        massH2O  = 18.010564686,
                        minAAmass= 57.0214637230,
                        massMH = 18.010564686+1.0072763;
    short modsUsed;

    vector<float> masses;               // List of valid amino acid jumps' masses
    vector<char> aaLetters;             // Amino acid letters for the single-residue jumps

    AAJumps(short maxJumpSize, float resolution=0.1, short useMods=NO_MODS);

    void getjumps(short maxJumpSize, float resolution=0.1, short useMods=NO_MODS);
	void alljumps(float maxJumpMass, float resolution=0.1, short useMods=NO_MODS);

    float &operator[](const int i) { return masses[i]; }
    const unsigned int size() { return masses.size(); }

    void forceUnique(float resolution=0.1) { masses = Utils::unique(masses,resolution); }
    void forceDoubleSided();                                      // Makes masses = [-masses; masses];
    void forceJump(float mass) { masses.push_back(mass); sort(masses.begin(),masses.end()); }        // Adds a given mass to the set of valid jumps
    void forceJumps(vector<float> newMasses);                     // Adds a set of given masses to the set of valid jumps
    void forceTolerance(float tolerance, float resolution=0.1);   // Every mass m in masses is replaced by a set of masses m+[-tolerance:resolution:tolerance]

	void removeHigherJumps(float largestJump);

	// Test whether a given mass is a valid jump in the current set
	bool isValid(float mass, float tolerance);
	unsigned int find(float mass, float tolerance, TwoValues<unsigned int> &idxBounds);
};
#endif
