#ifndef BATCH_H
#define BATCH_H

#include "spectrum.h"
#include <vector>
#include <list>
#include <fstream>

using namespace std;

class PairAlignRes {
public:
    float score;
    vector<int> idxMatched1,idxMatched2;
};

class PairAlign {
public:
    int spec1,spec2;
    vector<float> shifts;
    vector<PairAlignRes> results;
    
    PairAlign() { }
};


class Results_SP {
public:
    int spec1,spec2;
    float score1, score2;
    
    virtual Results_SP &operator=(const Results_SP &other) { spec1=other.spec1; spec2=other.spec2; score1=other.score1; score1=other.score2; return *this; }
    virtual void output(ofstream &out, char separator) { out<<spec1+1<<separator<<spec2+1<<separator<<score1<<separator<<score2<<endl; }
};

class Results_ASP : public Results_SP {
public:
    float shift1;

    virtual Results_ASP &operator=(const Results_ASP &other) { spec1=other.spec1; spec2=other.spec2; score1=other.score1; score1=other.score2; shift1=other.shift1; return *this; }
    virtual void output(ofstream &out, char separator) { out<<spec1+1<<separator<<spec2+1<<separator<<shift1<<separator<<score1<<separator<<score2<<endl; }
};

class Results_PA : public Results_ASP {
public:
    float shift2;

    virtual Results_PA &operator=(const Results_PA &other) { spec1=other.spec1; spec2=other.spec2; score1=other.score1; score1=other.score2; shift1=other.shift1; shift2=other.shift2; return *this; }
    virtual void output(ofstream &out, char separator) { out<<spec1+1<<separator<<spec2+1<<separator<<shift1<<separator<<shift2<<separator<<score1<<separator<<score2<<endl; }
};

class Results_CS : public Results_PA {  
public:
    int specC;
	bool spec2rev;

    void output(ofstream &out, char separator) { out<<spec1+1<<separator<<spec2+1<<separator<<specC+1<<separator<<shift1<<separator<<shift2<<separator<<score1<<separator<<score2<<endl; }
};


bool Load_pabatch(char *filename, vector<PairAlign> &aligns);
bool Save_results(char *filename, vector<PairAlign> &aligns);
bool Save_resultsCS(char *filename, list<Results_CS> &aligns, char sep);
bool Load_resultsASP(char *filename, vector<Results_ASP> &results);
bool Load_resultsASPbin(char *filename, vector<Results_ASP> &results);
bool Load_resultsPA(char *filename, vector<Results_PA> &results);
bool Save_resultsASPbin(char *filename, list<Results_ASP> &results);
bool Save_resultsASPbin(char *filename, vector<Results_ASP> &results);

template<class T> int Save_binArray(char *filename, vector<vector<T> > &data);
template<class T> int Save_binArray(char *filename, vector<T> &data);
template<class T> int Save_binArray(char *filename, vector<TwoValues<T> > &data);
template<class T> int Save_binArray(char *filename, list<TwoValues<T> > &data);
template<class T> int Save_binArray(char *filename, list<vector<T> > &data);
template<class T> int Load_binArray(char *filename, vector<vector<T> > &data);

template<class T1,class T2,class T3> int Load_binListArray(char *filename, vector<T2> &data);
template<class T1,class T2,class T3> int Save_binListArray(char *filename, vector<T2> &data);
template<class T1,class T2,class T3> int Save_binListArray(char *filename, list<T2> &data);

void getPairAlignsPA2(SpecSet &specSet, unsigned int startIdx, unsigned int endIdx, 
                        float peakTol, float pmTol, float minRatio, float minPeakAreaOvlp, 
                        short minNumMatchedPeaks, AAJumps &allowedJumps, float minAbsShift,
						list<Results_PA> &results, list<TwoValues<float> > &ratios, list<TwoValues<int> > &numMatchedPeaks,
						vector<TwoValues<float> > &means, vector<float> &varTerms,
						list<vector<float> > &alignStats, vector<vector<float> > &specStats);

class BufferedLineReader {
	char *lines;
	vector<unsigned int> linesIdx;
public:
	BufferedLineReader() { lines=(char*)0; }
	~BufferedLineReader() { reset(); }
	
	void reset() { if(lines) free(lines); lines=(char*)0; linesIdx.resize(0); }
	unsigned int size() { return linesIdx.size(); }
	
	char *getline(unsigned int lineNum) { if(lineNum>=linesIdx.size()) return (char*)0; else return &lines[linesIdx[lineNum]]; }
	short Load(char *filename);
};

#endif
