#include "batch.h"
#include "spectrum.h"
#include "mzxml.h"

#include <iostream>
#include <fstream>
#include <vector>
#include <cstdio>
#include <cstring>

using namespace std;

int main(int argc, char **argv){
	SpecSet specs;
	
	if(argc<4) {
		cerr<<"Syntax: "<<argv[0]<<" <file_type> <input_file_name> <output_pklbin_file_name>\n";
		cerr<<"        file_type: mgf, ms2, mzxml, pkl (multiple spectra per file), prms (pepnovo_prm output format)\n";
		return -1;
	}
	for(unsigned int index=0; argv[1][index]!=(char)0; index++) argv[1][index]=tolower(argv[1][index]);
	
	bool loadOk = false;
	if(strcmp(argv[1],"mgf")==0) {
		if(specs.LoadSpecSet_mgf(argv[2])<=0) { cerr<<"ERROR loading "<<argv[2]<<"!\n"; return -1; }
		else loadOk=true;
	}
	
	if(strcmp(argv[1],"ms2")==0) {
		if(specs.LoadSpecSet_ms2(argv[2])<=0) { cerr<<"ERROR loading "<<argv[2]<<"!\n"; return -1; }
		else loadOk=true;
	}
	
	if(strcmp(argv[1],"pkl")==0) {
		if(specs.LoadSpecSet_pkl(argv[2])<=0) { cerr<<"ERROR loading "<<argv[2]<<"!\n"; return -1; }
		else loadOk=true;
	}
	
	if(strcmp(argv[1],"prms")==0) {
		if(specs.LoadSpecSet_prms(argv[2])<=0) { cerr<<"ERROR loading "<<argv[2]<<"!\n"; return -1; }
		vector<unsigned int> keptIdx(specs.size());
		for(unsigned int index=0;index<specs.size();index++) keptIdx[index]=specs[index].scan;
		Save_binArray("kept_indices.bin",keptIdx);
		loadOk=true;
	}

	vector<short> msLevel;
	if(strcmp(argv[1],"mzxml")==0) {
		if( LoadMzxml(argv[2], specs, &msLevel, 1) == 0 ) { cerr<<"ERROR loading "<<argv[2]<<"!\n"; return -1; }
		else loadOk=true;
	}

	if(loadOk) specs.SaveSpecSet_pklbin(argv[3]);
	else { cerr<<"ERROR parsing file_type; valid options are ms2, mgf, mzxml, pkl or prms.\n"; return -1; }
	
    return(0);
}
