#ifndef DB_FASTA_H
#define DB_FASTA_H

#include "aminoacid.h"
#include "spectrum.h"
#include <vector>
#include <cstdio>
#include <iostream>

using namespace std;

class DB_fasta {
protected:
	static char emptyStr[];

    vector<char *> IDs;
    vector<char *> desc;
    vector<char *> sequences;
    vector<Spectrum> masses;   // Contains the proteins' cumulative masses as a Spectrum

public:
    ~DB_fasta();

    char *operator[](char *id);
    char *operator[](int index) { return sequences[index]; }
    void getMassesIdx(int index, vector<float> &putHere) { getMasses(sequences[index],putHere); }
    Spectrum &getMassesSpec(int index);
    void replaceAA(char prevAA, char repAA);

    char *getID(int index) { return IDs[index]; }
    char *getDesc(int index) { return desc[index]; }

    unsigned int size() { return IDs.size(); }
    void reset();

    unsigned int Load(char *filename);
    void output(ostream &out);
};

class DB_index {

	class Tag {
		public:
		
		char *text;  // Tag text 
		list<pair<int,short> > insts; // List of tag instances as (protein ID, starting amino acid position)
	
		Tag() { text=(char *)0; }
		Tag(const Tag &other) { 
			if(other.text==(char *)0) { text=(char *)0; insts.clear(); return; }
			text=(char *)malloc(strlen(other.text)+1); strcpy(text,other.text); insts = other.insts;
		}
		~Tag() { if(text!=(char *)0) free(text); }
		void setTag(char *newText, short textLen) { if (text!=(char *)0) free(text); text=(char*)malloc(textLen+1); strcpy(text,newText); }
		void addInst(int protId, short tagPos) { pair<int,short> tmp(protId,tagPos); insts.push_back(tmp); }
		void addInst(pair<int,short> &newInstance) { insts.push_back(newInstance); }
		bool operator==(const Tag &other) { return strcmp(text,other.text)==0; }
		Tag &operator=(const Tag &other) { if(text!=(char *)0) free(text); text=(char *)malloc(strlen(other.text)+1); strcpy(text,other.text); insts = other.insts;	return *this; }
	};

	vector<vector<vector<Tag> > > index;
	vector<short> coeffs1, coeffs2;  // Coefficients for hash1 and hash2
	short tagLength, indexDim1, indexDim2;

	void hash_init(short tagLength);
	short hash(short hashIdx, char *tag);
	bool compareTags(char *tag1, char *tag2) { for(short tagIndex=0; tagIndex<tagLength; tagIndex++) if(tag1[tagIndex]!=tag2[tagIndex]) return false; return true; }
	void doNothing(char *t) { }
public:

	DB_index(DB_fasta &db, short newIndexDim1, short newIndexDim2, short newTagLength);
	
	void buildIndex(DB_fasta &db, short newIndexDim1, short newIndexDim2, short newTagLength);
	
	void insert(char *tag, int proteinID, short tagPos);
	bool find(char *tag, list<pair<int,short> > **location);
	bool find(char *tag, DB_fasta &db, list<pair<int,string> > &peptides, short minMatchFlanking, 
	            float flankPref, float tolPref, float flankSuff, float tolSuff);
};

void MaximumParsimony(vector<list<int> > &proteinHits);

#endif
