#include "alignment_scoring.h"
#include "batch.h"
//#include "filters.h"
//#include "clusters.h"
#include "inputParams.h"

#include <iostream>
#include <fstream>
#include <cmath>
#include <ctime>

using namespace std;

int main(int argc, char **argv){
	const short MIN_AA_DIST = 0;
	InputParams params;
	vector<char *> paramStrs;   paramStrs.resize(1);
	
	paramStrs[0] = "OUTPUT_ALIGNS";
	if(argc==1)	params.readParams("filterpairs.params"); else params.readParams(argv[1]);
	if(!params.confirmParams(paramStrs)) {
		cerr << "ERROR: Parameters file ";
		if(argc==1) cerr<<"filterpairs.params"; else cerr<<argv[1];
		cerr << " is incomplete. One of the following is missing: OUTPUT_ALIGNS\n";
		return -1;
	}

	char *clustersFN = params.getValue("INPUT_CLUSTERS");  bool procClusters=params.paramPresent("INPUT_CLUSTERS");
	char *alignsFN = params.getValue(paramStrs[0]);

	int startIdx = params.paramPresent("IDX_START")?params.getValueInt("IDX_START"):0;	
	int endIdx = params.paramPresent("IDX_END")?params.getValueInt("IDX_END"):-1;
	float minRatio = params.paramPresent("MIN_RATIO")?(float) params.getValueDouble("MIN_RATIO"):0.3;
	float minOverlap = params.paramPresent("MIN_OVERLAP_AREA")?(float) params.getValueDouble("MIN_OVERLAP_AREA"):0;
	short minNumMatchedPeaks = params.paramPresent("MIN_NUM_MATCHED_PEAKS")?(short) params.getValueInt("MIN_NUM_MATCHED_PEAKS"):0;
	float minAbsShift = params.paramPresent("MIN_SHIFT")?(float) params.getValueDouble("MIN_SHIFT"):0;
	float peakTol = params.paramPresent("TOLERANCE_PEAK")?(float) params.getValueDouble("TOLERANCE_PEAK"):0.5;
	float pmTol = params.paramPresent("TOLERANCE_PM")?(float) params.getValueDouble("TOLERANCE_PM"):1;
	float resolution = params.paramPresent("RESOLUTION")?(float) params.getValueDouble("RESOLUTION"):0.1;
    int specType = params.paramPresent("SPEC_TYPE_MSMS")?((int) params.getValueInt("SPEC_TYPE_MSMS")?1:0):0;
	float ionOffset = specType?AAJumps::massHion:0;
    
    SpecSet specSet;   short loadOk=0;
    if(params.paramPresent("INPUT_SPECS")) loadOk=specSet.LoadSpecSet_pkl(params.getValue("INPUT_SPECS"));
    else loadOk=specSet.LoadSpecSet_pklbin(params.getValue("INPUT_SPECS_PKLBIN"));
    if (loadOk<=0 or specSet.size()==0) { cerr<<"ERROR reading input spectra!\n"; return -1; }
	for(unsigned int i=0; i<specSet.size(); i++) specSet[i].addZPMpeaks(peakTol,ionOffset,true); 

    if(endIdx<0) endIdx = specSet.size()-1;
	AAJumps jumps(0);

	list<Results_PA> results;   
	list<TwoValues<float> > ratios;
	list<TwoValues<int> > numMatchedPeaks;
	vector<TwoValues<float> > meansClst, meansSpecs;
	vector<float> varTerms;
	list<vector<float> > alignStats;    alignStats.clear();
	vector<vector<float> > specStats;   specStats.resize(0);

	getPairAlignsPA2(specSet, startIdx, endIdx, peakTol, pmTol, minRatio, minOverlap, minNumMatchedPeaks, jumps, minAbsShift, results, ratios, numMatchedPeaks, meansSpecs, varTerms, alignStats, specStats);
	
    ofstream output;
    output.open(alignsFN);  output << results.size() << endl; 
	for(list<Results_PA>::iterator i=results.begin(); i!=results.end(); i++) 
		if(procClusters) { (*i).shift1*=resolution; (*i).shift2*=resolution; (*i).output(output,';'); }
		else (*i).output(output,';');
    output.close();

	char *filename = params.getValue("OUTPUT_RATIOS");
	if(params.paramPresent("OUTPUT_RATIOS")) {
	    output.open(filename);
	    for(list<TwoValues<float> >::iterator r = ratios.begin(); r!=ratios.end(); r++) output<<(*r)[0]<<" "<<(*r)[1]<<endl; 
	    output.close();
	}

	filename = params.getValue("OUTPUT_NUM_MATCHED_PEAKS");
	if(params.paramPresent("OUTPUT_NUM_MATCHED_PEAKS")) {
	    output.open(filename);
	    for(list<TwoValues<int> >::iterator r = numMatchedPeaks.begin(); r!=numMatchedPeaks.end(); r++) output<<(*r)[0]<<" "<<(*r)[1]<<endl; 
	    output.close();
	}

	filename = params.getValue("OUTPUT_MEANS_CLUSTERS"); 
	if(params.paramPresent("OUTPUT_MEANS_CLUSTERS")) {
	    output.open(filename);
        for(unsigned int i=0; i<meansClst.size(); i++) output << meansClst[i][0] << " " << meansClst[i][1] << endl;
	    output.close();
	}

	filename = params.getValue("OUTPUT_MEANS");
	if(params.paramPresent("OUTPUT_MEANS")) {
	    output.open(filename);
        for(unsigned int i=0; i<meansSpecs.size(); i++) output << meansSpecs[i][0] << " " << meansSpecs[i][1] << endl;
	    output.close();
	}

	filename = params.getValue("OUTPUT_VARIANCE");
	if(params.paramPresent("OUTPUT_VARIANCE")) {
	    output.open(filename);
        for(unsigned int i=0; i<varTerms.size(); i++) output << varTerms[i] << endl;
	    output.close();
	}

    return(0);
}
