#include "graph.h"
#include "setmerger.h"
#include <cmath>
#include <iostream>
#include <fstream>

void Graph::build(vector<Results_ASP> &aligns) {
	edges.resize(aligns.size());   eScores.resize(aligns.size());
	int maxVertexIdx=0; 
	for(unsigned int i=0; i<aligns.size(); i++) {
		edges[i].set(aligns[i].spec1,aligns[i].spec2);
		eScores[i] = aligns[i].score1 + aligns[i].score2;
		maxVertexIdx=max(maxVertexIdx,aligns[i].spec1);
		maxVertexIdx=max(maxVertexIdx,aligns[i].spec2);
	}

	vNext.resize(maxVertexIdx+1);   vScores.resize(maxVertexIdx+1);
	vector<int> countNext(vNext.size());
	for(unsigned int i=0; i<vNext.size(); i++) { countNext[i]=0; vScores[i]=0; }
	for(unsigned int i=0; i<edges.size(); i++) { countNext[edges[i][0]]++; }
	for(unsigned int i=0; i<vNext.size(); i++) { vNext[i].resize(countNext[i]); }
	
	for(unsigned int i=0; i<vNext.size(); i++) { countNext[i]=0; }
	for(unsigned int i=0; i<edges.size(); i++) {
		vNext[edges[i][0]][countNext[edges[i][0]]] = i;
		countNext[edges[i][0]]++; 
	}
}

void Graph::add(vector<Results_PA> &aligns) {
	unsigned int newEdgeBase = edges.size();

	edges.resize(edges.size()+aligns.size());   eScores.resize(edges.size()+aligns.size());
	int maxVertexIdx=vNext.size(); 
	for(unsigned int i=0; i<aligns.size(); i++) {
		edges[newEdgeBase+i].set(aligns[i].spec1,aligns[i].spec2);
		eScores[i] = aligns[i].score1 + aligns[i].score2;
		maxVertexIdx=max(maxVertexIdx,aligns[i].spec1);
		maxVertexIdx=max(maxVertexIdx,aligns[i].spec2);
	}

	unsigned int newVertexBase = vNext.size();
	vNext.resize(maxVertexIdx+1);   vScores.resize(maxVertexIdx+1);  
	vector<int> countNext(vNext.size());
	for(unsigned int i=0; i<newVertexBase; i++) countNext[i]=vNext[i].size();
	for(unsigned int i=newVertexBase; i<vNext.size(); i++) { countNext[i]=0; vScores[i]=0; }
	for(unsigned int i=newEdgeBase; i<edges.size(); i++) { countNext[edges[i][0]]++; }
	for(unsigned int i=0; i<vNext.size(); i++) { vNext[i].resize(countNext[i]); }
	
	for(unsigned int i=0; i<vNext.size(); i++) { countNext[i]=0; }
	for(unsigned int i=0; i<edges.size(); i++) {
		vNext[edges[i][0]][countNext[edges[i][0]]] = i;
		countNext[edges[i][0]]++; 
	}
}

void Graph::findConnectedPairs(unsigned int pathLength, unsigned int minNumPaths, 
								vector<vector<int> > &vSets, vector<int> &numPaths) {
	unsigned int numVerts = vNext.size();

	vector<vector<int> > vPreds(numVerts);
	vector<int> predCounts(numVerts);	for(unsigned int i=0; i<numVerts; i++) predCounts[i]=0;
	for(unsigned int i=0; i<edges.size(); i++) predCounts[edges[i][1]]++;
	for(unsigned int i=0; i<numVerts; i++) { vPreds[i].resize(predCounts[i]); predCounts[i]=0; }
	for(unsigned int i=0; i<edges.size(); i++) { vPreds[edges[i][1]][predCounts[edges[i][1]]++]=i; }

	vector<vector<vector<TwoValues<int> > > > pathCounts;
	pathCounts.resize(numVerts);
	
	unsigned int plIdx,predIdx,curVPred,pathPredIdx;
	vector<vector<int> > curCounts;
	curCounts.resize(numVerts); for(unsigned int i=0; i<numVerts; i++) curCounts[i].resize(pathLength+1); 
	
	for(unsigned int v=0; v<numVerts; v++) {
		for(unsigned int i=0; i<numVerts; i++)
			for(plIdx=0; plIdx<=pathLength; plIdx++) curCounts[i][plIdx]=0;

		for(predIdx=0; predIdx<vPreds[v].size(); predIdx++) {
			curVPred = edges[vPreds[v][predIdx]][0];
			curCounts[curVPred][1] = 1;   curCounts[curVPred][0] = 1;
			for(unsigned int i=0; i<pathCounts[curVPred].size(); i++) {
				for(plIdx=2; plIdx<=pathLength; plIdx++) {
					curCounts[ pathCounts[curVPred][i][plIdx-1][0] ][plIdx] += pathCounts[curVPred][i][plIdx-1][1];
					curCounts[ pathCounts[curVPred][i][plIdx-1][0] ][0] += pathCounts[curVPred][i][plIdx-1][1];
				}
			}
		}

		pathPredIdx=0;
		for(unsigned int i=0; i<numVerts; i++) if(curCounts[i][0]>0) pathPredIdx++;

		pathCounts[v].resize(pathPredIdx);   pathPredIdx=0;
		for(predIdx=0,pathPredIdx=0; predIdx<numVerts; predIdx++) {
			if(curCounts[predIdx][0]>0) {
				pathCounts[v][pathPredIdx].resize(pathLength+1);
				for(plIdx=0; plIdx<=pathLength; plIdx++)
					{ pathCounts[v][pathPredIdx][plIdx].set(predIdx, curCounts[predIdx][plIdx] ); }
				pathPredIdx++;
			}
		}

	}
	pathPredIdx=0;   vector<bool> hasPairs(numVerts);
	for(unsigned int v=0; v<numVerts; v++)
		for(predIdx=0; predIdx<pathCounts[v].size(); predIdx++) 
			if(pathCounts[v][predIdx][pathLength][1]>=(int)minNumPaths)
				{ pathPredIdx++; hasPairs[v]=true; }
	vSets.resize(pathPredIdx);   numPaths.resize(pathPredIdx);   pathPredIdx=0;

	TwoValues<int> pair;
	vector<vector<bool> > succs(pathLength);
	for(unsigned int i=0; i<pathLength; i++) succs[i].resize(numVerts);
	vector<list<int> > toProcess(pathLength);
	unsigned int commonCount;
	vector<bool> common(vNext.size());
	for(unsigned int i=1; i<numVerts; i++) common[i]==false;
	
	for(unsigned int v=0; v<numVerts; v++) {
		if(!hasPairs[v]) continue;
		for(predIdx=0; predIdx<pathCounts[v].size(); predIdx++) 
			if(pathCounts[v][predIdx][pathLength][1]>=(int)minNumPaths) {
				pair.set(pathCounts[v][predIdx][0][0],v);
				numPaths[pathPredIdx]=pathCounts[v][predIdx][0][1];
				
				toProcess[0].clear();
				for(unsigned int i=0; i<vNext[pair[0]].size(); i++) { toProcess[0].insert(toProcess[0].begin(),edges[vNext[pair[0]][i]][1]); }
				for(unsigned int i=0; i<pathLength; i++) for(unsigned int j=0; j<numVerts; j++) succs[i][j]=false;
				for(plIdx=0; plIdx<pathLength; plIdx++) {
					if(plIdx<pathLength-1) toProcess[plIdx+1].clear();
					for(list<int>::iterator iter=toProcess[plIdx].begin(); iter!=toProcess[plIdx].end(); iter++) {
						if(succs[plIdx][*iter]) continue; else succs[plIdx][*iter]=true;
						if(plIdx<pathLength-1)
							for(unsigned int i=0; i<vNext[*iter].size(); i++)
								{ toProcess[plIdx+1].insert(toProcess[plIdx+1].begin(),edges[vNext[*iter][i]][1]); }
					}
				}
				
				commonCount=0;    common[pair[0]]=true;   common[pair[1]]=true;
				for(unsigned int i=1; i<pathCounts[v].size(); i++) {
					for(unsigned int j=0; j<pathLength; j++) 
						if(succs[pathLength-1-j][pathCounts[v][i][j][0]] and !common[pathCounts[v][i][j][0]]) 
							{ commonCount++; common[pathCounts[v][i][j][0]]=true; break; }
				}

				vSets[pathPredIdx].resize(commonCount+2);   commonCount=2;
				vSets[pathPredIdx][0]=pair[0];              common[pair[0]]=false;
				vSets[pathPredIdx][1]=pair[1];              common[pair[1]]=false;
				for(unsigned int i=1; i<numVerts; i++) 
					if(common[i]) { 
						vSets[pathPredIdx][commonCount++]=i; 
						common[i]=false; 
					}
				pathPredIdx++;
			}
	}
}

void Graph::output_graphviz(char *filename){
	ofstream out(filename);
	if(!out) { cerr<<"Error opening "<<filename<<"!\n"; return; }
	out << "digraph G {\n";

	for(int eIdx=0; eIdx<(int)edges.size(); eIdx++)
		out << edges[eIdx][0]<<" -> "<<edges[eIdx][1]<<" [label = \""<<eScores[eIdx]<<"\"];\n";

	out << "}\n";
	out.close();
}

void MSGraph::ConnectConsecutive(Spectrum &spec){
	unsigned int numPeaks = spec.size();
	vNext.resize(numPeaks);     vScores.resize(numPeaks);    
	edges.resize(numPeaks-1);   eMasses.resize(numPeaks-1);

	for(unsigned int p=0; p<numPeaks-1; p++) { 
		vNext[p].resize(1);    vNext[p][0]=p;     vScores[p]=spec[p][1];  
		edges[p].set(p,p+1);   eMasses[p]=spec[p+1][0]-spec[p][0];
		eScores[p] = spec[p+1][1];   if(p==0) eScores[p]+=vScores[p];
	}
	vNext[numPeaks-1].resize(0);  vScores[numPeaks-1]=spec[numPeaks-1][1];
}

void MSGraph::ConnectJumps(Spectrum &spec, AAJumps &jumps, float peakTol){
	unsigned int numPeaks = spec.size(), numEdges=0;
	vector<int> inDegree(numPeaks); for(unsigned int i=0;i<numPeaks;i++) inDegree[i]=0;
	vNext.resize(numPeaks);     vScores.resize(numPeaks);    
	edges.resize(numPeaks*(numPeaks-1));   eMasses.resize(numPeaks*(numPeaks-1));   eScores.resize(numPeaks*(numPeaks-1));

	for(unsigned int p=0; p<numPeaks-1; p++) {
		unsigned int jumpIdx=0, nextPeak=p+1, numSuccs=0;
		vNext[p].resize(numPeaks-1-p);
		while (nextPeak<numPeaks) {
			while (jumpIdx>0 and spec[nextPeak][0]-spec[p][0]-jumps[jumpIdx]<-peakTol) jumpIdx--;
			if(spec[nextPeak][0]-spec[p][0]-jumps[jumpIdx]<-peakTol)
				{ nextPeak++; continue; }
			while (jumpIdx<jumps.size() and spec[nextPeak][0]-spec[p][0]-jumps[jumpIdx]>peakTol) jumpIdx++;
			if(jumpIdx>jumps.size()) break;

			if(abs(spec[nextPeak][0]-spec[p][0]-jumps[jumpIdx])<=peakTol) {
				vNext[p][numSuccs++] = numEdges;
				edges[numEdges].set(p,nextPeak);   inDegree[nextPeak]++;
				eMasses[numEdges] = spec[nextPeak][0]-spec[p][0];
				eScores[numEdges] = spec[nextPeak][1];  if(inDegree[p]==0) eScores[numEdges]+=spec[p][1];
				numEdges++;
			} 
			nextPeak++;
		}
		vNext[p].resize(numSuccs);   vScores[p]=spec[p][1];
	}
	edges.resize(numEdges);   eMasses.resize(numEdges);   eScores.resize(numEdges);
	vNext[numPeaks-1].resize(0);  vScores[numPeaks-1]=spec[numPeaks-1][1];
}

void MSGraph::consolidateEdgeScores() {
	vector<int> numPreds(vNext.size());
	
	for(unsigned int i=0; i<numPreds.size(); i++) numPreds[i]=0;
	for(unsigned int i=0; i<edges.size(); i++) numPreds[edges[i][1]]++;
	for(unsigned int i=0; i<edges.size(); i++) {
		eScores[i] = eScores[i]*max((double)vScores[edges[i][1]],0.01);
		if(numPreds[edges[i][0]]==0) eScores[i]+=vScores[edges[i][0]];
	}
}

float MSGraph::heaviestPath(MSGraph &path, bool useVertexScores, Spectrum *resultSpec, vector<int> *pathVertIdx) {
	vector<TwoValues<int> > predsToProcess(vNext.size());
	vector<TwoValues<int> > bestPred(vNext.size());
	vector<float> bestPathScore(vNext.size());
	list<int> sources;
	vector<float> eScoresHP(edges.size());
	unsigned int processedVertices = 0,bestPathIdx = 0;

	if(edges.size()==0) { 
		path.edges.resize(0);   path.eScores.resize(0);   path.eMasses.resize(0);
		path.vNext.resize(0);   path.vScores.resize(0);
		if(resultSpec) resultSpec->resize(0);   if(pathVertIdx) pathVertIdx->resize(0);
		return 0;
	}

	for(unsigned int i=0; i<vNext.size(); i++) {
		predsToProcess[i].set(0,0);   bestPred[i].set(-1,0);   bestPathScore[i] = 0;
	}
	for(unsigned int i=0; i<edges.size(); i++) 
		if(edges[i][0]!=edges[i][1])
			{ predsToProcess[edges[i][1]][0]++; predsToProcess[edges[i][1]][1]++; } 
	for(unsigned int i=0; i<vNext.size(); i++) 
		if(predsToProcess[i][0]==0) { sources.push_front(i); processedVertices++; }
	if(edgeInPath.size()!=edges.size()) edgeInPath.resize(edges.size());
	if(!useVertexScores) for(unsigned int i=0; i<edges.size(); i++) { eScoresHP[i] = eScores[i]; edgeInPath[i]=false; }
	else for(unsigned int i=0; i<edges.size(); i++) {
		eScoresHP[i] = max((double)vScores[edges[i][1]],0.01);
		if(predsToProcess[edges[i][0]][1]==0) eScoresHP[i]+=vScores[edges[i][0]];
		edgeInPath[i]=false;
	}

	while (sources.size()>0) {
		int curVert=sources.front();   sources.pop_front();
		if(bestPathScore[curVert]>bestPathScore[bestPathIdx]) bestPathIdx=curVert;
		
		for(unsigned int succIdx=0; succIdx<vNext[curVert].size(); succIdx++) {
			int edgeIdx = vNext[curVert][succIdx], nextVert = edges[edgeIdx][1];
			if(edges[edgeIdx][0]==edges[edgeIdx][1]) continue;
			if(predsToProcess[nextVert][0]==0) continue;
			if(bestPathScore[curVert]+eScoresHP[edgeIdx] > bestPathScore[nextVert]) {
				bestPred[nextVert].set(edgeIdx,bestPred[curVert][1]+1);
				bestPathScore[nextVert] = bestPathScore[curVert]+eScoresHP[edgeIdx];
			}
			predsToProcess[nextVert][0]--;
			if(predsToProcess[nextVert][0]==0) { sources.push_front(nextVert); processedVertices++; }
		}
		
		if(sources.size()==0 and processedVertices!=vNext.size()) {
			float minPredRatio=1;  int minPredIdx=-1;
			for(unsigned int i=0; i<predsToProcess.size(); i++) 
				if(predsToProcess[i][0]>0 and (((float)predsToProcess[i][0])/((float)predsToProcess[i][1]))<=minPredRatio) 
					{ minPredRatio = (((float)predsToProcess[i][0])/((float)predsToProcess[i][1])); minPredIdx=i; }
			cerr << "WARNING: heaviestPath may perform incorrectly if the graph contains cycles! Unblocked vertex "<<minPredIdx<<" with "<<predsToProcess[minPredIdx][0]<<" predecessors unresolved (minPredRatio = "<<minPredRatio<<").\n";
			sources.push_front(minPredIdx); processedVertices++;   predsToProcess[minPredIdx][0]=0;
		}
	}
	
	int pathPivot = bestPred[bestPathIdx][0], pathVert=0, pathEdge=0;
	if(pathPivot<0) return -1;
	int curVert = edges[pathPivot][0], succVert = edges[pathPivot][1];

	path.edges.resize(bestPred[bestPathIdx][1]);    path.eScores.resize(path.edges.size());   path.eMasses.resize(path.edges.size());
	path.vNext.resize(bestPred[bestPathIdx][1]+1);  path.vScores.resize(path.vNext.size());
	if(vLabels.size()>0) path.vLabels.resize(path.vNext.size());         
	if(vPeakLabels.size()>0) path.vPeakLabels.resize(path.vNext.size());
	if(resultSpec) resultSpec->resize(path.vNext.size());
	if(pathVertIdx) pathVertIdx->resize(path.vNext.size());
	
	path.vNext[pathVert].resize(0);                 path.vScores[pathVert] = vScores[succVert];
	if(vLabels.size()>0) path.vLabels[pathVert] = vLabels[succVert];     
	if(vPeakLabels.size()>0) path.vPeakLabels[pathVert] = vPeakLabels[succVert];
	if(resultSpec) (*resultSpec)[path.vNext.size()-1].set(eMasses[pathPivot],path.vScores[pathVert]);
	if(pathVertIdx) (*pathVertIdx)[path.vNext.size()-1] = succVert;
	pathVert++;
	while(pathPivot>=0) {
		edgeInPath[pathPivot] = true;
		path.vNext[pathVert].resize(1);               path.vNext[pathVert][0]=pathEdge;
		path.vScores[pathVert] = vScores[curVert];
		if(vLabels.size()>0) path.vLabels[pathVert] = vLabels[curVert];    
		if(vPeakLabels.size()>0) path.vPeakLabels[pathVert] = vPeakLabels[curVert];
		
		path.edges[pathEdge].set(pathVert,pathVert-1);    
		path.eScores[pathEdge] = eScores[pathPivot];  path.eMasses[pathEdge] = eMasses[pathPivot];

		if(pathVertIdx) (*pathVertIdx)[path.vNext.size()-1-pathVert] = curVert;

		pathVert++;   pathEdge++;   pathPivot = bestPred[curVert][0];   if (pathPivot>=0) curVert = edges[pathPivot][0];
		if(resultSpec) {
			if (pathPivot>=0) (*resultSpec)[path.vNext.size()-pathVert].set(eMasses[pathPivot],path.vScores[pathVert-1]);
			else (*resultSpec)[path.vNext.size()-pathVert].set(0,path.vScores[pathVert-1]); }
	}

	if(resultSpec) {
		for(unsigned int i=1;i<resultSpec->size();i++) (*resultSpec)[i][0]+=(*resultSpec)[i-1][0];
		resultSpec->parentMass = (*resultSpec)[resultSpec->size()-1][0]+19;
	}
	return bestPathScore[bestPathIdx];
}

void MSGraph::findConnected(vector<MSGraph> &components) {
	SetMerger helper(vNext.size());
	for(unsigned int v=0; v<vNext.size(); v++) helper.createset(v);
	for(unsigned int e=0; e<edges.size(); e++)
		helper.merge(helper.membership[edges[e][0]],helper.membership[edges[e][1]]);
	helper.compressSetIndices();
	
	components.resize(helper.numSets);   vector<int> edgeCount(helper.numSets), vCount(helper.numSets);
	vector<int> vRename(vNext.size());

	for(unsigned int cIdx=0; cIdx<components.size(); cIdx++) { edgeCount[cIdx]=0; vCount[cIdx]=0; }
	for(unsigned int e=0; e<edges.size(); e++) edgeCount[helper.membership[edges[e][0]]]++;
	for(unsigned int v=0; v<vNext.size(); v++) vRename[v]=vCount[helper.membership[v]]++;
	
	unsigned int setIdx;
	for(setIdx=0; setIdx<components.size(); setIdx++) { 
		components[setIdx].edges.resize(edgeCount[setIdx]);
		if(eScores.size()>0) components[setIdx].eScores.resize(edgeCount[setIdx]);
		if(eMasses.size()>0) components[setIdx].eMasses.resize(edgeCount[setIdx]);
		if(edgeInPath.size()>0) components[setIdx].edgeInPath.resize(edgeCount[setIdx]);
		edgeCount[setIdx]=0; 

		components[setIdx].vNext.resize(vCount[setIdx]);
		if(vScores.size()>0) components[setIdx].vScores.resize(vCount[setIdx]);
		if(vLabels.size()>0) components[setIdx].vLabels.resize(vCount[setIdx]);
		if(vPeakLabels.size()>0) components[setIdx].vPeakLabels.resize(vCount[setIdx]);
	}
	
	for(unsigned int v=0; v<vNext.size(); v++) {
		setIdx = helper.membership[v]; int vIdx = vRename[v];
		if(vScores.size()>0) components[setIdx].vScores[vIdx] = vScores[v];
		if(vLabels.size()>0) components[setIdx].vLabels[vIdx] = vLabels[v];
		if(vPeakLabels.size()>0) components[setIdx].vPeakLabels[vIdx] = vPeakLabels[v];
		
		components[setIdx].vNext[vIdx].resize(vNext[v].size());
		for(unsigned int e=0; e<vNext[v].size(); e++) {
			int eIdx=edgeCount[setIdx]++;
			components[setIdx].edges[eIdx].set(vRename[edges[vNext[v][e]][0]],vRename[edges[vNext[v][e]][1]]);
			if(eScores.size()>0) components[setIdx].eScores[eIdx] = eScores[vNext[v][e]];
			if(eMasses.size()>0) components[setIdx].eMasses[eIdx] = eMasses[vNext[v][e]];
			if(edgeInPath.size()>0) components[setIdx].edgeInPath[eIdx] = edgeInPath[vNext[v][e]];
		}
	}
}


void MSGraph::findModPairs(vector<int> &parentMasses, float pmTol, list<vector<int> > &vSets) {
	unsigned int numVerts = vNext.size();

	int maxMassInt=parentMasses[0]; for(unsigned int i=1; i<numVerts; i++) if(maxMassInt<parentMasses[i]) maxMassInt=parentMasses[i];
	unsigned int pmTolInt = (int)ceil(10*pmTol);   maxMassInt += pmTolInt+1;

	vector<bool> existPM(maxMassInt);
	for(unsigned int i=0; i<maxMassInt; i++) existPM[i]=false; 

	vector<bool> succs(numVerts);
	vector<bool> processed(numVerts);

	vector<vector<int> > vPreds(numVerts);
	vector<int> predCounts(numVerts);	for(unsigned int i=0; i<numVerts; i++) predCounts[i]=0;
	for(unsigned int i=0; i<edges.size(); i++) predCounts[edges[i][1]]++;
	for(unsigned int i=0; i<numVerts; i++) { vPreds[i].resize(predCounts[i]); predCounts[i]=0; }
	for(unsigned int i=0; i<edges.size(); i++) { vPreds[edges[i][1]][predCounts[edges[i][1]]++]=i; }

	unsigned int baseV, succVidx, succV, pairIdx, pairV; 
	int otherPM;
	list<int> siblings;
	vector<int> curSet;
	for(baseV=0; baseV<numVerts; baseV++) {
		for(unsigned int i=0; i<numVerts; i++) processed[i]=false;
		for(succVidx=0; succVidx<vNext[baseV].size(); succVidx++) {
			succV = edges[vNext[baseV][succVidx]][1];    succs[succV]=true;
		}

		for(succVidx=0; succVidx<vNext[baseV].size(); succVidx++) {
			succV = edges[vNext[baseV][succVidx]][1];

			for(pairIdx=0; pairIdx<vNext[succV].size(); pairIdx++) {
				pairV = edges[vNext[succV][pairIdx]][1];
				if(processed[pairV]) continue;
				unsigned int siblingIdx, siblingV;
				siblings.clear();
				for(siblingIdx=0; siblingIdx<vPreds[pairV].size(); siblingIdx++) {
					siblingV = edges[vPreds[pairV][siblingIdx]][0];   if(!succs[siblingV]) continue;
					for(unsigned int i=max(0,parentMasses[siblingV]-(int)pmTolInt); i<=parentMasses[siblingV]+pmTolInt; i++) existPM[i]=true;
				}
				
				for(siblingIdx=0; siblingIdx<vPreds[pairV].size(); siblingIdx++) {
					siblingV = edges[vPreds[pairV][siblingIdx]][0];
					otherPM = parentMasses[baseV]+parentMasses[pairV]-parentMasses[siblingV];
					if(!succs[siblingV] or !existPM[otherPM]) continue;
					siblings.insert(siblings.begin(),siblingV);
				}
				
				if(siblings.size()>1) {
					list<int>::iterator iter=siblings.begin();    curSet.resize(siblings.size()+2);
					curSet[0]=baseV;  curSet[1]=pairV;
					for(unsigned int i=2; i<curSet.size(); i++)	{ curSet[i]=*iter; iter++; }
					vSets.insert(vSets.begin(),curSet);
				}
			
				processed[pairV]=true;
				for(siblingIdx=0; siblingIdx<vPreds[pairV].size(); siblingIdx++) {
					siblingV = edges[vPreds[pairV][siblingIdx]][0];   if(!succs[siblingV]) continue;
					for(unsigned int i=max(0,parentMasses[siblingV]-(int)pmTolInt); i<=parentMasses[siblingV]+pmTolInt; i++) existPM[i]=false;
				}
			}
		}

		for(succVidx=0; succVidx<vNext[baseV].size(); succVidx++) {
			succV = edges[vNext[baseV][succVidx]][1];    succs[succV]=false;
		}
	}
}

void MSGraph::output_graphviz(char *filename){
	ofstream out(filename);
	if(!out) { cerr<<"Error opening "<<filename<<"!\n"; return; }
	out << "digraph G {\n";
	
	vector<string> *labels;
	if(vLabels.size()>0) labels=&vLabels; else {
		labels = new vector<string>;   labels->resize(vNext.size());
		char *sBuf = (char *)malloc(1024);
		for(unsigned int i=0; i<vNext.size(); i++) { sprintf(sBuf,"%d",i); (*labels)[i] = string(sBuf); }
		free(sBuf);
		
		for(unsigned int i=0; i<vPeakLabels.size(); i++) {
			if(!vPeakLabels[i].isEmpty()) {
				out << (*labels)[i] << "\t[";
				if(vPeakLabels[i].nb()>0 and vPeakLabels[i].ny()==0) out<<" shape=diamond,color=green,style=filled, ";
				if(vPeakLabels[i].nb()==0 and vPeakLabels[i].ny()>0) out<<" shape=triangle,color=yellow,style=filled, ";
				if(vPeakLabels[i].nb()>0 and vPeakLabels[i].ny()>0) {
					out<<" shape=polygon,sides=4,";
					if(vPeakLabels[i].nb()>vPeakLabels[i].ny()) out<<"color=green,style=filled,";
					if(vPeakLabels[i].nb()<vPeakLabels[i].ny()) out<<"color=yellow,style=filled,";
				}
				out << " label=\"" << (*labels)[i] <<" : "<< vPeakLabels[i].asString() << "\" ]\n";
			}
			out << "\t[label=\""<<vScores[i]<<"];\n";
		}
	}

	string styleStr;
	for(unsigned int eIdx=0; eIdx<edges.size(); eIdx++) {
		if(eIdx<edgeInPath.size() and edgeInPath[eIdx]) styleStr.assign(",style=bold,color=red"); else styleStr.assign("");
		if(eIdx<eMasses.size())
			out << (*labels)[edges[eIdx][0]]<<" -> "<<(*labels)[edges[eIdx][1]]<<" [label = \"( "<<eMasses[eIdx]<<" / "<<eScores[eIdx]<<" )\""<<styleStr<<"];\n";
		else out << (*labels)[edges[eIdx][0]]<<" -> "<<(*labels)[edges[eIdx][1]]<<" [label = \"("<<eScores[eIdx]<<" )\""<<styleStr<<"];\n";
	}
	
	out << "}\n";
	out.close();
	
	if(labels!=&vLabels) delete labels;
}

void MSGraph::info_heaviestPath(vector<float> &counts) {
	counts.resize(9); for(unsigned int i=0; i<9; i++) counts[i]=0;
	if(vPeakLabels.size()==0) return;
	
	vector<bool> vertexInPath(vNext.size());
	for(unsigned int i=0; i<vNext.size(); i++) 
		{ vertexInPath[i]=false;  counts[4]+=vPeakLabels[i].nb();  counts[6]+=vPeakLabels[i].ny(); }
		
	for(unsigned int e=0; e<edges.size(); e++)
		if(edgeInPath[e]) { vertexInPath[edges[e][0]]=true; vertexInPath[edges[e][1]]=true; }
	
	float vCount=0;
	for(unsigned int i=0; i<vNext.size(); i++)
		if(vertexInPath[i]) {
			vCount++;
			if(vPeakLabels[i].nb()>vPeakLabels[i].ny()) counts[0]++;
			if(vPeakLabels[i].nb()<vPeakLabels[i].ny()) counts[1]++;
			if(vPeakLabels[i].ne()>0 and vPeakLabels[i].nb()==0 and vPeakLabels[i].ny()==0) counts[2]++;
			counts[3]+=vPeakLabels[i].nb();   counts[5]+=vPeakLabels[i].ny();   counts[7]+=vPeakLabels[i].ne();
			counts[8]+=vPeakLabels[i].nb()+vPeakLabels[i].ny()+vPeakLabels[i].no()+vPeakLabels[i].nm()+vPeakLabels[i].ne();
		}
	counts[0] = counts[0]/vCount;   counts[1] = counts[1]/vCount;   counts[2] = counts[2]/vCount;
}
