#ifndef GRAPH_H
#define GRAPH_H

#include "spectrum.h"
#include "batch.h"
#include "aminoacid.h"
#include "label.h"
#include <vector>
#include <string>

using namespace std;

class Graph {
public:		
	vector<vector<int> > vNext;
	vector<float> vScores;
	vector<TwoValues<int> > edges;
	vector<float> eScores;
	
	void output_graphviz(char *filename);

	void build(vector<Results_ASP> &aligns);
	void add(vector<Results_PA> &aligns);
	void findConnectedPairs(unsigned int pathLength, unsigned int minNumPaths, vector<vector<int> > &vSets, vector<int> &numPaths);

        unsigned int numVertices() { return vNext.size(); }
        unsigned int numEdges() { return edges.size(); }
};

class MSGraph : public Graph {
public:		
	vector<float> eMasses;
	vector<string> vLabels;
	vector<PeakLabel> vPeakLabels;
	vector<bool> edgeInPath;

	MSGraph() { eMasses.resize(0); vLabels.resize(0); }

	unsigned int numVerts() { return vNext.size(); }

	void ConnectConsecutive(Spectrum &spec);
	void ConnectJumps(Spectrum &spec, AAJumps &jumps, float peakTol);

	void consolidateEdgeScores();
	float heaviestPath(MSGraph &path, bool useVertexScores=true, Spectrum *resultSpec=0, vector<int> *pathVertIdx=0);

	void findConnected(vector<MSGraph> &components);
	void findModPairs(vector<int> &parentMasses, float pmTol, list<vector<int> > &vSets);

	void output_graphviz(char *filename);
	
	void info_heaviestPath(vector<float> &counts);
};

#endif
