#ifndef HASH_H
#define HASH_H

#include <vector>
#include <list>

#include "spectrum.h"
#include "batch.h"

class HashTable {
	vector<vector<unsigned int> > table;   // Hash table
	unsigned int intPeakTol,    // Peak tolerance in terms of hash table bins
	             binsPerPeak;   // 2*intPeakTol+1
	float resolution;           // Mass resolution used to index the hash table: bin = round(mass/resolution)

	void SpectrumToIndices(Spectrum &spec, vector<unsigned int> &indices);
	
	static const float maxPeakMass = 4000;  // 4000 Da maximum hashable spectrum peak mass
public:

	HashTable() { table.resize(0); binsPerPeak=0; intPeakTol=0; }

	void Build(SpecSet &specs, float in_resolution, float peakTol, unsigned int endIdx);
	unsigned int QuerySet(SpecSet &specs, list<vector<unsigned int> > &pairs, unsigned int startIdx, bool returnAllPairs);
};

#endif
