#include "inputParams.h"
#include <iostream>
#include <fstream>

char *InputParams::emptyString = "";
float InputParams::Resolution = 0.1;
float InputParams::PeakTol    = 0.5;
float InputParams::PMTol      = 1.0;
float InputParams::MaxShift   = 3000.0;

void InputParams::freeStrings() { 
	for(int i=0;i<parameters.size();i++) {
		if (parameters[i]) free(parameters[i]);
		if (values[i]) free(values[i]);
	}
}

bool InputParams::readParams(char *filename) {
	ifstream input(filename);
	int i,j,numParams, length;
	char *buffer = (char *)malloc(2048);
	
	if (!input) { cerr << "Error opening " << filename << endl; return false; }
	input >> numParams;   input.getline(buffer,2048,'\n');    freeStrings();
	parameters.resize(numParams);   values.resize(numParams);
	for(i=0; i<numParams; i++) { parameters[i]=(char *)0; values[i]=(char *)0; }
	for(i=0; i<numParams; i++) {
		input.getline(buffer,2048,'\n');
		if (buffer[strlen(buffer)-1]=='\r') buffer[strlen(buffer)-1]='\0';
		for (j=0; j<2048 && buffer[j]!='\0' && buffer[j]!='='; j++);
		if (j==2048 || buffer[j]=='\0') { cerr << "Error reading parameters file " << filename << endl; parameters.resize(0); values.resize(0); break; }
		parameters[i] = (char *)malloc(j+1); strncpy(parameters[i],buffer,j); parameters[i][j]='\0';
		length = strlen(buffer)-j;
		values[i] = (char *)malloc(length); strncpy(values[i],&buffer[j+1],length-1); values[i][length-1]='\0';
	}
	
	free(buffer); input.close();
	if(parameters.size()==0) return false; 
	else {
		if(paramPresent("TOLERANCE_PEAK")) PeakTol = (float)getValueDouble("TOLERANCE_PEAK");
		if(paramPresent("TOLERANCE_PM")) PMTol = (float)getValueDouble("TOLERANCE_PM");
		if(paramPresent("RESOLUTION")) Resolution = (float)getValueDouble("RESOLUTION");
		if(paramPresent("MAX_SHIFT")) MaxShift = (float)getValueDouble("MAX_SHIFT");
		return true;
	}
}

char *InputParams::getValue(char *paramName) {
	unsigned int i;
	for(i=0; i<parameters.size() && strcmp(parameters[i],paramName)!=0; i++);
	if (i<parameters.size()) return values[i]; else return emptyString;
}

bool InputParams::paramPresent(char *paramName) {
	unsigned int i;
	for(i=0; i<parameters.size() && strcmp(parameters[i],paramName)!=0; i++);
	if (i<parameters.size()) return true; else return false;
}

//
//  Checks if all required parameters are present
//
bool InputParams::confirmParams(vector<char *> required) {
	int r,i;
	for (r=0; r<required.size(); r++) {
		for(i=0; i<parameters.size() && strcmp(parameters[i],required[r])!=0; i++);
		if (i>=parameters.size()) return false;
	}
	return true;			
}
