#ifndef INPUT_PARAMS
#define INPUT_PARAMS

#include <vector>
#include <cmath>
#include <iostream>
using namespace std;

//
// Parameters file is of the format
// <num_parameters_in_file>
// <param_name>=<param_value>  (note no spaces around =)
//

class InputParams {
	vector<char *> parameters, values;
	static char *emptyString;

	void freeStrings();

	public:

	static float Resolution, PeakTol, PMTol, MaxShift;
	
	InputParams() { parameters.resize(0); values.resize(0); }
	~InputParams() { freeStrings(); }
	
	bool readParams(char *filename);
	char *getValue(char *paramName);
	int getValueInt(char *paramName) { return atoi(getValue(paramName)); }
	double getValueDouble(char *paramName) { return atof(getValue(paramName)); }
	
	bool paramPresent(char *paramName);
	bool confirmParams(vector<char *> required);
	void showAll() { for(unsigned int i=0; i<parameters.size() ; i++) cerr << parameters[i] << " = " << values[i] << endl; }
};

#endif
