#ifndef LABEL_H
#define LABEL_H

#include "twovalues.h"
#include "spectrum.h"
#include <string>

class Label {
public:
	string text;
	
	Label() { text.clear(); }
	Label(char *inText) { text.assign(inText); }
	Label(string &inText) { text.assign(inText); }
	
	string &asString() { return text; }
};

//
//  PrmLabel - labels for PRM peaks' annotations of the form "b(nb) y(ny) m(nm) o(no) e(ne)"
//   b/nb - number of b-ion peaks
//   y/ny - number of y-ion peaks
//   o/no - number of non-b and non-y peaks
//   m/nm - number of b _and_ y ion peaks (mix)
//   e/ne - number of endpoint peaks (entries above account for spectrum peaks only and exclude these)
//
class PeakLabel : public Label {
	static char typeLabels[5];
public:
	vector<int> counts;  // positions 0-4 are nb/ny/no/nm/ne

	PeakLabel(int cb=0, int cy=0, int co=0, int cm=0, int ce=0) 
		{ counts.resize(5); set(cb,cy,co,cm,ce); }

	int &operator[](int idx) { return counts[idx]; }
	PeakLabel &operator=(const PeakLabel &other) 
		{ return set(other.counts[0],other.counts[1],other.counts[2],other.counts[3],other.counts[4]); }
	int &nb() { return counts[0]; }
	int &ny() { return counts[1]; }
	int &no() { return counts[2]; }
	int &nm() { return counts[3]; }
	int &ne() { return counts[4]; }
	
	PeakLabel &merge(PeakLabel &other) 
		{ for(unsigned int i=0; i<counts.size(); i++) counts[i]+=other.counts[i]; return *this; }
	
	bool isEmpty() { bool empty=true; for(unsigned int i=0;i<counts.size();i++) empty=empty and counts[i]==0; return empty; }
	
	PeakLabel &set(int cb, int cy, int co, int cm, int ce) 
		{ counts[0]=cb; counts[1]=cy; counts[2]=co; counts[3]=cm; counts[4]=ce; return *this; }
	PeakLabel &reverse() { int tmp=counts[0]; counts[0]=counts[1]; counts[1]=tmp; return *this; }
	string &asString();
};

class SpectrumPeakLabels {
public:
	vector<PeakLabel> peakLabels;

	SpectrumPeakLabels() { peakLabels.resize(0); }
	unsigned int size() { return peakLabels.size(); }
	void resize(unsigned int newSize) { peakLabels.resize(newSize); }
	PeakLabel &operator[](unsigned int idx) { return peakLabels[idx]; }
	SpectrumPeakLabels &operator=(const SpectrumPeakLabels &other)
		{ peakLabels.resize(other.peakLabels.size()); 
			for(unsigned int i=0;i<peakLabels.size();i++) 
				peakLabels[i]=other.peakLabels[i]; 
			return *this; }
	
	void reverse();
};

int LoadLabels(SpecSet &specSet, char *filename, vector<SpectrumPeakLabels> &labels);

#endif
