#include "inputParams.h"
#include "alignment_scoring.h"
#include "spectral_pairs.h"
#include "batch.h"
#include "abruijn.h"
#include "graph.h"
#include "setmerger.h"

#include <iostream>
#include <fstream>
#include <string>
#include <cmath>
#include <ctime>

using namespace std;

int main(int argc, char **argv){
    InputParams params; bool paramsOk;
	if(argc<=1) paramsOk=params.readParams("masab.params");	else paramsOk=params.readParams(argv[1]);
	if(!paramsOk) {
		cerr << "Error opening parameters file ";
		if(argc<=1) cerr << "masab.params\n"; else cerr << argv[1] << endl;
		return -1;
	}
	vector<char *> paramStrs;   paramStrs.resize(5);
	paramStrs[0] = "OUTPUT_SPECS";
	paramStrs[1] = "OUTPUT_MODPOS";
	paramStrs[2] = "PENALTY_PTM";
	paramStrs[3] = "PENALTY_SAME_VERTEX";
	paramStrs[4] = "GRAPH_TYPE";
	if(!params.confirmParams(paramStrs)) {
		cerr << "ERROR: Parameters file ";
		if(argc==1) cerr<<"masab.params"; else cerr<<argv[1];
		cerr << " is incomplete. One of the following is missing: OUTPUT_SPECS, OUTPUT_MODPOS, PENALTY_PTM, PENALTY_SAME_VERTEX, GRAPH_TYPE\n";
		return -1;
	}
	
	char *specSetFN = params.getValue("INPUT_SPECS");
	char *alignsFN = params.getValue("INPUT_ALIGNS");
	char *resultsFN = params.getValue("OUTPUT_SPECS");
	char *modPosFN = params.getValue("OUTPUT_MODPOS");
	float penalty_ptm = (float) params.getValueDouble("PENALTY_PTM");
	float penalty_sameVert = (float) params.getValueDouble("PENALTY_SAME_VERTEX");
	int graphType = params.getValueInt("GRAPH_TYPE");
	
	char *labelsFN = params.getValue("INPUT_LABELS");
	char *alignsPAFN = params.getValue("INPUT_ALIGNSPA");
	int maxAAjump = params.paramPresent("MAX_AA_JUMP")?params.getValueInt("MAX_AA_JUMP"):0;
	float peakTol = params.getValue("TOLERANCE_PEAK")?(float) params.getValueDouble("TOLERANCE_PEAK"):0.5;
	float pmTol = params.getValue("TOLERANCE_PM")?(float) params.getValueDouble("TOLERANCE_PM"):1;
	float minRatio = params.paramPresent("MIN_RATIO")?(float) params.getValueDouble("MIN_RATIO"):-1;
	bool computeRatios = params.paramPresent("OUTPUT_RATIOS"),
	     computeRatiosPA = params.paramPresent("OUTPUT_RATIOSPA");
    short edgeScoreType = (short)(params.paramPresent("EDGE_SCORE_TYPE")?params.getValueInt("EDGE_SCORE_TYPE"):1);
    int specType = params.paramPresent("SPEC_TYPE_MSMS")?((int) params.getValueInt("SPEC_TYPE_MSMS")?1:0):0;
	float ionOffset = specType?AAJumps::massHion:0;

	SpecSet specSet;   short loadOk=0;
	if(params.paramPresent("INPUT_SPECS")) loadOk=specSet.LoadSpecSet_pkl(params.getValue("INPUT_SPECS"));
	else if(params.paramPresent("INPUT_SPECS_PKLBIN")) loadOk=specSet.LoadSpecSet_pklbin(params.getValue("INPUT_SPECS_PKLBIN"));
	if (loadOk<=0 or specSet.size()==0) return -1;

	vector<Results_ASP> aligns;   
	if (params.paramPresent("INPUT_ALIGNS")) {
		if (Load_resultsASPbin(alignsFN, aligns)==0) { cerr << "Error reading "<<alignsFN<<"!\n"; return -1; }
	}
	vector<vector<float> > ratios; if(minRatio>0 or computeRatios) { ratios.resize(aligns.size()); for(unsigned int i=0;i<ratios.size();i++) {ratios[i].resize(3); ratios[i][0]=0; ratios[i][1]=0; ratios[i][2]=0;} }
	vector<vector<float> > ratiosOriented;  ratiosOriented.resize(aligns.size()); for(unsigned int i=0;i<ratiosOriented.size();i++) {ratiosOriented[i].resize(2); ratiosOriented[i][0]=0; ratiosOriented[i][1]=0;}
	
	vector<Results_PA> alignsPA;
	if (params.paramPresent("INPUT_ALIGNSPA")) {
		if(Load_resultsPA(alignsPAFN, alignsPA)==0) { cerr << "Error reading "<<alignsPAFN<<"!\n"; return -1; }
	}
	vector<vector<float> > ratiosPA; if(minRatio>0 or computeRatiosPA) { ratiosPA.resize(alignsPA.size()); for(unsigned int i=0;i<ratiosPA.size();i++) {ratiosPA[i].resize(3); ratiosPA[i][0]=0; ratiosPA[i][1]=0; ratiosPA[i][2]=0;} }
	vector<vector<float> > ratiosOrientedPA;  ratiosOrientedPA.resize(alignsPA.size()); for(unsigned int i=0;i<ratiosOrientedPA.size();i++) {ratiosOrientedPA[i].resize(2); ratiosOrientedPA[i][0]=0; ratiosOrientedPA[i][1]=0;}
	vector<float> maxSpecScores;
	if(minRatio>0 or computeRatios or computeRatiosPA) { maxSpecScores.resize(specSet.size()); for(unsigned int i=0;i<specSet.size();i++) {maxSpecScores[i]=0; for(unsigned int j=0;j<specSet[i].size();j++) maxSpecScores[i]+=specSet[i][j][1];} }

	vector<SpectrumPeakLabels> labels, newLabels, *labelsP;
	if(strlen(labelsFN)!=0) { 
		int res = LoadLabels(specSet, labelsFN, labels);
		if(res<=0) { cerr<<"Error reading labels file "<<labelsFN<<".\n"; return -1; }
		labelsP = &labels;
	} else labelsP = (vector<SpectrumPeakLabels> *)0;
	if(labelsP) for(unsigned int i=0; i<specSet.size(); i++) specSet[i].addZPMpeaks(peakTol,true,&(*labelsP)[i]);
	else for(unsigned int i=0; i<specSet.size(); i++) specSet[i].addZPMpeaks(peakTol,ionOffset,true);

	SetMerger components(specSet.size());
	components.createSets(specSet.size(),2,aligns,alignsPA);
	components.splitAligns(aligns,alignsPA);
	SpecSet &curSpecSet = specSet;
	vector<MSGraph> spectrumGraphs(curSpecSet.size());   AAJumps jumps2(2);

	char sBuf[1024]; AAJumps jumps(1);
	unsigned int numElemsInSets=components.numElemsInSets();
	vector<vector<float> > cStats(numElemsInSets);  for(unsigned int cIdx=0;cIdx<cStats.size();cIdx++) { cStats[cIdx].resize(9); for(unsigned int i=0;i<9;i++) cStats[cIdx][i]=0; } 
	SpecSet pathSpectra;   pathSpectra.resize(numElemsInSets);
	vector<list<int> > cSpectra(numElemsInSets);
	vector<bool>       specFlipped(curSpecSet.size()); for(unsigned int i=0;i<specFlipped.size();i++) specFlipped[i]=false;
	vector<vector<list<TwoValues<int> > > > abVertices(numElemsInSets); for(unsigned int i=0;i<abVertices.size();i++) abVertices[i].resize(0);

    vector<vector<short> > abCounts(numElemsInSets);
    for(unsigned int i=0; i<abCounts.size(); i++) { abCounts[i].resize(2); abCounts[i][0]=0; abCounts[i][1]=0; }

	for(unsigned int cIdx=0; cIdx<components.size(); cIdx++) {
		vector<vector<TwoValues<int> > > matches, matchesPA;

		vector<float> modPos;
                vector<TwoValues<float> > tmpRatiosOriented(components.cAlignsASP[cIdx].size()), tmpRatiosOrientedPA(components.cAlignsPA[cIdx].size());
		SplitPairs3(curSpecSet, components.cAlignsASP[cIdx], components.cAlignsPA[cIdx], peakTol, maxAAjump, penalty_sameVert, penalty_ptm, matches, matchesPA, specFlipped, modPos, false, labelsP, &tmpRatiosOriented, &tmpRatiosOrientedPA);
                for(unsigned int i=0; i<tmpRatiosOriented.size(); i++) { ratiosOriented[components.cAlignsASP_idx[cIdx][i]][0]=tmpRatiosOriented[i][0]; ratiosOriented[components.cAlignsASP_idx[cIdx][i]][1]=tmpRatiosOriented[i][1]; }
                for(unsigned int i=0; i<tmpRatiosOrientedPA.size(); i++) { ratiosOrientedPA[components.cAlignsPA_idx[cIdx][i]][0]=tmpRatiosOrientedPA[i][0]; ratiosOrientedPA[components.cAlignsPA_idx[cIdx][i]][1]=tmpRatiosOrientedPA[i][1]; }

		vector<Results_ASP> &curAligns = components.cAlignsASP[cIdx];

		if(minRatio>0 or computeRatios or computeRatiosPA) {
			if(minRatio>0 or computeRatios)
				for(unsigned int pairIdx=0; pairIdx<components.cAlignsASP[cIdx].size(); pairIdx++) {
					float score1=0, score2=0;   int s1=components.cAlignsASP[cIdx][pairIdx].spec1, s2=components.cAlignsASP[cIdx][pairIdx].spec2;
					for(unsigned int i=0; i<matches[pairIdx].size(); i++) 
						{ score1+=curSpecSet[s1][matches[pairIdx][i][0]][1];  score2+=curSpecSet[s2][matches[pairIdx][i][1]][1]; }
					ratios[components.cAlignsASP_idx[cIdx][pairIdx]][0] = score1/maxSpecScores[s1];
					ratios[components.cAlignsASP_idx[cIdx][pairIdx]][1] = score2/maxSpecScores[s2];
					ratios[components.cAlignsASP_idx[cIdx][pairIdx]][2] = matches[pairIdx].size();
				}
			if(minRatio>0 or computeRatiosPA)
				for(unsigned int pairIdx=0; pairIdx<components.cAlignsPA[cIdx].size(); pairIdx++) {
					float score1=0, score2=0;   int s1=components.cAlignsPA[cIdx][pairIdx].spec1, s2=components.cAlignsPA[cIdx][pairIdx].spec2;
					for(unsigned int i=0; i<matchesPA[pairIdx].size(); i++) 
						{ score1+=curSpecSet[s1][matchesPA[pairIdx][i][0]][1];  score2+=curSpecSet[s2][matchesPA[pairIdx][i][1]][1]; }
					ratiosPA[components.cAlignsPA_idx[cIdx][pairIdx]][0] = score1/maxSpecScores[s1];
					ratiosPA[components.cAlignsPA_idx[cIdx][pairIdx]][1] = score2/maxSpecScores[s2];
					ratiosPA[components.cAlignsPA_idx[cIdx][pairIdx]][2] = matchesPA[pairIdx].size();
				}
			if(minRatio<0) continue;
		}

		vector<bool> present(curSpecSet.size()); for(unsigned int i=0; i<present.size();i++) present[i]=false;
		for(unsigned int i=0;i<curAligns.size();i++) {
			if(!present[curAligns[i].spec1]) { cSpectra[cIdx].push_back(curAligns[i].spec1); present[curAligns[i].spec1]=true; }
			if(!present[curAligns[i].spec2]) { cSpectra[cIdx].push_back(curAligns[i].spec2); present[curAligns[i].spec2]=true; }
		}
		for(unsigned int i=0;i<components.cAlignsPA[cIdx].size();i++) {
			if(!present[components.cAlignsPA[cIdx][i].spec1]) { cSpectra[cIdx].push_back(components.cAlignsPA[cIdx][i].spec1); present[components.cAlignsPA[cIdx][i].spec1]=true; }
			if(!present[components.cAlignsPA[cIdx][i].spec2]) { cSpectra[cIdx].push_back(components.cAlignsPA[cIdx][i].spec2); present[components.cAlignsPA[cIdx][i].spec2]=true; }
		}

		list<int>::iterator sicIter;
		for(sicIter=cSpectra[cIdx].begin();sicIter!=cSpectra[cIdx].end();sicIter++)
			curSpecSet[*sicIter].maximizeZPMpeaks(peakTol,true);

		MSGraph g;   g.build(curAligns);   
		g.add(components.cAlignsPA[cIdx]);
		g.vLabels.resize(curSpecSet.size());
		if(curSpecSet.size()==specSet.size()) 
			for(unsigned int i=0; i<specSet.size(); i++) { 
				if(specFlipped[i]) sprintf(sBuf,"v%d_R",i); else sprintf(sBuf,"v%d",i);
				g.vLabels[i] = string((const char *)sBuf); 
			}
		else for(unsigned int i=0; i<specSet.size(); i++) { 
				sprintf(sBuf,"v%d",i);    g.vLabels[2*i] = string((const char *)sBuf);  
				sprintf(sBuf,"v%d_R",i);  g.vLabels[2*i+1] = string((const char *)sBuf); 
			 }
		sprintf(sBuf,"split_pairs_graph_%d.txt",cIdx);  g.output_graphviz(sBuf);

		if(graphType>0) {
			for(unsigned int i=0; i<curAligns.size(); i++) {
				if(spectrumGraphs[curAligns[i].spec1].numVerts()==0) {
					if(graphType==1) spectrumGraphs[curAligns[i].spec1].ConnectConsecutive(curSpecSet[curAligns[i].spec1]);
					else spectrumGraphs[curAligns[i].spec1].ConnectJumps(curSpecSet[curAligns[i].spec1],jumps2,peakTol);
				}
				if(spectrumGraphs[curAligns[i].spec2].numVerts()==0) {
					if(graphType==1) spectrumGraphs[curAligns[i].spec2].ConnectConsecutive(curSpecSet[curAligns[i].spec2]);
					else spectrumGraphs[curAligns[i].spec2].ConnectJumps(curSpecSet[curAligns[i].spec2],jumps2,peakTol);
				}
			}
			for(unsigned int i=0; i<components.cAlignsPA[cIdx].size(); i++) {
				if(spectrumGraphs[components.cAlignsPA[cIdx][i].spec1].numVerts()==0) {
					if(graphType==1) spectrumGraphs[components.cAlignsPA[cIdx][i].spec1].ConnectConsecutive(curSpecSet[components.cAlignsPA[cIdx][i].spec1]);
					else spectrumGraphs[components.cAlignsPA[cIdx][i].spec1].ConnectJumps(curSpecSet[components.cAlignsPA[cIdx][i].spec1],jumps2,peakTol);
				}
				if(spectrumGraphs[components.cAlignsPA[cIdx][i].spec2].numVerts()==0) {
					if(graphType==1) spectrumGraphs[components.cAlignsPA[cIdx][i].spec2].ConnectConsecutive(curSpecSet[components.cAlignsPA[cIdx][i].spec2]);
					else spectrumGraphs[components.cAlignsPA[cIdx][i].spec2].ConnectJumps(curSpecSet[components.cAlignsPA[cIdx][i].spec2],jumps2,peakTol);
				}
			}
		}

		VertexSet vSet(curSpecSet,2048);
		vector<bool> usedSpectra(curSpecSet.size());  for(unsigned int i=0; i<curSpecSet.size(); i++) usedSpectra[i]=false;
		unsigned int skipped_asp=0, skipped_pa=0;
		for(unsigned int i=0; i<matches.size(); i++) {

			if(minRatio>0 and (ratios[components.cAlignsASP_idx[cIdx][i]][0]<minRatio or ratios[components.cAlignsASP_idx[cIdx][i]][1]<minRatio)) { skipped_asp++; continue; }

			if(graphType==0) vSet.addGlues(curAligns[i].spec1,curAligns[i].spec2,matches[i]);
			else vSet.addGlues(curAligns[i].spec1,curAligns[i].spec2,matches[i],&spectrumGraphs);
			usedSpectra[curAligns[i].spec1] = true;
			usedSpectra[curAligns[i].spec2] = true;
		}
		for(unsigned int i=0; i<matchesPA.size(); i++) {

			if(minRatio>0 and (ratiosPA[components.cAlignsPA_idx[cIdx][i]][0]<minRatio or ratiosPA[components.cAlignsPA_idx[cIdx][i]][1]<minRatio)) { skipped_pa++; continue; }

			if(graphType==0) vSet.addGlues(components.cAlignsPA[cIdx][i].spec1,components.cAlignsPA[cIdx][i].spec2,matchesPA[i]);
			else vSet.addGlues(components.cAlignsPA[cIdx][i].spec1,components.cAlignsPA[cIdx][i].spec2,matchesPA[i],&spectrumGraphs);
			usedSpectra[components.cAlignsPA[cIdx][i].spec1] = true;
			usedSpectra[components.cAlignsPA[cIdx][i].spec2] = true;
		}

		int specCount=0; for(unsigned int i=0;i<usedSpectra.size();i++) if(usedSpectra[i]) specCount++;
		if(specCount==0) continue;

		if(specCount>1000) {
			if(cIdx>0) cStats[cIdx].resize(cStats[0].size()); else cStats[cIdx].resize(9); 
			continue;
		}
		
		int compositeVertexCount=0;  list<int> compositeSet;
		for(unsigned int i=0; i<vSet.vertices.size(); i++)	
			if(vSet.vertices[i].size()>0 and vSet.vertices[i].compositeVertex) 
				{ compositeVertexCount++; compositeSet.push_front(i); }
		list<int>::iterator iter=compositeSet.begin();
		if(compositeVertexCount>0) vSet.splitComposite(spectrumGraphs,peakTol,&usedSpectra);
		
		if(graphType==1) { vSet.addEdges(spectrumGraphs,&usedSpectra);  vSet.consolidatePaths(); }
		if(graphType==2) { vSet.addEdges(spectrumGraphs,&usedSpectra); }
		vSet.addEndpointEdges(components.cAlignsASP[cIdx],matches,modPos,jumps2,peakTol);		
		VertexSet copy(vSet), *vSetP;

		MSGraph *abg, abgB, abgY;   
		MSGraph path;
		vector<int> vSet_indexB, vSet_indexY, *vSet_indexP; 
		vector<int> pathVertsIdxB, pathVertsIdxY, *pathVertsIdx;
		Spectrum specWithBep, specWithYep;
		float scoreWithBep, scoreWithYep;
		vSet.removeEndpoints(false,peakTol);
		vSet.buildGraph(abgB,jumps,peakTol,vSet_indexB,edgeScoreType,labelsP);
		scoreWithBep = abgB.heaviestPath(path,false,&specWithBep,&pathVertsIdxB);
		
		copy.removeEndpoints(true,peakTol);
		copy.buildGraph(abgY,jumps,peakTol,vSet_indexY,edgeScoreType,labelsP);
		scoreWithYep = abgY.heaviestPath(path,false,&specWithYep,&pathVertsIdxY);

		if(scoreWithBep>=scoreWithYep) { abg=&abgB; pathSpectra[cIdx]=specWithBep; vSet_indexP = &vSet_indexB; vSetP = &vSet; pathVertsIdx=&pathVertsIdxB;} 
		  else { abg=&abgY; pathSpectra[cIdx]=specWithYep; vSet_indexP = &vSet_indexY; vSetP = &copy; pathVertsIdx=&pathVertsIdxY;}
		for(unsigned int vIdx=0; vIdx<pathVertsIdx->size(); vIdx++) (*pathVertsIdx)[vIdx] = (*vSet_indexP)[(*pathVertsIdx)[vIdx]];
		
		vSetP->getMatchedPeaks(*pathVertsIdx,abVertices[cIdx]);		
		abg->info_heaviestPath(cStats[cIdx]);   abCounts[cIdx][0]=abg->numVertices();   abCounts[cIdx][1]=abg->numEdges();	

		list<int> usedSpecs;   usedSpecs.clear();
		for(unsigned int i=0; i<abVertices[cIdx].size(); i++)
			for(list<TwoValues<int> >::iterator vIter=abVertices[cIdx][i].begin(); vIter!=abVertices[cIdx][i].end(); vIter++)
				usedSpecs.push_back((*vIter)[0]);
		usedSpecs.sort();   usedSpecs.unique();
		if(usedSpecs.size()>0 and usedSpecs.size()<components.sets[cIdx].size()-1) components.splitSet(cIdx,usedSpecs);
	}
	components.saveas_binListArray("components.bla");
	cStats.resize(components.size());
	pathSpectra.resize(components.size());
	cSpectra.resize(components.size());
	abVertices.resize(components.size());
    abCounts.resize(components.size());

	if(minRatio>0 or (not computeRatios and not computeRatiosPA)) {
		Save_binArray("component_stats.bna",cStats);
		Save_binListArray<int,list<int>,list<int>::iterator>("component_spectra.bla",cSpectra);
		Save_abinfo("component_info.bin",specSet, components.sets, specFlipped, abVertices);
		pathSpectra.SaveSpecSet_pklbin(params.getValue("OUTPUT_SPECS"));
	}
	
	if(computeRatios) Save_binArray(params.getValue("OUTPUT_RATIOS"), ratios);
	if(computeRatiosPA) Save_binArray(params.getValue("OUTPUT_RATIOSPA"), ratiosPA);
	Save_binArray("ratios_oriented.bin", ratiosOriented);
	Save_binArray("ratios_pa_oriented.bin", ratiosOrientedPA);
	Save_binArray("abCounts.bin", abCounts);

	return(0);
}
