#ifndef MZXML_H
#define MZXML_H

#include <xercesc/sax2/DefaultHandler.hpp>
#include "spectrum.h"

using namespace std;
XERCES_CPP_NAMESPACE_USE;

unsigned int LoadMzxml(char *filename, SpecSet &specs, vector<short> *msLevels = 0, short minMsLevel = 2 );

class mzxmlSAX2Handler : public DefaultHandler {
protected:
	static short STATE_SKIPPING, STATE_SCAN, STATE_PRECURSORMZ, STATE_PEAKS;

public:
	SpecSet *specs;    // Set of retained spectra
	vector<short> *msLevels;    // MS level for each retained spectrum
	list<int> curSpec;          // Spectrum currently being read (list is necessary because of nested scans)
	short state;                // Indicates current state (see STATE_* above)
	unsigned int numSpecs;      // Updated count of retained spectra
	short minMsLevel;           // Minimum msLevel to read a spectrum into specs

	mzxmlSAX2Handler(SpecSet &in_specs, vector<short> *in_msLevels = 0, short in_minMsLevel=2) { 
		numSpecs=0;           state = STATE_SKIPPING; 
		specs = &in_specs;
		msLevels = in_msLevels;   minMsLevel = in_minMsLevel;
		curSpec.clear();
	}

    void startElement(
        const   XMLCh* const    uri,
        const   XMLCh* const    localname,
        const   XMLCh* const    qname,
        const   Attributes&     attrs
    );

	void characters(
	    const   XMLCh* const    chars,
        const   unsigned int    length
    );

    void endElement( 
        const XMLCh* const uri,
        const XMLCh* const localname,
        const XMLCh* const qname
    );

    void endDocument();

    void fatalError(const SAXParseException&);
};

#endif
