#ifndef __DENOVOSOLUTIONS_H__
#define __DENOVOSOLUTIONS_H__


#include "Spectrum.h"
#include "Model.h"
#include "DeNovoDp.h"

// well it's not really a heap
struct SeqPathHeap {
	void init(int _max_size, mass_t _tolerance) { 
		paths.clear(); 
		max_size = _max_size; 
		tolerance = 5 * _tolerance;
		min_idx=-1; 
		min_value=99999; 
	}
	void add_path(SeqPath& new_path);

	int max_size;
	mass_t tolerance;
	int min_idx;
	float min_value;
	vector<SeqPath> paths;
};


/**************************************************************************
	Wrapper funciton that generates the desired solutions.
	Combines both local and global solutions (similar to the PepNovoTag
	and LocalTag solutions).
***************************************************************************/
void generate_denovo_solutions(Model *model, 
							   Spectrum *spec,
							   bool denovo_mode,
							   mass_t pm_with_19,
							   int  charge,
							   int num_sols, 
							   int min_length, 
							   int max_length,
							   vector<SeqPath>& solutions);


/***************************************************************************
	Wrapper function that generates several solutions according to different 
	precursor masses.
****************************************************************************/
void generate_denovo_solutions_from_several_pms(Model *model, Spectrum *spec,
							   bool denovo_mode,
							   int num_sols, int min_length, int max_length,
							   vector<mass_t>& different_pms_with_19,
							   vector<int>& charges,
							   vector<SeqPath>& solutions);


/**************************************************************************
Generates an prints the PRM graph
***************************************************************************/
void print_prm_graph_scores(Model *model, Spectrum *spec, 
					 mass_t pm_with_19, int charge);




void output_denovo_solutions(SingleSpectrumFile *ssf, Config *config, ostream& out_stream,
							 const vector<SeqPath>& solutions);


void output_tag_solutions(SingleSpectrumFile *ssf, Config *config, ostream& out_stream,
							 const vector<SeqPath>& solutions);



#endif



