#include "EdgeModel.h"



void EdgeModel::read_edge_models(Config *config, char *model_name)
{
	ind_was_initialized=  (saa_model.read_model(config,model_name) &&
		                   daa_model.read_model(config,model_name) );

}




void EdgeModel::train_all_edge_models(const FileManager& fm, Model *model)
{
	saa_model.train_saa_models(fm, model);
	saa_model.train_saancd_models(fm, model);

	model->get_config()->fill_allowed_double_edges(true);

	daa_model.train_daa_models(fm, model, 0.15);
	daa_model.train_daancd_model(fm, model);

	model->get_config()->fill_allowed_double_edges();

	ind_was_initialized = true;
}



void EdgeModel::assign_probs_to_graph_edges(PrmGraph& prm, int charge, int size_idx) const
{
	if (! ind_was_initialized )
	{
		cout << "Error: edge score models not read!" << endl;
		exit(1);
	}

	int i;
	vector<MultiEdge>& edges = prm.multi_edges;

	for (i=0; i<edges.size(); i++)
	{
		MultiEdge& edge = edges[i];

		edge.variant_probs.resize(edge.variant_ptrs.size());

		if (edge.num_aa == 1)
		{
			int v;
			for (v=0; v<edge.variant_ptrs.size(); v++)
			{
				float prob = saa_model.calc_variant_prob(prm,i,edge.variant_ptrs[v]);
				//						charge, size_idx);
				edge.variant_probs[v]=prob;
			}
		}
		else if (edge.num_aa == 2)
		{
			int v;
			for (v=0; v<edge.variant_ptrs.size(); v++)
			{
				float prob = daa_model.calc_variant_prob(prm,i,edge.variant_ptrs[v]);
				edge.variant_probs[v]=prob;
			}
		}
		else
		{
			int combos = (1 << edge.num_aa);
			float prob = 0.5 / combos;
			int v;
			for (v=0; v<edge.variant_ptrs.size(); v++)
			{
				edge.variant_probs[v]=prob;
			}
		}
	}
}


// assigns probs and scores to graph edges
void EdgeModel::score_graph_edges(PrmGraph& prm) const
{
	int i;

	if (! this->ind_was_initialized)
		return;

	const score_t single_edge_score_mult = 3.0;
	const score_t large_edge_score_mult = 2.0;

	const int charge = prm.get_source_spectrum()->get_charge();
	const int size_idx = prm.get_config()->calc_peptide_size_idx(charge,
		prm.get_source_spectrum()->get_org_pm_with_19());

	assign_probs_to_graph_edges(prm,charge,size_idx);

	vector<MultiEdge>& edges = prm.multi_edges;
	for (i=0; i<edges.size(); i++)
	{
		MultiEdge& edge = edges[i];
		const score_t mult_val = (edge.num_aa == 1 ? single_edge_score_mult : large_edge_score_mult);
	
		int v; 
		for (v=0; v<edge.variant_probs.size(); v++)
		{ 
			float prob = edge.variant_probs[v];
			if (prob<0.04)
				prob=0.04;
			if (prob>0.96)
				prob=0.96;

			// there is possibly a score there from the digest edges
			// so just add to the existing scores
			score_t var_score = mult_val * log(prob/(1.0-prob));
			
			if (var_score<0)
				var_score *= 0.666;

			edge.variant_scores[v] += var_score * mult_val;

			if (edge.variant_scores[v]>edge.max_variant_score)
				edge.max_variant_score = edge.variant_scores[v];

		}
	}
}


