#ifndef __EDGEMODEL_H__
#define __EDGEMODEL_H__

#include "Config.h"
#include "PrmGraph.h"
#include "ScoreSingleAA.h"
#include "ScoreDoubleAA.h"


#define MAX_AA_SAMPLES 80000

class EdgeModel {
public:
	EdgeModel() : ind_was_initialized(false) {};

	void read_edge_models(Config *config, char *model_name);

	void train_all_edge_models(const FileManager& fm, Model *model);

	
	// assigns probs and scores to graph edges
	void score_graph_edges(PrmGraph& prm) const;

private:

	bool ind_was_initialized;

	void assign_probs_to_graph_edges(PrmGraph& prm, int charge, int size_idx) const;

	ScoreSingleAA saa_model;

	ScoreDoubleAA daa_model;
};


#endif




