#ifndef __SCOREDOUBLEAA_H__
#define __SCOREDOUBLEAA_H__

#include "ME_REG.h"
#include "PrmGraph.h"
#include "Config.h"
#include "includes.h"

typedef enum ScoreModelFields_DAA { 
	
	DAA_CONST,

	DAA_N_SCORE_ABOVE_TWO_THIRDS, DAA_C_SCORE_ABOVE_TWO_THIRDS,
	DAA_IND_TWO_THIRDS_BOTH_ABOVE,

	DAA_N_SCORE_ABOVE_THIRD, DAA_C_SCORE_ABOVE_THIRD,
	DAA_IND_THIRD_BOTH_ABOVE,

	DAA_N_SCORE_ABOVE_ZERO, DAA_C_SCORE_ABOVE_ZERO,
	DAA_IND_ZERO_BOTH_ABOVE,

	DAA_IND_BOTH_ABOVE_FIVE,
	DAA_IND_N_ABOVE_FIVE, DAA_IND_C_ABOVE_FIVE,

	DAA_MAX_SCORE_RANK, DAA_MIN_SCORE_RANK,  
	DAA_N_SCORE_RANK,   DAA_C_SCORE_RANK, DAA_SCORE_RANK_SUM,
	DAA_SCORE_RANK_DIFF, DAA_SCORE_RANK_ABS_DIFF, 
	DAA_N_NUM_FRAGS,   DAA_C_NUM_FRAGS, DAA_NUM_FRAG_DIFF, DAA_ABS_NUM_FRAG_DIFF,
	
	DAA_IND_N_IS_MAX_IDX_TO_C,   
	DAA_IND_C_IS_MAX_IDX_FROM_N, DAA_DIFF_N_MAX_IN_C_SCORE_RANKS, 
	DAA_IND_N_NOT_MAX_IDX_TO_C,   
	DAA_IND_C_NOT_MAX_IDX_FROM_N, DAA_DIFF_C_MAX_OUT_N_SCORE_RANKS,

	DAA_IND_BOTH_CONNECT_TO_MAX, 

	DAA_NODE_MASS_DIFF,     DAA_NODE_SQR_MASS_DIFF,    DAA_NUM_FRAG_PAIRS,
	DAA_AVG_PEAK_DIFF,      DAA_AVG_PEAK_SQR_DIFF,
	DAA_BEST_PEAK_DIFF,     DAA_BEST_PEAK_SQR_DIFF,    DAA_IND_NO_PEAK_DIFF,

	DAA_AVG_PEAK_DIFF_TIMES_SCORE_RANK_SUM,
	DAA_AVG_PEAK_DIFF_TIMES_SCORE_ABS_DIFF,
	DAA_AVG_PEAK_DIFF_DIV_NUM_FRAG_PAIRS,

	DAA_IND_BOTH_CONNECT_TO_MAX_TIMES_AVG_DIFF,

	DAA_NUM_DOUBLE_EDGE_ROUTES, 
	DAA_IND_NO_DOUBLE_EDGE_ROUTES,
	DAA_SCORE_RANK_DOUBLE_EDGE_ROUTES,
	DAA_IND_IND_MAX_SCORE_ALTERNATE_MORE_THAN_ZERO,
	DAA_IND_MAX_ALTERNATE_IS_MAX_OUT_N,
	DAA_IND_MAX_ALTERNATE_IS_MAX_IN_C,
	DAA_NODE_OFFSETS_ALTERNTE,
	DAA_SQR_NODE_ODFFSETS_ALTERNATE,

	DAA_IND_PROBLEMATIC_PAIR_OF_AAS,
/*	DAA_IND_CHARGE1, DAA_CHARGE1_MAX_SCORE_RANK, DAA_CHARGE1_MIN_SCORE_RANK,
	DAA_IND_CHARGE2, DAA_CHARGE2_MAX_SCORE_RANK, DAA_CHARGE2_MIN_SCORE_RANK,
	DAA_IND_CHARGE3, DAA_CHARGE3_MAX_SCORE_RANK, DAA_CHARGE3_MIN_SCORE_RANK,*/

	DAA_NUM_FIELDS
} ScoreModelFields_DAA;


typedef enum ScoreModelFields_DAANCD { DAANCD_CONST,
	DAANCD_IND_CONNECTS_TO_NODE_WITH_NO_FRAGS,
	DAANCD_IND_CONNECTS_TO_N_TERMINAL,
	DAANCD_IND_CONNECTS_TO_C_TERMINAL,
	DAANCD_IND_CONNECTS_TO_DIGEST,

	DAANCD_IND_HAS_MAX_SCORE_FROM_N,  	DAANCD_SCORE_FROM_N,
	DAANCD_IND_HAS_MAX_SCORE_TO_C,      DAANCD_SCORE_TO_C,
	DAANCD_IND_HAS_MAX_SCORE_TO_DIGEST, DAANCD_SCORE_TO_DIGEST,

	DAANCD_NODE_MASS_DIFF_FROM_N,     DAANCD_NODE_SQR_MASS_DIFF_FROM_N,
	DAANCD_NODE_MASS_DIFF_TO_C,     DAANCD_NODE_SQR_MASS_DIFF_TO_C,
	DAANCD_NODE_MASS_DIFF_TO_DIGEST,     DAANCD_NODE_SQR_MASS_DIFF_TO_DIGEST,

	DAANCD_NUM_DOUBLE_EDGE_ROUTES, 
	DAANCD_IND_NO_DOUBLE_EDGE_ROUTES,
	DAANCD_SCORE_RANK_DOUBLE_EDGE_ROUTES,
	DAANCD_IND_IND_MAX_SCORE_ALTERNATE_MORE_THAN_ZERO,
	DAANCD_IND_MAX_ALTERNATE_IS_MAX_OUT_N,
	DAANCD_IND_MAX_ALTERNATE_IS_MAX_IN_C,
	DAANCD_NODE_OFFSETS_ALTERNTE,
	DAANCD_SQR_NODE_ODFFSETS_ALTERNATE,

	DAANCD_NUM_FIELDS
} ScoreModelFields_DAANCD;





class ScoreDoubleAA {
public:

	ScoreDoubleAA() : ind_model_was_read(false) {};

	void score_double_aa_variants(PrmGraph& prm) const;

	bool read_model(Config *config, char *model_name);

	bool get_ind_model_was_read() const { return ind_model_was_read; }

	float calc_variant_prob(const PrmGraph& prm, int me_idx, int* variant_ptr) const;


	void train_daa_models(const FileManager& fm, Model *model, float all_aa_ratio = 0.075);

	void train_daancd_model(const FileManager& fm, Model *model);

private:
	
	bool ind_model_was_read;

	vector<ME_Regression_Model *> daa_me_models;   // one per aa, models for edges with two nodes with frags (not connected to terminals)
	ME_Regression_Model *daancd_me_model;  // single model, all aas

	vector<int> model_n_aas, model_c_aas;

	// selects what combos will be evaluated in the models, and establishes a hierarchy
	// by which the models will be created
	void initialize_model_aa_combos();

	// returns what model idx should be used for this combo of amino acids
	// decides by traversing the model_n_aas and model_c_aas (simultanously) and
	// finds which idx 
	int get_daa_model_idx(int n_aa, int c_aa) const;

	bool is_inner_aa_edge(const PrmGraph& prm, int me_idx) const;

	void fill_fval_vector_for_inner_edge(const PrmGraph& prm, int me_idx, int* variant_ptr, 
										 ME_Regression_Sample& sam) const;

	void fill_fval_vector_for_ncd_edge(const PrmGraph& prm, int me_idx, int* variant_ptr, 
										 ME_Regression_Sample& sam) const;
};

#endif

