#ifndef __SCORESINGLEAA_H__
#define __SCORESINGLEAA_H__

#include "PrmGraph.h"
#include "ME_REG.h"
#include "includes.h"

// used to score aa that are not connected to the terminals or the digest nodes

typedef enum ScoreModelFields_SAA { SAA_CONST,

	SAA_N_SCORE_ABOVE_TWO_THIRDS, SAA_C_SCORE_ABOVE_TWO_THIRDS,
	SAA_IND_TWO_THIRDS_BOTH_ABOVE,

	SAA_N_SCORE_ABOVE_THIRD, SAA_C_SCORE_ABOVE_THIRD,
	SAA_IND_THIRD_BOTH_ABOVE,

	SAA_N_SCORE_ABOVE_ZERO, SAA_C_SCORE_ABOVE_ZERO,
	SAA_IND_ZERO_BOTH_ABOVE,

	SAA_MAX_SCORE_RANK, SAA_MIN_SCORE_RANK,  
	SAA_N_SCORE_RANK,   SAA_C_SCORE_RANK, SAA_SCORE_RANK_SUM,
	SAA_SCORE_RANK_DIFF, SAA_SCORE_RANK_ABS_DIFF, 
	SAA_N_NUM_FRAGS,   SAA_C_NUM_FRAGS, SAA_NUM_FRAG_DIFF, SAA_ABS_NUM_FRAG_DIFF,
	SAA_IND_N_STRONGER_INTEN, SAA_N_STRONGER_LOG_NC_INTEN_RATIO,      // max val +- 5 
	SAA_IND_C_STRONGER_INTEN, SAA_C_STRONGER_LOG_NC_INTEN_RATIO,      // max val +- 5 

	SAA_IND_N_IS_MAX_IDX_TO_C,   
	SAA_IND_C_IS_MAX_IDX_FROM_N, SAA_DIFF_N_MAX_IN_C_SCORE_RANKS, 
	SAA_IND_N_NOT_MAX_IDX_TO_C,   
	SAA_IND_C_NOT_MAX_IDX_FROM_N, SAA_DIFF_C_MAX_OUT_N_SCORE_RANKS,

	SAA_IND_BOTH_CONNECT_TO_MAX, 

	SAA_NODE_MASS_DIFF,     SAA_NODE_SQR_MASS_DIFF,    SAA_NUM_FRAG_PAIRS,
	SAA_AVG_PEAK_DIFF,      SAA_AVG_PEAK_SQR_DIFF,
	SAA_BEST_PEAK_DIFF,     SAA_BEST_PEAK_SQR_DIFF,    SAA_IND_NO_PEAK_DIFF,

	SAA_AVG_PEAK_DIFF_TIMES_SCORE_RANK_SUM,
	SAA_AVG_PEAK_DIFF_TIMES_SCORE_ABS_DIFF,
	SAA_AVG_PEAK_DIFF_DIV_NUM_FRAG_PAIRS,

	SAA_IND_BOTH_CONNECT_TO_MAX_TIMES_AVG_DIFF,

/*	SAA_IND_N_CONNECT_TO_A, SAA_SCORE_A, SAA_ABS_SCORE_DIFF_A, SAA_N_PEAK_DIFF_A,
	SAA_IND_N_CONNECT_TO_G, SAA_SCORE_G, SAA_ABS_SCORE_DIFF_G, SAA_N_PEAK_DIFF_G,
	SAA_IND_N_CONNECT_TO_D, SAA_SCORE_D, SAA_ABS_SCORE_DIFF_D, SAA_N_PEAK_DIFF_D,
	SAA_IND_N_CONNECT_TO_E, SAA_SCORE_E, SAA_ABS_SCORE_DIFF_E, SAA_N_PEAK_DIFF_E,
	SAA_IND_N_CONNECT_TO_V, SAA_SCORE_V, SAA_ABS_SCORE_DIFF_V, SAA_N_PEAK_DIFF_V,
	SAA_IND_N_CONNECT_TO_S, SAA_SCORE_S, SAA_ABS_SCORE_DIFF_S, SAA_N_PEAK_DIFF_S,*/

/*	SAA_IND_CHARGE1, SAA_IND_CHARGE2, SAA_IND_CHARGE3,
	SAA_CHARGE1_MAX_SCORE_RANK, SAA_CHARGE1_MIN_SCORE_RANK,
	SAA_CHARGE2_MAX_SCORE_RANK, SAA_CHARGE2_MIN_SCORE_RANK, 
	SAA_CHARGE3_MAX_SCORE_RANK, SAA_CHARGE3_MIN_SCORE_RANK, */

/*	SAA_IND_C_CONNECT_TO_A, SAA_C_SCORE_A, SAA_C_SQR_PEAK_DIFF_A,
	SAA_IND_C_CONNECT_TO_G, SAA_C_SCORE_G, SAA_C_SQR_PEAK_DIFF_G,
	SAA_IND_C_CONNECT_TO_D, SAA_C_SCORE_D, SAA_C_SQR_PEAK_DIFF_D,
	SAA_IND_C_CONNECT_TO_E, SAA_C_SCORE_E, SAA_C_SQR_PEAK_DIFF_E,
	SAA_IND_C_CONNECT_TO_V, SAA_C_SCORE_V, SAA_C_SQR_PEAK_DIFF_V,
	SAA_IND_C_CONNECT_TO_S, SAA_C_SCORE_S, SAA_C_SQR_PEAK_DIFF_S,*/

//	SAA_ORACLE, SAA_ORACLE2,

	SAA_NUM_FIELDS
} ScoreModelFields_SAA;


typedef enum ScoreModelFields_SAANCD { SAANCD_CONST,
	SAANCD_IND_CONNECTS_TO_NODE_WITH_NO_FRAGS,
	SAANCD_IND_CONNECTS_TO_N_TERMINAL,
	SAANCD_IND_CONNECTS_TO_C_TERMINAL,
	SAANCD_IND_CONNECTS_TO_DIGEST,

	SAANCD_IND_HAS_MAX_SCORE_FROM_N,  	SAANCD_SCORE_FROM_N,
	SAANCD_IND_HAS_MAX_SCORE_TO_C,      SAANCD_SCORE_TO_C,
	SAANCD_IND_HAS_MAX_SCORE_TO_DIGEST, SAANCD_SCORE_TO_DIGEST,

	SAANCD_NODE_MASS_DIFF_FROM_N,     SAANCD_NODE_SQR_MASS_DIFF_FROM_N,
	SAANCD_NODE_MASS_DIFF_TO_C,     SAANCD_NODE_SQR_MASS_DIFF_TO_C,
	SAANCD_NODE_MASS_DIFF_TO_DIGEST,     SAANCD_NODE_SQR_MASS_DIFF_TO_DIGEST,

	SAANCD_IND_CHARGE1, SAANCD_IND_CHARGE2, SAANCD_IND_CHARGE3,


	SAANCD_NUM_FIELDS
} ScoreModelFields_SAANCD;





class ScoreSingleAA {
public:

	ScoreSingleAA() : ind_model_was_read(false) {};

	void score_single_aa_variants(PrmGraph& prm) const;

	bool read_model(Config *config, char *model_name);

	float calc_variant_prob(const PrmGraph& prm, int me_idx, int* variant_ptr) const;

	bool get_ind_model_was_read() const { return ind_model_was_read; }

	void train_saa_models(const FileManager& fm, Model *model, float all_aa_ratio = 0.075);
	void train_saancd_models(const FileManager& fm, Model *model);

private:
	
	bool ind_model_was_read;

	vector<int> saa_model_aas;
	vector<int> saancd_model_aas;

	vector<ME_Regression_Model *> saa_me_models;     // one per aa, models for edges with two nodes with frags (not connected to terminals)
	vector<ME_Regression_Model *> saancd_me_models;  // one per aa for connections to terminals and digest aas

	bool is_inner_aa_edge(const PrmGraph& prm, int me_idx) const;

	int get_saa_model_idx(int aa) const;

	int get_saancd_model_idx(int aa) const;

	void fill_fval_vector_for_inner_edge(const PrmGraph& prm, int me_idx, int* variant_ptr, 
										 ME_Regression_Sample& sam) const;

	void fill_fval_vector_for_ncd_edge(const PrmGraph& prm, int me_idx, int* variant_ptr, 
										 ME_Regression_Sample& sam) const;






};


#endif

