#ifndef __TAGMODEL_H__
#define __TAGMODEL_H__

#include "PrmGraph.h"
#include "EdgeModel.h"
#include "ME_REG.h"

typedef enum TAGM_Fields {
	TAGM_CONST, 
	TAGM_HAS_DENOVO_RANK,
	TAGM_DENOVO_RANK, TAGM_SCORE_RANK,  TAGM_MULTI_PATH_RANK,

	//6
	TAGM_IND_MULTI_PATH_RANK1, TAGM_IND_MULTI_PATH_RANK2, TAGM_IND_MULTI_PATH_RANK345,
	TAGM_IND_MULTI_PATH_RANK610,TAGM_IND_MULTI_PATH_RANK1120,  TAGM_IND_MULTI_PATH_RANK_HIGHER,

	//11
	TAGM_IND_SCORE_RANK1, TAGM_IND_SCORE_RANK2, TAGM_IND_SCORE_RANK345,
	TAGM_IND_SCORE_RANK610, TAGM_IND_SCORE_RANK1120,  TAGM_IND_SCORE_RANK_HIGHER,

	//17
	TAGM_IND_AVG_SCORE_MORE_15, TAGM_IND_AVG_SCORE_MORE_10, TAGM_IND_AVG_SCORE_MORE_5,
	TAGM_IND_AVG_SCORE_MORE_0,  TAGM_IND_AVG_SCORE_LOW,

	//22
	TAGM_LOG_DENOVO_RANK,  TAGM_LOG_SCORE_RANK, TAGM_LOG_MULTI_PATH_RANK,
	TAGM_PATH_SCORE,       TAGM_AVG_PATH_SCORE, TAGM_DIFF_SCORE_FROM_FIRST, 
	TAGM_AVG_DIFF_SCORE_FROM_FIRST, TAGM_SCORE_DIFF_TIMES_LOG_RANK_DIFF, 

	// 30
	TAGM_PROP_MISSING_NODES,
	TAGM_PROP_NODES_SCORE_ABOVE_10, TAGM_PROP_NODES_SCORE_ABOVE_5, 
	TAGM_PROP_NODES_SCORE_ABOVE_0,  TAGM_PROP_NODES_SCORE_BELOW_0,

	TAGM_PROP_EDGE_POSITIVE_SCORE,  
	TAGM_PROP_NODES_POSITIVE_TIMES_PROP_EDGES_POSITIVE,

	//37
	TAGM_IND_MIN_N_TERM,   TAGM_MIN_N_LOG_MIN_PROB,       
	TAGM_MIN_N_LOG_SUM,    TAGM_MIN_N_NUM_MISSING_NODES,
	TAGM_IND_MIN_MID,      TAGM_MIN_MID_LOG_MIN_PROB,   
	TAGM_MIN_MID_LOG_SUM,  TAGM_MIN_MID_NUM_MISSING_NODES,
	TAGM_IND_MIN_ENDS,     TAGM_MIN_ENDS_LOG_MIN_PROB,  
	TAGM_MIN_ENDS_LOG_SUM, TAGM_MIN_ENDS_NUM_MISSING_NODES,

	// 49
	TAGM_IND_ALL_PROBS_ABOVE_05,  TAGM_IND_ALL_PROBS_ABOVE_07,
	TAGM_IND_HAS_PROBS_ABOVE_05,  TAGM_IND_HAS_PROBS_ABOVE_07,
	TAGM_PROP_PROBS_ABOVE_05,     TAGM_PROP_PROBS_ABOVE_07,
	TAGM_IND_HAS_PROBS_BELOW_05,  TAGM_IND_HAS_PROBS_BELOW_02,
	TAGM_PROP_PROBS_BELOW_05,     TAGM_PROP_PROBS_BELOW_02,

	//59
	TAGM_IND_HAS_MIRROR, TAGM_IND_NO_MIRROR, TAGM_MIRROR_SCORE_DIFF,

	//62
	TAGM_NODE_MASS_OFFSET_01_TOL,
	TAGM_NODE_MASS_OFFSET_05_TOL,
	TAGM_NODE_MASS_OFFSET_10_TOL,
	TAGM_NODE_MASS_OFFSET_LARGE,

	// 66
	TAGM_IND_STARTS_AT_N,
	TAGM_IND_ENDS_AT_C,
	TAGM_MISSING_DIGEST_AAS,

	// 69
	TAGM_NUM_W, TAGM_MIN_PROB_W,
	TAGM_NUM_Q, TAGM_MIN_PROB_Q,
	TAGM_NUM_N, TAGM_MIN_PROB_N,

	// 75
	TAGM_NUM_PROBLEMATIC_AAS, TAGM_MIN_PROB_PROBLEMATIC_AAS,



	TAGM_NUM_FIELDS
} TAGM_Fields;




class TagModel {
public:
	TagModel() : was_initialized(false) {};

	void train_models(const FileManager& fm, Model *model);

	void write_tag_models(Config *config) const { write_models_file(config,true); write_models_file(config,false); }

	void read_tag_models(Config *config) { was_initialized = (read_models_file(config,true) && 
															  read_models_file(config,false) ); }
										

	float calc_seq_prob(const SeqPath& path, int charge, const PrmGraph& prm,
					   int denovo_rank, int score_rank, score_t top_score, bool from_denovo) const;

	bool get_was_initialized() const { return was_initialized; }

private:

	vector< vector< vector<ME_Regression_Model *> > > local_tag_models; // charge,length 3-6, rank set 1-3, 4-8, 9-16, 17-30, 31-50, 50+
	vector< vector< vector<ME_Regression_Model *> > > denovo_tag_models;

	vector< vector< int >  > charge_rank_levels; // per charge
	
	bool was_initialized;

	int get_rank_level(int charge, int rank) const
	{
		while (charge>=charge_rank_levels.size())
			charge--;

		const vector<int>& rank_levels = charge_rank_levels[charge];
		int i;
		for (i=0; i<rank_levels.size(); i++)
			if (rank<rank_levels[i])
				return i;
		return rank_levels.size();
	}

	void fill_tag_vector(const SeqPath& path, const PrmGraph& prm,
						 int denovo_rank, int score_rank, score_t top_score, 
						 ME_Regression_Sample& sam) const;

	bool read_models_file(Config *config, bool local_models = true);
	void write_models_file(Config *config, bool local_models = true) const;

};

#endif
