#ifndef SETMERGER_H
#define SETMERGER_H

#include <vector>
#include <list>
#include <iostream>
#include "batch.h"
using namespace std;

class SetMerger {
	vector<int> freePosList;
	int firstFreePos;
	void freePos(int pos) { freePosList[pos]=firstFreePos; firstFreePos=pos; }
	void reassignSet(int setIdx1, int setIdx2);
public:
	vector<int> membership;
	vector<list<int> > sets;
	unsigned int numSets;
	vector<vector<Results_ASP> > cAlignsASP;
	vector<vector<Results_PA> > cAlignsPA;
	vector<vector<int> > cAlignsASP_idx;
	vector<vector<int> > cAlignsPA_idx;
	
	SetMerger(int count=0) { resize(count); }

	int createset(int eltIdx) {
		if(firstFreePos<0) { cerr<<"SetMerger::create_set() - Not enough memory to create set for element "<<eltIdx<<"!\n"; exit(-1); }
		int setIdx = firstFreePos;  firstFreePos = freePosList[firstFreePos]; 
		addElement(setIdx,eltIdx); numSets++; return setIdx; 
	}
	void addElement(int setIdx, int eltIdx) { sets[setIdx].push_front(eltIdx); membership[eltIdx]=setIdx; }	
	void removeElements(int setIdx, list<int> &eltIndices);

	void createSets(unsigned int maxNumElems, unsigned int minSetSize, vector<Results_ASP> &pairsASP, vector<Results_PA> &pairsPA);
	void splitAligns(vector<Results_ASP> &pairsASP, vector<Results_PA> &pairsPA);
	bool spliceSet(SetMerger &other);

	void resize(unsigned int numMembers);
	unsigned int size() { return numSets; }
	unsigned int numElemsInSets() { unsigned int c=0; for(unsigned int i=0;i<membership.size();i++) if(membership[i]>=0) c++; return c; }	
	
	void merge(int setIdx1, int setIdx2);
	void splitSet(int setIdx, list<int> &elemsToKeep);
	void removeSmallSets(unsigned int minSetSize);
	void compressSetIndices();
	
	int saveas_binListArray(char *filename);
};

#endif
