function [specs, eitp] = sn_enforceannots(specs, peptides, specType, peakTol, addModMasses, minPercEI, minPercTP)
% function [specs, eitp] = sn_enforceannots(specs, peptides, specType, peakTol, addModMasses, minPercEI, minPercTP)

if size(specs,2)==5 idxSpec=2; idxPM=3; idxPep=5; else idxSpec=3; idxPM=5; idxPep=7; end;
specs(:,idxPep) = peptides;
[percs, foo, blists] = sn_getbypercs(specs, specType, peakTol, '', [], addModMasses, 0, 1, 0);   eitp = percs(:,[5 1]);

for i=1:size(specs,1)
    if isempty(peptides{i}) | (percs(i,5)+percs(i,7))<minPercEI | max(percs(i,1),percs(i,3))<minPercTP specs{i,idxPep} = ''; continue; end;
    masses = sn_getmasses(peptides{i},'',[],addModMasses);   parentmass = sum(masses)+18.010564686+strcmp(specType,'msms')*1.0072763;
    masses = cumsum(masses);

    spec = specs{i,idxSpec};    specs{i,idxPep} = peptides{i};
    if percs(7)>percs(5)  % Reverse spectrum if peaks are annotated as y
        spec(:,1) = parentmass-spec(:,1); 
        spec = sortrows(spec);
        tmpSpec = specs(i,:);   tmpSpec{1,idxSpec}=spec;
        [curPercs, foo, curBList] = sn_getbypercs(tmpSpec, specType, peakTol, '', [], addModMasses, 0, 1, 0);    curBList = curBList{1};    eitp(i,:) = curPercs([5 1]);
    else curBList = blists{i}; end;

    if ~isempty(masses)
        scores = zeros(length(masses),1);   scores(curBList(:,1))=curBList(:,2)*sum(spec(:,2));
        specs{i,idxSpec} = [masses' scores];
    else specs{i,idxSpec} = []; end;
end;
