function sn_save_mgf(specs, parentMasses, parentCharges, filename)
% function sn_save_mgf(specs, parentMasses, parentCharges, filename)

fid = fopen(filename,'w'); if fid<0 fprintf(1,'Error opening %s!\n',filename); end;
numSpecs = size(specs,1);
for i=1:numSpecs
    if size(parentCharges,1)==numSpecs z=parentCharges{i}; else if isempty(parentCharges) z=0; else z=parentCharges; end; end;
    if z>0 
        pm = (parentMasses{i}-1.0072763+z*1.0072763)/z; 
        fprintf(fid,'BEGIN IONS\r\nTITLE=spec_%.0d.dta\r\nCHARGE=+%.0f\r\nPEPMASS=%.3f\r\n',i,z,pm);
    else 
        pm = parentMasses{i}; 
        fprintf(fid,'BEGIN IONS\r\nTITLE=spec_%.0d.dta\r\nCHARGE=+0\r\nPEPMASS=%.3f\r\n',i,pm);
    end;
    if ~isempty(specs{i}) fprintf(fid,'%.2f %.1f\r\n',double(specs{i}(:,1:2)')); end;
    fprintf(fid,'END IONS\r\n\r\n');
end;

fclose(fid);
