#ifndef SPECTRAL_PAIRS_H
#define SPECTRAL_PAIRS_H

#include "spectrum.h"
#include "batch.h"
#include "label.h"
#include <fstream>

void SplitPairs3(SpecSet &specSet, vector<Results_ASP> &aligns, vector<Results_PA> &alignsPA,
				float peakTol, int maxAAjump, float penalty_sameVert, float penalty_ptm,
				vector<vector<TwoValues<int> > > &matches, vector<vector<TwoValues<int> > > &matchesPA, 
				vector<bool> &specFlipped, vector<float> &modPos,
				bool forceSymmetry=false, vector<SpectrumPeakLabels> *labelsP=NULL,
                                vector<TwoValues<float> > *alignRatios=NULL, vector<TwoValues<float> > *alignRatiosPA=NULL);
				
void SplitSpectra(SpecSet &specSet, SpecSet &specSetSplit);
void SplitAligns(SpecSet &specSetSplit, vector<Results_ASP> &aligns,
				float peakTol, int maxAAjump, float penalty_sameVert, float penalty_ptm, bool forceSymmetry,
				vector<Results_ASP> &alignsNew, vector<vector<TwoValues<int> > > &matches, 
				vector<bool> &pairFlipped, vector<vector<float> > *dbg_matchScores=0,
				ofstream *debug=0);

void SplitLabels(vector<SpectrumPeakLabels> &labels, vector<SpectrumPeakLabels> &newLabels);

#endif
