function [idxASP, idxPA, info] = sps_filter_samepep(parentMasses, pairs_asp, aligns_asp, aligns_pa, tolerance)
% function [idxASP, idxPA, info] = sps_filter_samepep(parentMasses, pairs_asp, aligns_asp, aligns_pa, tolerance)

szASP = size(pairs_asp,1);   szPA = size(aligns_pa,1);
aligns = zeros(szASP+szPA,4);
aligns(1:szASP,1:2) = pairs_asp;    aligns(1:szASP,4) = aligns_asp(:,1);
if ~isempty(aligns_pa) aligns(szASP+1:szASP+szPA,1:4) = aligns_pa(:,1:4); end;

[vSets, eSets] = sps_assembleE(aligns);

numSets = size(vSets,1);   keepSet = zeros(numSets,1);   info = [numSets szASP+szPA];
if size(parentMasses,2)>size(parentMasses,1) parentMasses=parentMasses'; end;
for setIdx=1:numSets
    setShifts = aligns(eSets{setIdx},3:4);
    idxOk = find(abs(setShifts)>tolerance);
    if ~isempty(idxOk) keepSet(setIdx)=1; continue; end;  
    
    setPMs = parentMasses(vSets{setIdx});
    idxOk = find(abs( repmat(setPMs,1,length(setPMs)) - repmat(setPMs',length(setPMs),1) )>tolerance);
    if ~isempty(idxOk) keepSet(setIdx)=1; end;
end

idxEdges = [eSets{find(keepSet==1)}]';
idxASP = idxEdges(find(idxEdges<=szASP));
idxPA = idxEdges(find(idxEdges>szASP))-szASP;
info = [info size(find(keepSet==1),1) size(idxEdges,1)];
