function [newAligns, keptIdx] = sps_filter_trigs(aligns, tolerance)
% function [newAligns, keptIdx] = sps_filter_trigs(aligns, tolerance)

szAligns = size(aligns,1);
numVertices = max(max(aligns(:,[1 2])));

incoming = cell(numVertices,1);  % incoming edges (to vertex)
next = cell(numVertices,1);      % next vertices from vertex
for i=1:szAligns
    next{aligns(i,1),1} = [next{aligns(i,1),1} aligns(i,2)];
    incoming{aligns(i,2),1} = [incoming{aligns(i,2),1} i];
end;

done = zeros(szAligns,1);
for i=1:szAligns
    v1 = aligns(i,1);   v2 = aligns(i,2);   shift = aligns(i,3);
    nextVs = intersect(next{v1,1},next{v2,1});
    if isempty(nextVs) continue; end;
    
    for v=1:size(nextVs,2)
        v3 = nextVs(v);
        fromV1idx = incoming{v3,1}(find(aligns(incoming{v3,1},1)==v1));   sz1 = max(size(fromV1idx));
        fromV2idx = incoming{v3,1}(find(aligns(incoming{v3,1},1)==v2));

        shifts2 = aligns(fromV2idx,3) + shift;
        for j=1:size(shifts2)
            idx = find( abs(aligns(fromV1idx,3) - repmat(shifts2(j),sz1,1)) <= 2*tolerance );
            if isempty(idx) continue; end;
            done([i fromV2idx(j) fromV1idx(idx)]) = 1;
        end
    end
end
keptIdx = find(done==1);
newAligns = aligns(keptIdx,:);
