function [stars, stars_idx] = sps_genstars(specs, pairs_asp, pairs_po, peakTol, pmTol, resolution)
% function [stars, stars_idx] = sps_genstars(specs, pairs_asp, pairs_po, peakTol, pmTol, resolution)

specs_asp = sn_load_pklbin('pairs.pklbin');    szPO = size(pairs_po,1);
modPositions = [sn_load_binarray('pairs_modpos.bin','float'); -ones(szPO,1)];   

specs_po = cell(2*szPO,5);
for p=1:szPO
    [score, prmIndex] = aux_scoreOverlap(specs{pairs_po(p,1),2}, specs{pairs_po(p,1),3}, specs{pairs_po(p,2),2}, specs{pairs_po(p,2),3}, pairs_po(p,3), peakTol);
    specs_po(2*p-1,:) = [{ specs{pairs_po(p,1),1}, specs{pairs_po(p,1),2}(prmIndex{1,1},:)} specs(pairs_po(p,1),3:5)];
    specs_po(2*p,:)   = [{ specs{pairs_po(p,2),1}, specs{pairs_po(p,2),2}(prmIndex{1,2},:)} specs(pairs_po(p,2),3:5)];
end;

pairs = [pairs_asp(:,1:2); pairs_po(:,1:2)];
specs_pairs = [specs_asp; specs_po];

idx = reshape(pairs',2*size(pairs,1),1)';   idx_other = reshape(pairs(:,[2 1])',2*size(pairs,1),1)';
stars_idx = unique(idx);   szUI = size(stars_idx,2);   vSets = cell(szUI,1);
for i=1:szUI   
    vSets{i} = find(idx==stars_idx(i));   
end

masses = [specs{:,3}]';  masses = masses(pairs');
otherPM = reshape([masses(2,:); masses(1,:)],size(idx,2),1)';
[dirs, consensus, endpoints] = aux_orient_stars(specs_pairs, vSets, modPositions, otherPM, peakTol, pmTol, specs(idx,size(specs,2)), 1-1e-2, 0.001, 2, 'avg', resolution);

stars = specs;
stars(stars_idx,:) = consensus;

function [score, prmIndex] = aux_scoreOverlap(prmList1, mhMass1, prmList2, mhMass2, shift, tolerance)
% function [score, prmIndex] = aux_scoreOverlap(prmList1, mhMass1, prmList2, mhMass2, shift, tolerance)

if tolerance<=0 
    idx1 = [];   idx2 = [];  i1=1; i2=1;  prmList2(:,1) = prmList2(:,1) + shift;
    while i1<=size(prmList1,1) & i2<=size(prmList2,1)
        if prmList1(i1,1)==prmList2(i2,1) idx1 = [idx1; i1]; idx2 = [idx2; i2]; i1=i1+1; i2=i2+1; 
        else if prmList1(i1,1)<prmList2(i2,1) i1=i1+1; else i2=i2+1; end;
        end;
    end;
end;

if tolerance>0 [idx1, idx2] = aux_findMatchPeaks(prmList1, prmList2, shift, tolerance);  end;
if size(idx1,1)==0 score=0; prmIndex={[],[]}; return; end;

prmCount = size(idx1,1);
tmpScore = zeros(3, prmCount+1);  % one more entry to initialize the algorithm
tmpScore(1,2:prmCount+1) = prmList1(idx1,2)' + prmList2(idx2,2)';
tmpScore(2,2:prmCount+1) = 1;
maxIdx = 1;
forbiddenIdx = 2;  % First prm
for i=3:(prmCount+1)
    % try to advance forbidden
    while prmList1(idx1(forbiddenIdx-1),1) <= prmList1(idx1(i-1),1)-56  % 56 instead of 57 is an implicit 1 dalton tolerance
        if tmpScore(1,forbiddenIdx) > tmpScore(1,maxIdx) maxIdx = forbiddenIdx; end;
        forbiddenIdx=forbiddenIdx+1;
    end;
    
    % simply connect to the maximal scoring available prm
    tmpScore(:,i) = [tmpScore(1,i)+tmpScore(1,maxIdx) tmpScore(2,maxIdx)+1 maxIdx]';
end;
[foo, bestIdx] = max(tmpScore(1,forbiddenIdx:(prmCount+1)));
bestIdx = forbiddenIdx + bestIdx - 1;

score = tmpScore(1,bestIdx);
finalCount = tmpScore(2,bestIdx);
idxOut1=zeros(1,finalCount); idxOut2=zeros(1,finalCount); i=0; j=bestIdx;
while j>1
    idxOut1(1,finalCount-i)=idx1(j-1);   idxOut2(1,finalCount-i)=idx2(j-1);
    j = tmpScore(3,j); i=i+1;
end;
prmIndex = {idxOut1, idxOut2};

if shift<0
    idx=find(abs(prmList2(:,1)+shift)<=tolerance);
    if ~isempty(idx) [m,idxMax]=max(prmList2(idx,2)); score=score+m; prmIndex{1,2}=[prmIndex{1,2} idx(idxMax(1))]; end;
else 
    idx=find(abs(prmList1(:,1)-shift)<=tolerance);
    if ~isempty(idx) [m,idxMax]=max(prmList1(idx,2)); score=score+m; prmIndex{1,1}=[prmIndex{1,1} idx(idxMax(1))]; end;
end;
if mhMass1-shift<mhMass2
    idx=find(abs(prmList2(:,1)-(mhMass1-19-shift))<=2*tolerance);
    if ~isempty(idx) [m,idxMax]=max(prmList2(idx,2)); score=score+m; prmIndex{1,2}=[prmIndex{1,2} idx(idxMax(1))]; end;
else    
    idx=find(abs(prmList1(:,1)-(mhMass2-19+shift))<=2*tolerance);
    if ~isempty(idx) [m,idxMax]=max(prmList1(idx,2)); score=score+m; prmIndex{1,1}=[prmIndex{1,1} idx(idxMax(1))]; end;
end  

prmIndex{1,1} = unique(prmIndex{1,1});
prmIndex{1,2} = unique(prmIndex{1,2});
score = sum(prmList1(prmIndex{1,1},2)) + sum(prmList2(prmIndex{1,2},2));

function [idx1, idx2] = aux_findMatchPeaks(peakList1, peakList2, shift, tolerance)
% function [idx1, idx2] = aux_findMatchPeaks(peakList1, peakList2, shift, tolerance)

peakCount1 = size(peakList1,1);   peakCount2 = size(peakList2,1);
if peakCount1==0 | peakCount2==0 idx1=[]; idx2=[]; return; end;
peakList2(:,1) = peakList2(:,1) + shift;  % apply shift to peakList2

matches = abs(repmat(peakList1(:,1),1,peakCount2) - repmat(peakList2(:,1)',peakCount1,1)) - tolerance <= 1e-5;
idxMatch = find(matches==1);

if ~isempty(idxMatch)
	cols = ceil(idxMatch / peakCount1);
	lines = mod(idxMatch,peakCount1);   lines(find(lines==0))=peakCount1;
	
	idx = sortrows([lines cols]);
    idx1 = idx(:,1);   idx2 = idx(:,2);
else
    idx1=[]; idx2=[];
end

function [dirs, consensus, endpoints] = aux_orient_stars(specSet, vSets, modOffsets, otherPM, peakTol, pmTol, peptides, pValue, probNoise, mergeType, scoreMergeType, resolution)
% function [dirs, consensus, endpoints] = aux_orient_stars(specSet, vSets, modOffsets, otherPM, peakTol, pmTol, peptides, pValue, probNoise, mergeType, scoreMergeType, resolution)

if nargin<12 resolution=0.1; end;

numSets = size(vSets,1);   dirs = cell(numSets,1);   consensus = cell(numSets,5);   endpoints = cell(numSets,1);
if resolution==0.1 pmTolRange = [-pmTol:.5:pmTol]; else pmTolRange = [-pmTol:resolution:pmTol]; end;
szRange = size(pmTolRange,2);
for i=1:numSets
    if isempty(vSets{i}) continue; end;
    specs = specSet(vSets{i},:);   numSpecs = size(specs,1);   pmMass = specs{1,3}-1;    dirs{i}=zeros(numSpecs,1);
    endpoints{i} = [];
    if ~isempty(modOffsets) curOffsets = modOffsets(ceil(vSets{i}/2),:); end;  % division by 2 converts from specIdx to pairIdx
    
    baseSpec = [specs(1,:);specs(1,:)];  % Second entry will contain the reversed spectrum (line below)
    baseSpec{2,2}(:,1) = pmMass-baseSpec{2,2}(:,1);   [foo, idxS]=sort(baseSpec{2,2}(:,1));   baseSpec{2,2}=baseSpec{2,2}(idxS,:);
    
    for s=1:numSpecs
        if isempty(specs{s,2}) continue; end;
        curEndpoints = [];
        if ~isempty(modOffsets) & curOffsets(s)>=0 & otherPM(vSets{i}(s))<pmMass+1-pmTol  % second condition because only the larger spectrum can gain endpoint peaks
            if curOffsets(s)<=pmTol curEndpoints = [pmMass+1-otherPM(vSets{i}(s)) max(specs{s,2}(:,2))]; end;    % Mod at the start
            if curOffsets(s)>=otherPM(vSets{i}(s))-pmTol curEndpoints = [otherPM(vSets{i}(s))-19 max(specs{s,2}(:,2))]; end;  % Mod at the end
        end;
        if s==1 endpoints{i} = curEndpoints; continue; end % this line added to allow the endpoints code above to be run for s=1 also
        
        [idx1, idx2] = aux_findMatchPeaks2(baseSpec{1,2}, specs{s,2}, 0, peakTol);
        scoreB = sum(baseSpec{1,2}(idx1,2)) + sum(specs{s,2}(idx2,2));
        
        scoreY=0;  bestShift = pmTol;
        for r=1:szRange
            [idx1, idx2] = aux_findMatchPeaks2(baseSpec{2,2}, specs{s,2}, pmTolRange(r), peakTol);
            curScoreY = sum(baseSpec{2,2}(idx1,2)) + sum(specs{s,2}(idx2,2));
            if curScoreY==scoreY & abs(pmTolRange(r))<bestShift bestShift=pmTolRange(r); end
            if curScoreY>scoreY scoreY=curScoreY; bestShift=pmTolRange(r); end;
        end

        if (scoreY>scoreB)
            specs{s,2}(:,1) = pmMass-specs{s,2}(:,1);   [foo, idxS]=sort(specs{s,2}(:,1));   specs{s,2}=specs{s,2}(idxS,:);
            if ~isempty(curEndpoints) curEndpoints(1,1) = pmMass-18-curEndpoints(1,1); end;  % At most one endpoint per spectrum
        end;
        endpoints{i} = [endpoints{i}; curEndpoints];
        dirs{i}(s) = scoreY>scoreB;
    end;
    
    consensus(i,:) = aux_getConsensus([specs(:,1:4) peptides(vSets{i})], {1:size(specs,1)}, peakTol, pValue, probNoise, mergeType, scoreMergeType, resolution);
end;

function [idx1, idx2] = aux_findMatchPeaks2(prmList1, prmList2, shift, tolerance)
% function [idx1, idx2] = aux_findMatchPeaks2(prmList1, prmList2, shift, tolerance)

prmList1 = [0 0; prmList1];         prmList2 = [0 0; prmList2(:,1)+shift prmList2(:,2)];
szList1 = size(prmList1,1);         szList2 = size(prmList2,1);
scores = zeros(szList1, szList2);   preds = cell(szList1, szList2);   preds{1,1} = [1 1; 0 0]; 

pairs = zeros(szList1*szList2,9);
pairs(1,:) = [1 1 0 0 0 0 0 0 0];
curPair = 2;   

startJ = 2;
for i=2:szList1
    for j=startJ:szList2
        if (prmList1(i,1)>prmList2(j,1)+tolerance) startJ = j+1; continue; end;
        if (prmList1(i,1)<prmList2(j,1)-tolerance) break; end;

        prevPair=curPair-1; while pairs(prevPair,1)>=i | pairs(prevPair,2)>=j prevPair=prevPair-1; end;  % find (i-1,j-1)

        if pairs(prevPair,3)+prmList1(i,2)+prmList2(j,2)>pairs(curPair-1,3)
            pairs(curPair,:) = [i j pairs(prevPair,3)+prmList1(i,2)+prmList2(j,2) i j pairs(prevPair,[4 5]) prevPair pairs(prevPair,9)+1];
        else
            pairs(curPair,:) = [i j pairs(curPair-1,3:9)];
        end;
        
        curPair = curPair + 1;
    end
end

curPair = curPair-1;      szKeep = pairs(curPair,9);      toKeep = zeros(szKeep,2);
for i=szKeep:-1:1
    toKeep(i,:) = pairs(curPair,[4 5]);   curPair = pairs(curPair,8);
end

idx1 = toKeep(:,1)-1;
idx2 = toKeep(:,2)-1;

function consensus = aux_getConsensus(specSet, vSets, windowSize, pValue, noiseProb, mergeType, scoreMergeType, resolution)
% function consensus = aux_getConsensus(specSet, vSets, windowSize, pValue, noiseProb, mergeType, scoreMergeType, resolution)

if nargin<8 resolution=0.1; end;

if size(specSet,2)==5 idxSpec=2; idxPM=3; idxPep=5; isContig=0; numCols=5; else idxSpec=3; idxPM=5; idxPep=7; isContig=1; numCols=7; end;
numClusters = size(vSets,1);    consensus = cell(numClusters,numCols);   
numBinsInWindow = 1+2*windowSize/resolution;
numRegions = size(noiseProb,2); pSuccess = 1-(1-noiseProb).^numBinsInWindow;   pValue = pValue * ones(1,numRegions);
for i=1:numClusters
    regions = round(cumsum(ones(1,numRegions)*max([specSet{vSets{i,1},idxPM}])/numRegions)/resolution);

    toKeep = binoinv( pValue, size(vSets{i,1},2)*ones(1,numRegions) , pSuccess);

    [counts,matches]=aux_peakCoherence(specSet(vSets{i,1},:),isContig,windowSize,0,resolution);

    consensus{i,idxSpec} = [];   regionStart = 0;
    for j=1:numRegions
        idx = regionStart+find(matches((regionStart+1):min(regions(j),size(matches,1)),1)>=max(1,toKeep(j)));
        if strcmp(scoreMergeType,'sum')
            consensus{i,idxSpec} = [consensus{i,idxSpec}; [idx*resolution matches(idx,3)]];
        else
            consensus{i,idxSpec} = [consensus{i,idxSpec}; [idx*resolution matches(idx,3)./matches(idx,1)]];
        end
        regionStart = regions(j);
    end

    if mergeType==2 
        if ~isempty(consensus{i,idxSpec}) consensus{i,idxSpec} = aux_merge_peaks(consensus{i,idxSpec},round(windowSize/resolution),resolution); end;
    end;
    
    consensus{i,1} = [specSet{vSets{i,1},1}];
    consensus{i,idxPM} = mean([specSet{vSets{i,1},idxPM}]);

    if isContig==0
        h = hist([specSet{vSets{i,1},4}],[0:3]);
        consensus{i,4} = min(find(h==max(h)))-1;
    end;
    
    maxLen=0; for j=1:size(vSets{i,1},2) if size(specSet{vSets{i,1}(j),idxPep},2)>maxLen  maxLen=size(specSet{vSets{i,1}(j),idxPep},2); end; end;
    if maxLen==0 consensus{i,idxPep}=''; else
        strs = unique(specSet(vSets{i,1},idxPep));     strCounts = zeros(size(strs,1),1);
        for j=1:size(strs,1) strCounts(j)=sum(strcmp(strs{j,1},specSet(vSets{i,1},idxPep))); end;
        consensus{i,idxPep} = strs{ min(find(strCounts==max(strCounts))) ,1};
    end;
end

function [counts, matches, idxPeaks] = aux_peakCoherence(specSet, isContig, windowSize, getIdx, resolution) % , peptide, tolerance)
% function [counts, matches, idxPeaks] = aux_peakCoherence(specSet, isContig, windowSize, getIdx, resolution) % , peptide, tolerance)

if nargin<5 resolution=0.1; end;

numSpecs = size(specSet,1);                
if isContig maxMass = ceil(max([specSet{:,5}])/resolution); else maxMass = ceil(max([specSet{:,3}])/resolution); end;
window = [-(windowSize/resolution):(windowSize/resolution)];   szWindow = size(window,2);   windowCenter = round(windowSize/resolution)+1;

matches = zeros(maxMass,3);
if getIdx==1 idxPeaks=cell(maxMass,1); else idxPeaks=[]; end;
for i=1:numSpecs
    if isContig spec = specSet{i,3}; mhMass = specSet{i,5}; else spec = specSet{i,2}; mhMass = specSet{i,3}; end;

    idxKeptPeaks = find(spec(:,1)>windowSize & spec(:,1)<mhMass-windowSize);
    spec = spec(idxKeptPeaks,:);
    if(isempty(spec)) continue; end;

    peaks = round(spec(:,1)/resolution);   peaks = peaks(find(peaks>(windowSize/resolution) & peaks<round((mhMass/resolution)-(windowSize/resolution))));
    peaks = repmat(peaks,1,szWindow)+repmat(window,size(peaks,1),1);

    for j=1:size(peaks,1) 
        matches(peaks(j,:),2) = matches(peaks(j,:),2) + spec(j,2) + [-windowSize:resolution:0 -[resolution:resolution:windowSize]]'; 
        matches(peaks(j,windowCenter),3) = matches(peaks(j,windowCenter),3) + spec(j,2); 
        if getIdx==1
            for k=1:size(peaks,2) idxPeaks{peaks(j,k)} = [idxPeaks{peaks(j,k)}; [i idxKeptPeaks(j)]]; end;
        end
    end;
    
    spec = zeros(maxMass,1);
    spec(peaks)=1;
    matches(:,1) = matches(:,1) + spec;
end;

counts = hist(matches(:,1),[1:numSpecs]);

function newSpec = aux_merge_peaks(spec, lookAhead, resolution)
% function newSpec = aux_merge_peaks(spec, lookAhead, resolution)

szSpec = size(spec,1);
peakSets = {};         numSets = 0;
curPeak = spec(1,1);   curSet = [1];
for i=2:szSpec
    if spec(i,1)-curPeak-resolution <= .0001 curSet = [curSet i]; end;
    if i==szSpec | spec(i,1)-curPeak-resolution > .0001
        numSets = numSets+1;
        peakSets = [peakSets; {curSet}];
        curSet = [i];
    end
    curPeak = spec(i,1);
end

w0 = [1:lookAhead];   w1 = round(1/resolution)+w0;   w2 = round(2/resolution)+w0;
newSpec = [];
for i=1:numSets
tmp = spec(peakSets{i},:);
    if size(peakSets{i},2)<=15        scores = aux_scoreWindows(spec(peakSets{i},:),w0,[],[]);
    else if size(peakSets{i},2)<=25   scores = aux_scoreWindows(spec(peakSets{i},:),w0,w1,[]);
        else scores = aux_scoreWindows(spec(peakSets{i},:),w0,w1,w2);
        end
    end
    [intensity, idx] = max(scores);   idx=min(idx);  if intensity<1e-5 continue; end;
    
    peakIso = idx+10;
    if peakIso <= size(peakSets{i},2)
        if scores(peakIso)==0 
            all = find(scores>0);   diffs = abs(all-peakIso);  options = find(diffs==min(diffs));   
            if max(size(options))==2 options=max(options); end  
            peakIso = all(options);
        end
        
        v = [scores(idx) scores(peakIso)]/sum(scores([idx peakIso]));
        newSpec = [newSpec; spec(peakSets{i}([idx peakIso]'),1) [intensity-scores(peakIso) scores(peakIso)]'];
    else
        newSpec = [newSpec; spec(peakSets{i}(idx),1) intensity];
    end
end

function [scores, scoresIso] = aux_scoreWindows(spec,window1,window2,window3)
% function [scores, scoresIso] = aux_scoreWindows(spec,window1,window2,window3)

szSpec = size(spec,1);   scores = zeros(szSpec,1);
idx = [window1 window2 window3];   idx = idx(find(idx<=szSpec)); 
for i=1:szSpec
    if spec(idx(1),2)==0 scores(i)=0; else scores(i) = sum(spec(idx,2)); end
    idx = idx+1;   if idx(size(idx,2))>szSpec idx=idx(1:size(idx,2)-1); end;
end