function abinfo = sps_load_abinfo(filename)
% function abinfo = sps_load_abinfo(filename)

fid = fopen(filename,'r'); if fid<=0 fprintf(1,'Error opening %s!\n',filename); abinfo={}; return; end;

numUsedSpectra = fread(fid,1,'int32');   
specIndices = fread(fid,numUsedSpectra,'int32') + 1;
specInfo = fread(fid,numUsedSpectra*2,'int16');   specInfo = reshape(specInfo, 2, numUsedSpectra)';   specInfo(:,1)=specInfo(:,1)+1;  % +1 to convert component indices to 1-based
numComponents = fread(fid,1,'int32');
vertsPerComp = fread(fid,numComponents,'int16');   totNumVerts = sum(vertsPerComp);
peaksPerVert = fread(fid,totNumVerts,'int16');     totNumPeaks = sum(peaksPerVert);
vertsSpecIdx = fread(fid,totNumPeaks,'int32') + 1;
vertsPeakMass = fread(fid,totNumPeaks,'float');
fclose(fid);

abinfo = cell(numComponents,2);   curV = 1;   curP = 1;
for c=1:numComponents
    idx = find(specInfo(:,1)==c);
    abinfo{c,1} = [specIndices(idx) specInfo(idx,2)];
    abinfo{c,2} = cell(vertsPerComp(c),1);
    for v=1:vertsPerComp(c)
        peakRange = [curP:curP+peaksPerVert(curV)-1];    curP = curP+peaksPerVert(curV);   curV = curV+1;
        abinfo{c,2}{v} = [vertsSpecIdx(peakRange) vertsPeakMass(peakRange)];
    end
end
