function [pairs_sp, pairs_asp, pairs_po, pairs_all] = sps_splitpairs(pmTol, threshMatchedPeaks, threshPvalue, filterTriangles)
% function [pairs_sp, pairs_asp, pairs_po, pairs_all] = sps_splitpairs(pmTol, threshMatchedPeaks, threshPvalue, filterTriangles)

% Load spectral pairs
stats_mp = load('pairs_mp.dat');
stats_means = load('pairs_means.dat');
stats_vars = load('pairs_vars.dat');
[a,b] = sps_load_aligns('pairs.dat',';');    pairs_all = [double(a) double(b)];
pairs_sp=[]; pairs_asp=[]; pairs_po=[];
if isempty(pairs_all) return; end;

% Filter pairs
if size(pairs_all,1)==1 pvalues = 1-normcdf( pairs_all(:,5:6), stats_means(pairs_all(:,1:2))', sqrt(stats_vars(pairs_all(:,1:2))') );
else pvalues = 1-normcdf( pairs_all(:,5:6), stats_means(pairs_all(:,1:2)), sqrt(stats_vars(pairs_all(:,1:2))) ); end;

idxOk = find(min(stats_mp')'>=threshMatchedPeaks & max(pvalues')'<=threshPvalue);
pairs_all=pairs_all(idxOk,:);

if filterTriangles==1 [pairs_all, idxT] = sps_filter_trigs(pairs_all,pmTol); end;

% Split into sp, asp, po
idx_asp1 = find(abs(pairs_all(:,3))<=pmTol);   idx_asp2 = find(abs(pairs_all(:,4))<=pmTol);   idx_sp = intersect(idx_asp1,idx_asp2);
pairs_sp = pairs_all(idx_sp,[1:3 5:6]);

idx_asp1 = setdiff(idx_asp1,idx_sp);    idx_asp2 = setdiff(idx_asp2,idx_sp);
pairs_asp = [pairs_all(idx_asp1,[1:2 4:6]); pairs_all(idx_asp2,[1:3 5:6])];

idx_po = setdiff([1:size(pairs_all,1)]',[idx_asp1;idx_asp2;idx_sp]);
pairs_po = pairs_all(idx_po,:);
