#ifndef TAGS_H
#define TAGS_H

#include "spectrum.h"
#include <vector>
#include <list>

using namespace std;

class Tag {
public:
	vector<char> sequence;     // Tag sequence (each entry indexes the corresponding amino
	                           //  acid in AAJumps::aaLetters)
	float flankingPrefix, flankingSuffix;  // Prefix/suffix flanking masses
	float score;               // Score for this tag
	
	Tag(unsigned short tagLen) { sequence.resize(tagLen); }
	
	const Tag &operator=(const Tag &other) {
		unsigned int seqLen = min(sequence.size(),other.sequence.size());
		for(unsigned int i=0; i<seqLen; i++) sequence[i]=other.sequence[i];
		score=other.score; flankingPrefix=other.flankingPrefix; flankingSuffix=other.flankingSuffix;
		return *this;
	}
};

unsigned int ExtractTags(Spectrum &spec, list<Tag> &tags, float peakTol,
                           unsigned int tagLen, unsigned int maxNumJumps);

#endif
