#include "utils.h"

#include <cmath>
#include <algorithm>
#include <iostream>
#include <cstdio>

struct value_index {   // Used in Utils::unique() to recover the indices of the sorted values
	float value; unsigned int index;
};
bool cmp_value_index(value_index vi1, value_index vi2) { return vi1.value<vi2.value; }

vector<float> &Utils::unique(vector<float> &v, float r, vector<unsigned int> *idx) {
    if (v.size()==0) return v;

	if(idx) {
		vector<value_index> tmpV(v.size());   idx->resize(v.size());
		for(unsigned int pivot=0; pivot<v.size(); pivot++) 
			{ tmpV[pivot].value=v[pivot]; tmpV[pivot].index=pivot; }
		sort(tmpV.begin(),tmpV.end(),cmp_value_index);
		for(unsigned int pivot=0; pivot<v.size(); pivot++)
			{ v[pivot]=tmpV[pivot].value; (*idx)[pivot]=tmpV[pivot].index; }
	} else sort(v.begin(),v.end());
    vector<float> newV(v);

    // Count number of different rounded elements
    int i, numElems = 1, lastElem = (int)round(newV[0]/r);
    for(i=1; i<newV.size(); i++) if (round(newV[i]/r)>lastElem) { numElems++; lastElem=(int)round(newV[i]/r); }

    // Store rounded elements
    v.resize(numElems);   if(idx) idx->resize(numElems);
    numElems = 0;     v[numElems] = round(newV[0]/r);
    for (i=1; i<newV.size(); i++) 
    	if (round(newV[i]/r)>v[numElems]) { 
    		numElems++; v[numElems]=round(newV[i]/r);
    		if(idx) (*idx)[numElems]=(*idx)[i];   // Note that i >= numElems
    	}
    
    // Set resolution to what was defined by parameter r
    for (i=0; i<v.size(); i++) v[i]=r*v[i];

    return v;
}

int Utils::intersect(vector<float> &v1, vector<float> &v2, vector<float> &putHere, float tolerance) {
	return 0;
}

int	Utils::save_tcb(char *filename, vector<TwoValues<float> > data) {
    FILE *fp;   unsigned int numEntries = data.size();
    float curData[2];
    unsigned int i,p;
    
    fp = fopen(filename,"w");
    if (fp==0) { cerr << "ERROR: cannot open " << filename << "\n";   return -1; }
    
    fwrite(&numEntries,sizeof(int),1,fp);  // Number of entries in the file

	for(i=0;i<numEntries;i++) {
		curData[0]=data[i][0];   curData[1]=data[i][1];
		fwrite(curData,sizeof(float),2,fp);
	}

    fclose(fp);
    return 1;
}

int	Utils::save_tcb_list(char *filename, list<TwoValues<float> > data) {
    FILE *fp;   unsigned int numEntries = data.size();
    float curData[2];
    unsigned int i,p;
    
    fp = fopen(filename,"w");
    if (fp==0) { cerr << "ERROR: cannot open " << filename << "\n";   return -1; }

    fwrite(&numEntries,sizeof(int),1,fp);  // Number of entries in the file

	for(list<TwoValues<float> >::iterator iter=data.begin();iter!=data.end();iter++) {
		curData[0]=(*iter)[0];   curData[1]=(*iter)[1];
		fwrite(curData,sizeof(float),2,fp);
	}

    fclose(fp);
    return 1;
}

// Converts a set of values to an indicator boolean vector with true whenever a value is present in values
unsigned int Utils::list_to_vector_bool(vector<float> &values, vector<bool> &output, 
                 float tolerance, float multFactor) {
	unsigned int offset = (int)ceil(-(values[0]-tolerance)*multFactor);
	int tolRange = (int)round(tolerance*multFactor);
	
	output.resize(offset+(int)ceil((values[values.size()-1]+tolerance)*multFactor)+1);  // resize and initialize
	for(unsigned int i=0; i<output.size(); i++) output[i]=false;
	
	for(unsigned int vIdx=0; vIdx<values.size(); vIdx++) {  // Set value positions to true
		int intValue = offset + (int)round(values[vIdx]*multFactor);
		for(int tolOffset=-tolRange; tolOffset<=tolRange; tolOffset++)
			output[intValue+tolOffset]=true;
	}
	return offset;
}

// Computes a table of binomial probabilities for n=1..maxN, k=1..n; probs[i][j]=p(k=j|n=j+1)
void Utils::binomial(unsigned short maxN, float p, vector<vector<float> > &probs) {
	unsigned short n,k,idxN;
	
	probs.resize(maxN);   	if(maxN==0) return;
	for(idxN=0; idxN<maxN; idxN++) probs[idxN].resize(maxN+1);
	
	// Compute the n-choose-k values
	for(idxN=0; idxN<maxN; idxN++) probs[idxN][0]=1;
	for(k=1; k<=maxN; k++)
		for(idxN=0; idxN<maxN; idxN++) {  
			n = idxN+1;   // index=idxN corresponds to n=idxN+1 trials in the binomial distribution
			if(k>n)  { probs[idxN][k]=0; continue; }
			if(k==n) probs[idxN][k]=1;
			else probs[idxN][k]=probs[idxN-1][k]*n/(n-k);
		}

	// Multiply by the p^k * (1-p)^(n-k)
	vector<TwoValues<float> > tmpProbs(maxN+1);  // pos[k] contains ( p^k , (1-p)^k )
	tmpProbs[0].set(1,1);    tmpProbs[1].set(p,1-p);
	for(k=2; k<=maxN; k++) tmpProbs[k].set(p*tmpProbs[k-1][0],(1-p)*tmpProbs[k-1][1]);
	for(k=0; k<=maxN; k++)
		for(idxN=0; idxN<maxN; idxN++) 
			if(k<=idxN+1) probs[idxN][k]*=tmpProbs[k][0]*tmpProbs[idxN+1-k][1];
}

double Utils::gaussiancdf(double x, double mean, double stddev) {

	if(fabs(stddev)<0.000001) return -1;
	x-=mean; x/=stddev;

//  Start code obtained from http://www.sitmo.com/doc/Calculating_the_Cumulative_Normal_Distribution
//	double N(const double x) {
	  const double b1 =  0.319381530;
	  const double b2 = -0.356563782;
	  const double b3 =  1.781477937;
	  const double b4 = -1.821255978;
	  const double b5 =  1.330274429;
	  const double p  =  0.2316419;
	  const double c  =  0.39894228;
	
	  if(x >= 0.0) {
	      double t = 1.0 / ( 1.0 + p * x );
	      return (1.0 - c * exp( -x * x / 2.0 ) * t *
	      ( t *( t * ( t * ( t * b5 + b4 ) + b3 ) + b2 ) + b1 ));
	  }
	  else {
	      double t = 1.0 / ( 1.0 - p * x );
	      return ( c * exp( -x * x / 2.0 ) * t *
	      ( t *( t * ( t * ( t * b5 + b4 ) + b3 ) + b2 ) + b1 ));
	    }
//	}
//  End code obtained from http://www.sitmo.com/doc/Calculating_the_Cumulative_Normal_Distribution
}


// Computes scores[i][j]=log(probsSignal[i][j]/probsNoise[i][j]) for all probsNoise[i][j]>0
void Utils::logscores(vector<vector<float> > &probsSignal, vector<vector<float> > &probsNoise, 
                        vector<vector<float> > &scores) {
	unsigned int i,j;
	if(probsSignal.size()!=probsNoise.size()) 
		{ cerr<<"ERROR in Utils::logscores(): probs vector dimensions do not match!\n"; return; }
	scores.resize(probsSignal.size());
	for(i=0; i<probsSignal.size(); i++)
		if(probsSignal[i].size()!=probsNoise[i].size()) 
			{ cerr<<"ERROR in Utils::logscores(): probs vector dimensions do not match!\n"; scores.resize(0); return; }
		else {
			scores[i].resize(probsSignal[i].size());
			for(j=0; j<probsSignal[i].size(); j++)
				if(probsNoise[i][j]>0) scores[i][j]=log(probsSignal[i][j]/probsNoise[i][j]);
				else scores[i][j]=0;
		}
}

template<class T> void filterValues(vector<T> &values, vector<T> &validValues, T &tolerance, vector<T> &finalValues){
	finalValues.resize(values.size());
	unsigned idxVal=0, idxValid, idxF=0;
	while(idxVal<values.size() and idxValid<validValues.size()) {
		if(fabs(values[idxVal]-validValues[idxValid])<=tolerance+0.0001) { finalValues[idxF++]=values[idxVal++]; continue; }
		if(values[idxVal]<validValues[idxValid]) idxVal++; else idxValid++;
	}
	finalValues.resize(idxF);
}
