#ifndef UTILS_H
#define UTILS_H

#include "twovalues.h"

#include <vector>
#include <list>
using namespace std;

class Utils {
public:

    static vector<float> &unique(vector<float> &v, float resolution, vector<unsigned int> *idx=0);

	// Intersects two sorted sets of masses
	static int intersect(vector<float> &v1, vector<float> &v2, vector<float> &putHere, float tolerance);
	
	// Saves a set of pairs of floats to binary file
	//   Format: 1 int with number of pairs followed by numEntries pairs of floats
	static int save_tcb(char *filename, vector<TwoValues<float> > data);
	static int save_tcb_list(char *filename, list<TwoValues<float> > data);
	
	// Converts a set of values to an indicator boolean vector with true whenever a value is present in values
	static unsigned int list_to_vector_bool(vector<float> &values, vector<bool> &output, float tolerance, float multFactor);
	
	// Computes a table of binomial probabilities for n=1..maxN, k=1..n; probs[i][j]=p(k=j|n=j+1)
	static void binomial(unsigned short maxN, float p, vector<vector<float> > &probs);

	// Computes the Gaussian P(X<=x)
	static double gaussiancdf(double x, double mean=0.0, double stddev=1.0);

	// Computes scores[i][j]=log(probsSignal[i][j]/probsNoise[i][j]) for all probsNoise[i][j]>0
	static void logscores(vector<vector<float> > &probsSignal, vector<vector<float> > &probsNoise, 
	                        vector<vector<float> > &scores);
	
};

// Filter values from the input argument values - keep only those within tolerance of some entry in validValues
//   NOTE: Assumes that both values and validValues are sorted in increasing order
template<class T> void filterValues(vector<T> &values, vector<T> &validValues, T &tolerance);

#endif
