#ifndef __PEPTIDE_SPECTRUM_SCORE_H
#define __PEPTIDE_SPECTRUM_SCORE_H
#include "util.h"
#include "src/PepNovo/AnnotatedSpectrum_add.h"
#include "src/PepNovo/FastaDB.h"
#include <vector>
using namespace std;

class PvalModel {
	public:
	PvalModel() {enforce_cys_flag = false; enforce_mass_flag = false;}
	Config *config;
	int score;
	float norm_score;
	float mean_val;
	float std_val;
	bool enforce_cys_flag;
	float thresh;
	bool enforce_mass_flag;
	int num_peptide;
	void set_config(Config *conf) {config = conf;}
	void enforce_cys() { enforce_cys_flag = true;}
	void enforce_mass(float thr) { thresh = thr; enforce_mass_flag = true;}
	void set_num_peptide(int np) {num_peptide = np;}
	void set_pval_norm(AnnotatedSpectrumCounter& input_spectrum, PeptideCounter& pep, int max_charge, vector<float> acc_thresh, Offset offset, int do_cyclic, int score_type, bool pval_flag, bool norm_flag);
	PeptideAdd generate_random_peptide(PeptideAdd& pep);
};

class score_pos {
public :
	score_t score;
	float diff;
	int pos;
	bool lin_mod;
};

score_pos peptide_spectrum_score_mod(AnnotatedSpectrumCounter& input_spectrum, Non_Linear_Peptide& peptide, int max_charge, vector<float> acc_thresh, Offset offset, int do_cyclic, int score_type);

float peptide_spectrum_score_pvalue_mod(AnnotatedSpectrumCounter& input_spectrum, Non_Linear_Peptide& peptide, int max_charge, vector<float> acc_thresh, Offset offset, int do_cyclic, int score_type, int num_rand);

score_t peptide_spectrum_score(AnnotatedSpectrumCounter& input_spectrum, Non_Linear_Peptide& peptide, int max_charge, vector<float> acc_thresh, Offset offset, int do_cyclic, int score_type);
score_t peptide_spectrum_score(AnnotatedSpectrumCounter& input_spectrum, PeptideAdd& peptide, int max_charge, vector<float> acc_thresh, Offset offset, int do_cyclic, int score_type);
float peptide_spectrum_score_pvalue(AnnotatedSpectrumCounter& input_spectrum, Non_Linear_Peptide& peptide, int max_charge, vector<float> acc_thresh, Offset offset, int do_cyclic, int score_type, int num_rand);
float peptide_spectrum_score_pvalue(AnnotatedSpectrumCounter& input_spectrum, PeptideAdd& peptide, int max_charge, vector<float> acc_thresh, Offset offset, int do_cyclic, int score_type, int num_rand);

void convert_int(Non_Linear_Peptide& peptide, Non_Linear_Peptide& peptide_int);
void convert_int(AnnotatedSpectrumCounter& input_spectrum, AnnotatedSpectrumCounter& input_spectrum_int);

#endif
