#ifndef __ANNOTATED_SPECTRUM_ADD_H__
#define __ANNOTATED_SPECTRUM_ADD_H__


#include "Config.h"
#include "PeakList.h"
#include "SpectraAggregator.h"
#include "AnnotatedSpectrum.h"


class BinnedSpectrum {
  public:
  vector< vector<bool> > bin;
  float bin_width;
  vector<float> thresh_vec;
  float max_thresh;
  int length;
  int offset;
};

class AnnotatedSpectrumAdd : public AnnotatedSpectrum {
public:
  int getNumPeaks() const;
  float getPeakMass(int index) const;
  float getPeakIntensity(int index) const;
  Peak const& getPeak(int index) const;
  bool vector_peak_flag;
  vector<Peak> peaks_vector;
  SingleSpectrumHeader head;
  AnnotatedSpectrumAdd();
  int global_scan_index;
  int original_scan_index;
  int scan_index;
  void de_isotope(vector<float> de_isotope_vec, vector<float> de_isotope_thresh);
  void set_scale_factor(float sf) {scale_factor = sf;}
  void initializeSpectrum(bool indFilterSpectrum);
  void initialize_binned_spectrum(float bw, vector<float> threshold_vector);
  void do_spectral_filter();
  void print();
  void print(string out_file);
  void set_org_pm(float pm) {originalPm_ = pm;}
  float get_org_pm() const {return originalPm_;}
  void generate_random_spectrum(float mass, int len);
  void set_filter_type(int fil_typ) {filter_type = fil_typ;}
  void set_spectrum_length(int spec_len) {spectrum_length = spec_len;}
  void set_filter_step(float fil_step) {filter_step = fil_step;}
  void set_filter_peak_num(int peak_num) {filter_peak_num = peak_num;}
  bool readSpectrum(const SpectraAggregator& sa,	
  const SingleSpectrumHeader* header, 
  bool filterSpectrum = true);
  void merge(AnnotatedSpectrumAdd s_first, AnnotatedSpectrumAdd s_second);
  BinnedSpectrum binned_spectrum;
  void initialize_integer_spectrum();
  void operator= (const AnnotatedSpectrumAdd& other);

protected:
	mass_t  originalPm_;
  float scale_factor;
	int filter_type; // Default : PepNovo
	int spectrum_length; // Default : No limit
	int filter_step; // 5.0 Da
	int filter_peak_num;
  vector<int> integer_spectrum;
};

bool ComparePeakByMass(Peak peak_1, Peak peak_2);
bool ComparePeakByIntensity(Peak peak_1, Peak peak_2);

#endif
