#include "BasicDataStructs_add.h"
#include "auxfun.h"
#include "FastaDB.h"

void PeptideAdd::generate_random_peptide(const Config *config, int peptide_length, int complete_initialization)
{
  Peptide::generate_random_peptide(config, peptide_length);
  set_peptide_aas(config, get_amino_acids(), complete_initialization);
  mass_add = Peptide::get_mass();
}

void PeptideAdd::parseFromString(Config* config, string pep_str, int complete_initialization) {
  Peptide::parseFromString(config, pep_str);
  set_peptide_aas(config, get_amino_acids(), complete_initialization);
}

int PeptideAdd::check_if_valid(const vector<int>& aas){
for(int ind=0; ind<aas.size(); ind++) {
    if((aas[ind]<Ala) || (aas[ind]>Val))
	return 0;
}
return 1;
}

int PeptideAdd::check_if_valid(){
for(int ind=0; ind<get_amino_acids().size(); ind++) {
    if((get_amino_acids()[ind]<Ala) || (get_amino_acids()[ind]>Val))
	return 0;
}
return 1;
}

int PeptideAdd::set_peptide_aas(const Config* config, const vector<int>& aas, int complete_initialization){
    
    // cout << "comp_init lev 4: " << complete_initialization << endl;
    // cout << "check if valid: " << check_if_valid(aas) << endl;
    // cout  << complete_initialization << endl;
    // cout << "aas size: " << aas.size() << endl;
    if(check_if_valid(aas) == 0) {
      cout << "check if valid :: peptide invalid " << endl;
	    // for(int index = 0; index < aas.size(); index++)
		  //  cout << aas[index] << " ";
	    // cout << endl;
      return 0; 
    } else {
	Peptide::set_peptide_aas(aas);
	if(complete_initialization == 1) { // initialize everything
	    const vector<char>& aa2char = config->get_aa2char();
    	const vector<mass_t>& aa2mass = config->get_aa2mass();
	    amino_acid_masses.clear();
	    amino_acid_offsets.clear();
      string peptideStr;
      peptideStr.clear();
	    mass_add = 0;
	    offset_sum = 0;
	    for(int ind = 0; ind<aas.size(); ind++){
                amino_acid_masses.push_back(aa2mass[get_amino_acids()[ind]]);
                amino_acid_offsets.push_back(0);
                mass_add += aa2mass[get_amino_acids()[ind]];
                peptideStr.push_back(aa2char[get_amino_acids()[ind]]);
            }
      setPeptideStr(peptideStr);
	    // cout << "Here 0 " << peptideStr_.size() << endl;
        }
	if(complete_initialization == 2) { // just initialize the mass
	    const vector<char>& aa2char = config->get_aa2char();
	    const vector<mass_t>& aa2mass = config->get_aa2mass();
	    mass_add = 0;
	    for(int ind = 0; ind<aas.size(); ind++){
    	        mass_add += aa2mass[get_amino_acids()[ind]];
            }
        }
        return 1;
    } 
}
