#ifndef __BASICDATASTRUCTS_ADD_H__
#define __BASICDATASTRUCTS_ADD_H__

#include "Config.h"
#include "BasicDataStructs.h"

class PeptideAdd : public Peptide {
public:
  PeptideAdd() : offset_sum(0) {};

	void clear() { mass_add=0; offset_sum=0; amino_acid_masses.clear(); amino_acid_offsets.clear(); Peptide::clear();}

  void generate_random_peptide(const Config *config, int peptide_length, int complete_intialization = 1);
  void add_offset(int index, mass_t off_mass) {
    amino_acid_offsets[index] = off_mass; 
    amino_acid_masses[index] = amino_acid_masses[index] + off_mass;
    offset_sum = offset_sum + off_mass;
    mass_add = mass_add + off_mass;
  }


  const vector<mass_t>& get_amino_acid_masses() const { return amino_acid_masses; }

	const vector<mass_t>& get_amino_acid_offsets() const { return amino_acid_offsets; }

	// void set_peptide(Peptide& pep) {(*this) = pep;}

	void set_mass(float m) {mass_add = m;}
  float get_mass() const {return mass_add;}
	int set_peptide_aas(const Config* config, const vector<int>& aas, int complete_initialization = 0);
  void parseFromString(Config* config, string pep_str, int complete_initialization = 0);

	int check_if_valid(const vector<int>& aas);
	
	int check_if_valid();
	

private:
  mass_t mass_add;
	mass_t offset_sum;
  vector<mass_t> amino_acid_masses;
  vector<mass_t> amino_acid_offsets;
	
};

#endif

