#ifndef __STRONGFRAGMENTMODEL_H__
#define __STRONGFRAGMENTMODEL_H__

#include "FragmentModel.h"


// model for strong fragment with intensity
typedef enum ScoreModelFields_SI {

	SI_CONST,                          
	
	SI_IND_MIRROR1_VIZ,			SI_IND_MIRROR1_NOT_VIZ,
	SI_IND_HAS_MIRROR1_INTEN,   SI_MIRROR1_ISO_LEVEL,
	SI_IND_MIRROR1_HAS_MINUS_1,	SI_MIRROR1_MINUS_1_INTEN_DIFF, // with mirror
	SI_IND_MIRROR1_HAS_MINUS_2, SI_MIRROR1_MINUS_2_INTEN_DIFF,
	SI_IND_MIRROR1_HAS_PLUS_1,	SI_MIRROR1_PLUS_1_INTEN_DIFF,
	SI_IND_MIRROR1_HAS_PLUS_2,	SI_MIRROR1_PLUS_2_INTEN_DIFF,
	SI_MIRROR1_MASS_DIFF25,     SI_MIRROR1_MASS_DIFF75,		SI_MIRROR1_MASS_DIFF_LARGE,

	SI_IND_MIRROR2_VIZ,			SI_IND_MIRROR2_NOT_VIZ,
	SI_IND_HAS_MIRROR2_INTEN,	SI_MIRROR2_ISO_LEVEL, 
	SI_IND_MIRROR2_HAS_MINUS_1,	SI_MIRROR2_MINUS_1_INTEN_DIFF,
	SI_IND_MIRROR2_HAS_MINUS_2, SI_MIRROR2_MINUS_2_INTEN_DIFF,
	SI_IND_MIRROR2_HAS_PLUS_1,	SI_MIRROR2_PLUS_1_INTEN_DIFF,
	SI_IND_MIRROR2_HAS_PLUS_2,	SI_MIRROR2_PLUS_2_INTEN_DIFF,
	SI_MIRROR2_MASS_DIFF25,		SI_MIRROR2_MASS_DIFF75,		SI_MIRROR2_MASS_DIFF_LARGE,

	SI_IND_PARENT1_VIZ, SI_IND_PARENT1_NOT_VIZ,	SI_IND_PARENT1_NO_INTEN,	
	SI_PARENT1_ISO_LEVEL,
	SI_IND_PARENT1_LESS_THAN_100_MIN_MAX, SI_IND_PARENT1_LESS_THAN_200_MIN_MAX,   
	SI_IND_PARENT1_INTEN_MORE, SI_PARENT1_INTEN_DIFF_MORE,
	SI_IND_PARENT1_INTEN_LESS, SI_PARENT1_INTEN_DIFF_LESS,
	
	SI_IND_PARENT2_VIZ, SI_IND_PARENT2_NOT_VIZ,	SI_IND_PARENT2_NO_INTEN,	
	SI_PARENT2_ISO_LEVEL,
	SI_IND_PARENT2_LESS_THAN_100_MIN_MAX, SI_IND_PARENT2_LESS_THAN_200_MIN_MAX,   
	SI_IND_PARENT2_INTEN_MORE, SI_PARENT2_INTEN_DIFF_MORE,
	SI_IND_PARENT2_INTEN_LESS, SI_PARENT2_INTEN_DIFF_LESS,
	
	SI_LOG_LOCAL_RANK,		 SI_LOG_GLOBAL_RANK,  SI_ISO_LEVEL,
	SI_IND_HAS_MINUS_1,		 SI_IND_HAS_MINUS_2,
	SI_IND_HAS_PLUS_1,		 SI_IND_HAS_PLUS_2,
	
	SI_IND_LOG_INTEN_LESS1,  SI_LOG_INTEN_LESS1,
	SI_IND_LOG_INTEN_LESS2,  SI_LOG_INTEN_LESS2,
	SI_IND_LOG_INTEN_LESS3,  SI_LOG_INTEN_LESS3,
	SI_IND_LOG_INTEN_LESS4,  SI_LOG_INTEN_LESS4,
	SI_IND_LOG_INTEN_MORE,   SI_LOG_INTEN_MORE,

	SI_IND_DIS_FROM_MINMAX_LESS_50,		SI_DIS_FROM_MINMAX0,	SI_LOG_INTEN_DIS_50,
	SI_IND_DIS_FROM_MINMAX_LESS_150,	SI_DIS_FROM_MINMAX50,	SI_LOG_INTEN_DIS_150,
	SI_IND_DIS_FROM_MINMAX_LESS_250,	SI_DIS_FROM_MINMAX150,	SI_LOG_INTEN_DIS_250,
	SI_IND_DIS_FROM_MINMAX_MORE,		SI_DIS_FROM_MINMAX250,	SI_LOG_INTEN_DIS_MORE,

	SI_REL_POS0, SI_REL_POS1, SI_REL_POS2, SI_REL_POS3, SI_REL_POS4,
	SI_REL_POS5, SI_REL_POS6, SI_REL_POS7, SI_REL_POS8, SI_REL_POS9,

	// check for forward offsets from this frag 
	SI_IND_HAS_PLUS_NH3,	SI_PLUS_NH3_INTEN_DIFF,
	SI_IND_HAS_PLUS_H2O,	SI_PLUS_H2O_INTEN_DIFF,
	SI_IND_HAS_PLUS_CO,		SI_PLUS_CO_INTEN_DIFF,
	SI_IND_HAS_PLUS_H2ONH3,	SI_PLUS_H2ONH3_INTEN_DIFF,
	SI_IND_HAS_PLUS_H2OH2O,	SI_PLUS_H2OH2O_INTEN_DIFF,

	SI_IND_HAS_CHARGE_PLUS1,	SI_CHARGE_PLUS1_INTEN_DIFF,
	SI_IND_HAS_CHARGE_MINUS1,	SI_CHARGE_MINUS1_INTEN_DIFF,

	// variable aa features disntiguish between single aa edge and multiple aa edge

	SI_IND_N_IS_GAP,	SI_IND_C_IS_GAP,

	SI_N_TERM_CAT20, SI_N_TERM_CAT18, SI_N_TERM_CAT12, SI_N_TERM_CAT8, SI_N_TERM_CAT4, SI_N_TERM_CAT2,
	SI_N_EDGE_CAT20, SI_N_EDGE_CAT18, SI_N_EDGE_CAT12, SI_N_EDGE_CAT8, SI_N_EDGE_CAT4, SI_N_EDGE_CAT2,
	SI_C_TERM_CAT20, SI_C_TERM_CAT18, SI_C_TERM_CAT12, SI_C_TERM_CAT8, SI_C_TERM_CAT4, SI_C_TERM_CAT2,
	SI_C_EDGE_CAT20, SI_C_EDGE_CAT18, SI_C_EDGE_CAT12, SI_C_EDGE_CAT8, SI_C_EDGE_CAT4, SI_C_EDGE_CAT2,
	SI_SPAN_CAT20,	 SI_SPAN_CAT18,   SI_SPAN_CAT12,   SI_SPAN_CAT8,   SI_SPAN_CAT4,   SI_SPAN_CAT2,
	SI_ND_SPAN_CAT20, SI_ND_SPAN_CAT18, SI_ND_SPAN_CAT12, SI_ND_SPAN_CAT8, SI_ND_SPAN_CAT4, SI_ND_SPAN_CAT2,
	SI_CD_SPAN_CAT20, SI_CD_SPAN_CAT18, SI_CD_SPAN_CAT12, SI_CD_SPAN_CAT8, SI_CD_SPAN_CAT4, SI_CD_SPAN_CAT2,

	SI_IND_CONNECTS_TO_N_TERM, SI_IND_PREFERRED_DIGEST_AA_N_TERM, SI_PREFERRED_DIGEST_AA_N_TERM_INTEN, SI_NON_PREFERRED_DIGEST_AA_N_TERM_INTEN,
	SI_IND_CONNECTS_TO_C_TERM, SI_IND_PREFERRED_DIGEST_AA_C_TERM, SI_PREFERRED_DIGEST_AA_C_TERM_INTEN, SI_NON_PREFERRED_DIGEST_AA_C_TERM_INTEN,

	SI_IND_NOT_CONNECTED_TO_TERMS,   SI_IND_MISSED_CLEAVAGE,

	SI_IND_N_FRAG_NOT_VIZ,			 SI_IND_C_FRAG_NOT_VIZ,
	SI_IND_N_INTEN,					 SI_IND_C_INTEN,
	SI_IND_N_NO_INTEN,				 SI_IND_C_NO_INTEN,

	// N-term features
	SI_IND_N_N_TERM, SI_IND_N_C_TERM, SI_IND_N_Gap, SI_IND_N_Xle, SI_IND_N_Ala, SI_IND_N_Arg, SI_IND_N_Asn,
	SI_IND_N_Asp,    SI_IND_N_Cys,    SI_IND_N_Gln, SI_IND_N_Glu, SI_IND_N_Gly, SI_IND_N_His, SI_IND_N_Ile,
	SI_IND_N_Leu,    SI_IND_N_Lys,    SI_IND_N_Met, SI_IND_N_Phe, SI_IND_N_Pro, SI_IND_N_Ser, SI_IND_N_Thr,
	SI_IND_N_Trp,    SI_IND_N_Tyr,    SI_IND_N_Val,

	// self inten
	SI_IND_N_N_TERM_INTEN, SI_IND_N_C_TERM_INTEN, SI_IND_N_Gap_INTEN, SI_IND_N_Xle_INTEN, SI_IND_N_Ala_INTEN, SI_IND_N_Arg_INTEN, SI_IND_N_Asn_INTEN,
	SI_IND_N_Asp_INTEN,    SI_IND_N_Cys_INTEN,    SI_IND_N_Gln_INTEN, SI_IND_N_Glu_INTEN, SI_IND_N_Gly_INTEN, SI_IND_N_His_INTEN, SI_IND_N_Ile_INTEN,
	SI_IND_N_Leu_INTEN,    SI_IND_N_Lys_INTEN,    SI_IND_N_Met_INTEN, SI_IND_N_Phe_INTEN, SI_IND_N_Pro_INTEN, SI_IND_N_Ser_INTEN, SI_IND_N_Thr_INTEN,
	SI_IND_N_Trp_INTEN,    SI_IND_N_Tyr_INTEN,    SI_IND_N_Val_INTEN,

	// The following are only filled if the N are in the visible range
	SI_IND_N_SE, 

	SI_SE_IND_HAS_N_FRAG_INTEN, 
	SI_SE_IND_N_DIS_FROM_MINMAX_LESS_50_WINTEN, SI_SE_IND_N_DIS_FROM_MINMAX_LESS_150_WINTEN, SI_SE_IND_N_DIS_FROM_MINMAX_LESS_250_WINTEN,
	SI_SE_IND_N_FRAG_DIFF_01,  SI_SE_IND_N_FRAG_DIFF_05,  SI_SE_IND_N_FRAG_DIFF_LARGE,

	SI_SE_IND_N_N_TERM_DIFF_INTEN, SI_SE_IND_N_C_TERM_DIFF_INTEN, SI_SE_IND_N_Gap_DIFF_INTEN, SI_SE_IND_N_Xle_DIFF_INTEN, SI_SE_IND_N_Ala_DIFF_INTEN, SI_SE_IND_N_Arg_DIFF_INTEN, SI_SE_IND_N_Asn_DIFF_INTEN,
	SI_SE_IND_N_Asp_DIFF_INTEN,    SI_SE_IND_N_Cys_DIFF_INTEN,    SI_SE_IND_N_Gln_DIFF_INTEN, SI_SE_IND_N_Glu_DIFF_INTEN, SI_SE_IND_N_Gly_DIFF_INTEN, SI_SE_IND_N_His_DIFF_INTEN, SI_SE_IND_N_Ile_DIFF_INTEN,
	SI_SE_IND_N_Leu_DIFF_INTEN,    SI_SE_IND_N_Lys_DIFF_INTEN,    SI_SE_IND_N_Met_DIFF_INTEN, SI_SE_IND_N_Phe_DIFF_INTEN, SI_SE_IND_N_Pro_DIFF_INTEN, SI_SE_IND_N_Ser_DIFF_INTEN, SI_SE_IND_N_Thr_DIFF_INTEN,
	SI_SE_IND_N_Trp_DIFF_INTEN,    SI_SE_IND_N_Tyr_DIFF_INTEN,    SI_SE_IND_N_Val_DIFF_INTEN,

	SI_SE_IND_HAS_NO_N_FRAG_INTEN,
	SI_SE_IND_N_DIS_FROM_MINMAX_LESS_50_NOINTEN, SI_SE_IND_N_DIS_FROM_MINMAX_LESS_150_NOINTEN, SI_SE_IND_N_DIS_FROM_MINMAX_LESS_250_NOINTEN,

	SI_IND_N_ME, 
	SI_ME_IND_HAS_N_FRAG_INTEN, 
	SI_ME_IND_N_DIS_FROM_MINMAX_LESS_50_WINTEN, SI_ME_IND_N_DIS_FROM_MINMAX_LESS_150_WINTEN, SI_ME_IND_N_DIS_FROM_MINMAX_LESS_250_WINTEN,
	SI_ME_IND_N_FRAG_DIFF_01,  SI_ME_IND_N_FRAG_DIFF_05,  SI_ME_IND_N_FRAG_DIFF_LARGE,

	SI_ME_IND_HAS_NO_N_FRAG_INTEN,
	SI_ME_IND_N_DIS_FROM_MINMAX_LESS_50_NOINTEN, SI_ME_IND_N_DIS_FROM_MINMAX_LESS_150_NOINTEN, SI_ME_IND_N_DIS_FROM_MINMAX_LESS_250_NOINTEN,

	// C-term features

	SI_IND_C_N_TERM, SI_IND_C_C_TERM, SI_IND_C_Gap, SI_IND_C_Xle, SI_IND_C_Ala, SI_IND_C_Arg, SI_IND_C_Asn,
	SI_IND_C_Asp,    SI_IND_C_Cys,    SI_IND_C_Gln, SI_IND_C_Glu, SI_IND_C_Gly, SI_IND_C_His, SI_IND_C_Ile,
	SI_IND_C_Leu,    SI_IND_C_Lys,    SI_IND_C_Met, SI_IND_C_Phe, SI_IND_C_Pro, SI_IND_C_Ser, SI_IND_C_Thr,
	SI_IND_C_Trp,    SI_IND_C_Tyr,    SI_IND_C_Val,

	// self inten
	SI_IND_C_N_TERM_INTEN, SI_IND_C_C_TERM_INTEN, SI_IND_C_Gap_INTEN, SI_IND_C_Xle_INTEN, SI_IND_C_Ala_INTEN, SI_IND_C_Arg_INTEN, SI_IND_C_Asn_INTEN,
	SI_IND_C_Asp_INTEN,    SI_IND_C_Cys_INTEN,    SI_IND_C_Gln_INTEN, SI_IND_C_Glu_INTEN, SI_IND_C_Gly_INTEN, SI_IND_C_His_INTEN, SI_IND_C_Ile_INTEN,
	SI_IND_C_Leu_INTEN,    SI_IND_C_Lys_INTEN,    SI_IND_C_Met_INTEN, SI_IND_C_Phe_INTEN, SI_IND_C_Pro_INTEN, SI_IND_C_Ser_INTEN, SI_IND_C_Thr_INTEN,
	SI_IND_C_Trp_INTEN,    SI_IND_C_Tyr_INTEN,    SI_IND_C_Val_INTEN,

	// The following are only filled if the C are in the visible range
	SI_IND_C_SE, 

	SI_SE_IND_HAS_C_FRAG_INTEN, 
	SI_SE_IND_C_DIS_FROM_MINMAX_LESS_50_WINTEN, SI_SE_IND_C_DIS_FROM_MINMAX_LESS_150_WINTEN, SI_SE_IND_C_DIS_FROM_MINMAX_LESS_250_WINTEN,
	SI_SE_IND_C_FRAG_DIFF_01,  SI_SE_IND_C_FRAG_DIFF_05,  SI_SE_IND_C_FRAG_DIFF_LARGE,

	SI_SE_IND_C_N_TERM_DIFF_INTEN, SI_SE_IND_C_C_TERM_DIFF_INTEN, SI_SE_IND_C_Gap_DIFF_INTEN, SI_SE_IND_C_Xle_DIFF_INTEN, SI_SE_IND_C_Ala_DIFF_INTEN, SI_SE_IND_C_Arg_DIFF_INTEN, SI_SE_IND_C_Asn_DIFF_INTEN,
	SI_SE_IND_C_Asp_DIFF_INTEN,    SI_SE_IND_C_Cys_DIFF_INTEN,    SI_SE_IND_C_Gln_DIFF_INTEN, SI_SE_IND_C_Glu_DIFF_INTEN, SI_SE_IND_C_Gly_DIFF_INTEN, SI_SE_IND_C_His_DIFF_INTEN, SI_SE_IND_C_Ile_DIFF_INTEN,
	SI_SE_IND_C_Leu_DIFF_INTEN,    SI_SE_IND_C_Lys_DIFF_INTEN,    SI_SE_IND_C_Met_DIFF_INTEN, SI_SE_IND_C_Phe_DIFF_INTEN, SI_SE_IND_C_Pro_DIFF_INTEN, SI_SE_IND_C_Ser_DIFF_INTEN, SI_SE_IND_C_Thr_DIFF_INTEN,
	SI_SE_IND_C_Trp_DIFF_INTEN,    SI_SE_IND_C_Tyr_DIFF_INTEN,    SI_SE_IND_C_Val_DIFF_INTEN,

	SI_SE_IND_HAS_NO_C_FRAG_INTEN,
	SI_SE_IND_C_DIS_FROM_MINMAX_LESS_50_NOINTEN, SI_SE_IND_C_DIS_FROM_MINMAX_LESS_150_NOINTEN, SI_SE_IND_C_DIS_FROM_MINMAX_LESS_250_NOINTEN,

	SI_IND_C_ME, 
	SI_ME_IND_HAS_C_FRAG_INTEN, 
	SI_ME_IND_C_DIS_FROM_MINMAX_LESS_50_WINTEN, SI_ME_IND_C_DIS_FROM_MINMAX_LESS_150_WINTEN, SI_ME_IND_C_DIS_FROM_MINMAX_LESS_250_WINTEN,
	SI_ME_IND_C_FRAG_DIFF_01,  SI_ME_IND_C_FRAG_DIFF_05,  SI_ME_IND_C_FRAG_DIFF_LARGE,

	SI_ME_IND_HAS_NO_C_FRAG_INTEN,
	SI_ME_IND_C_DIS_FROM_MINMAX_LESS_50_NOINTEN, SI_ME_IND_C_DIS_FROM_MINMAX_LESS_150_NOINTEN, SI_ME_IND_C_DIS_FROM_MINMAX_LESS_250_NOINTEN,


	SI_NUM_FEATURES

} ScoreModelFields_SI;


// Strong no intensity
typedef enum ScoreModelFields_SNI {
	SNI_CONST,

	SNI_IND_MIRROR1_VIZ,	SNI_IND_MIRROR1_NOT_VIZ, 
	SNI_IND_HAS_MIRROR1_INTEN,  SNI_IND_MIRROR1_NO_INTEN, SNI_MIRROR1_ISO_LEVEL,
	SNI_IND_MIRROR1_HAS_MINUS_1, SNI_MIRROR1_MINUS_1_INTEN_DIFF, // with mirror
	SNI_IND_MIRROR1_HAS_MINUS_2, SNI_MIRROR1_MINUS_2_INTEN_DIFF,
	SNI_IND_MIRROR1_HAS_PLUS_1,	SNI_MIRROR1_PLUS_1_INTEN_DIFF,
	SNI_IND_MIRROR1_HAS_PLUS_2,	SNI_MIRROR1_PLUS_2_INTEN_DIFF,

	SNI_IND_MIRROR2_VIZ,	SNI_IND_MIRROR2_NOT_VIZ, 
	SNI_IND_HAS_MIRROR2_INTEN,  SNI_IND_MIRROR2_NO_INTEN, SNI_MIRROR2_ISO_LEVEL,
	SNI_IND_MIRROR2_HAS_MINUS_1, SNI_MIRROR2_MINUS_1_INTEN_DIFF, // with mirror
	SNI_IND_MIRROR2_HAS_MINUS_2, SNI_MIRROR2_MINUS_2_INTEN_DIFF,
	SNI_IND_MIRROR2_HAS_PLUS_1,	SNI_MIRROR2_PLUS_1_INTEN_DIFF,
	SNI_IND_MIRROR2_HAS_PLUS_2,	SNI_MIRROR2_PLUS_2_INTEN_DIFF,

	SNI_IND_PARENT1_VIZ,	SNI_IND_PARENT1_NOT_VIZ, 
	SNI_IND_PARENT1_INTEN,  SNI_IND_PARENT1_NO_INTEN, SNI_PARENT1_ISO_LEVEL,
	SNI_PARENT1_LOG_INTEN,	SNI_PARENT1_LOG_GLOBAL_RANK,

	SNI_IND_PARENT2_VIZ,	SNI_IND_PARENT2_NOT_VIZ, 
	SNI_IND_PARENT2_INTEN,  SNI_IND_PARENT2_NO_INTEN, SNI_PARENT2_ISO_LEVEL,
	SNI_PARENT2_LOG_INTEN,	SNI_PARENT2_LOG_GLOBAL_RANK,

	SNI_IND_DIS_FROM_MINMAX_LESS_50,	SNI_DIS_FROM_MINMAX0,
	SNI_IND_DIS_FROM_MINMAX_LESS_150,	SNI_DIS_FROM_MINMAX50,
	SNI_IND_DIS_FROM_MINMAX_LESS_250,	SNI_DIS_FROM_MINMAX150,
	SNI_IND_DIS_FROM_MINMAX_MORE,		SNI_DIS_FROM_MINMAX250,

	SNI_REL_POS0, SNI_REL_POS1, SNI_REL_POS2, SNI_REL_POS3, SNI_REL_POS4,
	SNI_REL_POS5, SNI_REL_POS6, SNI_REL_POS7, SNI_REL_POS8, SNI_REL_POS9,

	SNI_IND_N_IS_GAP,	SNI_IND_C_IS_GAP,

	SNI_N_TERM_CAT20, SNI_N_TERM_CAT18,	SNI_N_TERM_CAT12, SNI_N_TERM_CAT8, SNI_N_TERM_CAT4, SNI_N_TERM_CAT2,
	SNI_N_EDGE_CAT20, SNI_N_EDGE_CAT18, SNI_N_EDGE_CAT12, SNI_N_EDGE_CAT8, SNI_N_EDGE_CAT4, SNI_N_EDGE_CAT2,
	SNI_C_TERM_CAT20, SNI_C_TERM_CAT18, SNI_C_TERM_CAT12, SNI_C_TERM_CAT8, SNI_C_TERM_CAT4, SNI_C_TERM_CAT2,
	SNI_C_EDGE_CAT20, SNI_C_EDGE_CAT18, SNI_C_EDGE_CAT12, SNI_C_EDGE_CAT8, SNI_C_EDGE_CAT4, SNI_C_EDGE_CAT2,
	SNI_SPAN_CAT20,	  SNI_SPAN_CAT18,   SNI_SPAN_CAT12,   SNI_SPAN_CAT8,   SNI_SPAN_CAT4,   SNI_SPAN_CAT2,
	SNI_ND_SPAN_CAT20, SNI_ND_SPAN_CAT18, SNI_ND_SPAN_CAT12, SNI_ND_SPAN_CAT8, SNI_ND_SPAN_CAT4, SNI_ND_SPAN_CAT2,
	SNI_CD_SPAN_CAT20, SNI_CD_SPAN_CAT18, SNI_CD_SPAN_CAT12, SNI_CD_SPAN_CAT8, SNI_CD_SPAN_CAT4, SNI_CD_SPAN_CAT2,


	SNI_IND_CONNECTS_TO_N_TERM,			SNI_IND_CONNECTS_TO_C_TERM,
	SNI_IND_PREFERRED_DIGEST_AA_C_TERM, SNI_IND_PREFERRED_DIGEST_AA_N_TERM,
	SNI_IND_NOT_CONNECTED_TO_TERMS,     SNI_IND_MISSED_CLEAVAGE, 


	SNI_IND_N_NOT_VIZ,	SNI_IND_C_NOT_VIZ,
	SNI_IND_N_INTEN,	SNI_IND_N_NO_INTEN,
	SNI_IND_C_INTEN,	SNI_IND_C_NO_INTEN,

	// For N-terminal

	SNI_IND_N_N_TERM, SNI_IND_N_C_TERM, SNI_IND_N_Gap, SNI_IND_N_Xle, SNI_IND_N_Ala, SNI_IND_N_Arg, SNI_IND_N_Asn,
	SNI_IND_N_Asp,    SNI_IND_N_Cys,    SNI_IND_N_Gln, SNI_IND_N_Glu, SNI_IND_N_Gly, SNI_IND_N_His, SNI_IND_N_Ile,
	SNI_IND_N_Leu,    SNI_IND_N_Lys,    SNI_IND_N_Met, SNI_IND_N_Phe, SNI_IND_N_Pro, SNI_IND_N_Ser, SNI_IND_N_Thr,
	SNI_IND_N_Trp,    SNI_IND_N_Tyr,    SNI_IND_N_Val,

	// The following are only filled if the N are in the visible range
	SNI_IND_N_SE, 

	SNI_SE_IND_HAS_N_FRAG_INTEN, 
	SNI_SE_IND_N_DIS_FROM_MINMAX_LESS_50_WINTEN, SNI_SE_IND_N_DIS_FROM_MINMAX_LESS_150_WINTEN, SNI_SE_IND_N_DIS_FROM_MINMAX_LESS_250_WINTEN,

	SNI_SE_IND_N_N_TERM_DIFF_INTEN, SNI_SE_IND_N_C_TERM_DIFF_INTEN, SNI_SE_IND_N_Gap_DIFF_INTEN, SNI_SE_IND_N_Xle_DIFF_INTEN, SNI_SE_IND_N_Ala_DIFF_INTEN, SNI_SE_IND_N_Arg_DIFF_INTEN, SNI_SE_IND_N_Asn_DIFF_INTEN,
	SNI_SE_IND_N_Asp_DIFF_INTEN,    SNI_SE_IND_N_Cys_DIFF_INTEN,    SNI_SE_IND_N_Gln_DIFF_INTEN, SNI_SE_IND_N_Glu_DIFF_INTEN, SNI_SE_IND_N_Gly_DIFF_INTEN, SNI_SE_IND_N_His_DIFF_INTEN, SNI_SE_IND_N_Ile_DIFF_INTEN,
	SNI_SE_IND_N_Leu_DIFF_INTEN,    SNI_SE_IND_N_Lys_DIFF_INTEN,    SNI_SE_IND_N_Met_DIFF_INTEN, SNI_SE_IND_N_Phe_DIFF_INTEN, SNI_SE_IND_N_Pro_DIFF_INTEN, SNI_SE_IND_N_Ser_DIFF_INTEN, SNI_SE_IND_N_Thr_DIFF_INTEN,
	SNI_SE_IND_N_Trp_DIFF_INTEN,    SNI_SE_IND_N_Tyr_DIFF_INTEN,    SNI_SE_IND_N_Val_DIFF_INTEN,

	SNI_SE_IND_HAS_NO_N_FRAG_INTEN,
	SNI_SE_IND_N_DIS_FROM_MINMAX_LESS_50_NOINTEN, SNI_SE_IND_N_DIS_FROM_MINMAX_LESS_150_NOINTEN, SNI_SE_IND_N_DIS_FROM_MINMAX_LESS_250_NOINTEN,

	SNI_IND_N_ME, 
	SNI_ME_IND_HAS_N_FRAG_INTEN, 
	SNI_ME_IND_N_DIS_FROM_MINMAX_LESS_50_WINTEN, SNI_ME_IND_N_DIS_FROM_MINMAX_LESS_150_WINTEN, SNI_ME_IND_N_DIS_FROM_MINMAX_LESS_250_WINTEN,

	SNI_ME_IND_HAS_NO_N_FRAG_INTEN,
	SNI_ME_IND_N_DIS_FROM_MINMAX_LESS_50_NOINTEN, SNI_ME_IND_N_DIS_FROM_MINMAX_LESS_150_NOINTEN, SNI_ME_IND_N_DIS_FROM_MINMAX_LESS_250_NOINTEN,

	// For C-terminal

	SNI_IND_C_N_TERM, SNI_IND_C_C_TERM, SNI_IND_C_Gap, SNI_IND_C_Xle, SNI_IND_C_Ala, SNI_IND_C_Arg, SNI_IND_C_Asn,
	SNI_IND_C_Asp,    SNI_IND_C_Cys,    SNI_IND_C_Gln, SNI_IND_C_Glu, SNI_IND_C_Gly, SNI_IND_C_His, SNI_IND_C_Ile,
	SNI_IND_C_Leu,    SNI_IND_C_Lys,    SNI_IND_C_Met, SNI_IND_C_Phe, SNI_IND_C_Pro, SNI_IND_C_Ser, SNI_IND_C_Thr,
	SNI_IND_C_Trp,    SNI_IND_C_Tyr,    SNI_IND_C_Val,

	// The following are only filled if the N are in the visible range
	SNI_IND_C_SE, 

	SNI_SE_IND_HAS_C_FRAG_INTEN, 
	SNI_SE_IND_C_DIS_FROM_MINMAX_LESS_50_WINTEN, SNI_SE_IND_C_DIS_FROM_MINMAX_LESS_150_WINTEN, SNI_SE_IND_C_DIS_FROM_MINMAX_LESS_250_WINTEN,

	SNI_SE_IND_C_N_TERM_DIFF_INTEN, SNI_SE_IND_C_C_TERM_DIFF_INTEN, SNI_SE_IND_C_Gap_DIFF_INTEN, SNI_SE_IND_C_Xle_DIFF_INTEN, SNI_SE_IND_C_Ala_DIFF_INTEN, SNI_SE_IND_C_Arg_DIFF_INTEN, SNI_SE_IND_C_Asn_DIFF_INTEN,
	SNI_SE_IND_C_Asp_DIFF_INTEN,    SNI_SE_IND_C_Cys_DIFF_INTEN,    SNI_SE_IND_C_Gln_DIFF_INTEN, SNI_SE_IND_C_Glu_DIFF_INTEN, SNI_SE_IND_C_Gly_DIFF_INTEN, SNI_SE_IND_C_His_DIFF_INTEN, SNI_SE_IND_C_Ile_DIFF_INTEN,
	SNI_SE_IND_C_Leu_DIFF_INTEN,    SNI_SE_IND_C_Lys_DIFF_INTEN,    SNI_SE_IND_C_Met_DIFF_INTEN, SNI_SE_IND_C_Phe_DIFF_INTEN, SNI_SE_IND_C_Pro_DIFF_INTEN, SNI_SE_IND_C_Ser_DIFF_INTEN, SNI_SE_IND_C_Thr_DIFF_INTEN,
	SNI_SE_IND_C_Trp_DIFF_INTEN,    SNI_SE_IND_C_Tyr_DIFF_INTEN,    SNI_SE_IND_C_Val_DIFF_INTEN,

	SNI_SE_IND_HAS_NO_C_FRAG_INTEN,
	SNI_SE_IND_C_DIS_FROM_MINMAX_LESS_50_NOINTEN, SNI_SE_IND_C_DIS_FROM_MINMAX_LESS_150_NOINTEN, SNI_SE_IND_C_DIS_FROM_MINMAX_LESS_250_NOINTEN,

	SNI_IND_C_ME, 
	SNI_ME_IND_HAS_C_FRAG_INTEN, 
	SNI_ME_IND_C_DIS_FROM_MINMAX_LESS_50_WINTEN, SNI_ME_IND_C_DIS_FROM_MINMAX_LESS_150_WINTEN, SNI_ME_IND_C_DIS_FROM_MINMAX_LESS_250_WINTEN,

	SNI_ME_IND_HAS_NO_C_FRAG_INTEN,
	SNI_ME_IND_C_DIS_FROM_MINMAX_LESS_50_NOINTEN, SNI_ME_IND_C_DIS_FROM_MINMAX_LESS_150_NOINTEN, SNI_ME_IND_C_DIS_FROM_MINMAX_LESS_250_NOINTEN,


	SNI_NUM_FEATURES

} ScoreModelFields_SNI;




class StrongFragmentModel : public  FragmentModel {
	friend class RegionalPrmNodeScoreModel;
public:
	StrongFragmentModel() :
		mirror1_idx(NEG_INF), mirror2_idx(NEG_INF),
		parent1_idx(NEG_INF), parent2_idx(NEG_INF),
		mirror1_charge(0), mirror2_charge(0), parent1_charge(0), parent2_charge(0) {}


	bool read_model(const Config *config, istream& is, bool silent_ind);

	bool write_model (ostream& os) const;


	void fill_combo_vectors(Spectrum *spec, 
							mass_t pm_with_19,  
							const Breakage *breakage,
							const vector<BreakageInfo>& infos,
							vector< ME_Regression_Sample > & samples) const;

	void fill_single_frag_vector(Spectrum *spec, 
							mass_t pm_with_19,  
							const Breakage *breakage,
							BreakageInfo& info,
							vector< fval >& f_vals) const;


	int get_model_frag_idx() const { return model_frag_idx; }

protected:


	int mirror1_idx,  mirror2_idx;
	int parent1_idx,  parent2_idx;

	int mirror1_charge, mirror2_charge, parent1_charge, parent2_charge;


	void fill_constant_vals(Spectrum *spec, 
							mass_t pm_with_19,  
							const Breakage *breakage, 
							vector<fval>& f_vals) const;

	void fill_aa_variable_vals( Spectrum *spec, 
							   mass_t pm_with_19,  
							   const Breakage *breakage,
							   const BreakageInfo* info,
							   vector<fval>& f_vals) const;
};






#endif

