#ifndef _UTIL_H
#define _UTIL_H

#include <string.h>
#include <algorithm>
#include <sstream>
#include <math.h>
#include <vector>
#include <iostream>
#include <stdlib.h>
#include "src/PepNovo/SpectraFile.h"
#include "src/PepNovo/SpectraAggregator.h"
#include "src/PepNovo/SingleSpectrumHeader.h"
#include "src/PepNovo/SpectraList.h"
#include "src/PepNovo/AnnotatedSpectrum.h"
#include "src/PepNovo/BasicDataStructs_add.h"
#include "src/PepNovo/AnnotatedSpectrum_add.h"
// #include <libxml++/libxml++.h>
// #include "src/PepNovo/FastaDB.h"

 


  
using namespace std;


bool ComparePeptideBySeq(const Peptide& pep_1, const Peptide& pep_2);
bool ComparePeptideBySeqEq(const Peptide& pep_1, const Peptide& pep_2);

void split_peptide(Config* config, PeptideAdd& pep, PeptideAdd& pep_1, PeptideAdd& pep_2, int k);

void write_filtered_spectra(Config* config, string path, vector<string> spectrum_files, vector<vector<int> > scan_ind, string mgf_file);
void write_filtered_spectra_seq_charge(Config* config, string path, vector<string> spectrum_files, vector<vector<int> > scan_ind, vector<vector <string> > seqs, vector<vector<int> > charge, string mgf_file);
bool CompareStr(string s_1, string s_2);
bool CompareStrEq(string s_1, string s_2);
string rev_str(string s);
bool CompareStrBySuffix(string s_1, string s_2);
bool CompareStrByPrefix(string s_1, string s_2);


class IndexedSequence {
	public:
		string seq;
		int index;
};

class SpecPairEq {
  public:
  int scan_ind_first;
  int scan_ind_second;
};

class SpecPairEqVec : public vector<SpecPairEq> {
  public:
  void print(string spec_pair_file);
};

void add_spec_pair_msclust(string path_clust, SpecPairEqVec spec_pair_vec_msclust);

void calculate_equal_spec_pairs(vector<IndexedSequence> seq_vec, SpecPairEqVec& spec_pair_vec);

bool CompareIndexStrBySuffix(IndexedSequence s_1, IndexedSequence s_2);
bool CompareIndexStrByPrefix(IndexedSequence s_1, IndexedSequence s_2);
class SingleResInspect {
	public:
	string spectrum_file;
	int scan_index;
	int rank;
  string peptide;
	char prefix;
	char suffix;
	string protein_name;
	int is_decoy;
	int charge;
	float MQScore;
	int length;
	float totalPRMScore;
	float MedianPRMScore;
	float FractionY;
	float FractionB;
	float Intensity;
	int NTT;
	float Pval;
	float FScore;
	float DeltaScore;
	float DeltaScoreOther;
	int RecordNumber;
	int DBFilePos;
	int SpecFilePos;
	float PrecursorMZ;
	float PrecursorMZError;
	void print();
};

class InspectStat {
	public:
	InspectStat () {
		num_decoy_hits = 0;
	}
	int num_db_hits;
	int num_decoy_hits;
	float fdr;
	vector<int> num_rank;
	vector<int> num_rank_decoy;
};

class ResInspect {
	public:
	vector< vector <SingleResInspect> > all_res;
	vector< SingleResInspect> top_res;
	InspectStat stat;
	int num_top_hits;
	int num_spectra;
	vector<int> rank_correct;
	vector<int> is_top_decoy;
	void set_num_top_hits(int nth) {num_top_hits = nth;}
	void set_num_spectra(int ns) {num_spectra = ns;}
	void calc_stat() {
		stat.num_db_hits = num_spectra - stat.num_decoy_hits;
		stat.fdr = float(stat.num_decoy_hits)/float(stat.num_db_hits);
	}
	void print_stat(int phase = 0);
};


void print_share_stat(ResInspect& res_inspect_1, ResInspect& res_inspect_2, int decoy_flag = 0);
void print_share_stat_decoy(ResInspect& res_inspect_1, ResInspect& res_inspect_2);
void print_share_stat_no_decoy(ResInspect& res_inspect_1, ResInspect& res_inspect_2);



bool is_equal(string s_1, string s_2);
bool is_prefix(string s_1, string s_2);
bool is_suffix(string s_1, string s_2);

struct SpecPair {
	public : 
	int ind_ra;	
	int ind_native;
	float mass_ra;
	float mass_native;
	vector<int> share_peaks;
	int total_share_peaks;
	int num_cys;
	int isotopic_off;
};


class AnnotatedSpectrumCounter: public AnnotatedSpectrumAdd {
	public :
	AnnotatedSpectrumCounter() {
		num_mod = 0;
	}
	int index;
	// AnnotatedSpectrumCounter() {}
	// AnnotatedSpectrumCounter(AnnotatedSpectrum& s) {*this = s;}
	vector<AnnotatedSpectrumAdd*> aux_spec_list;
	vector<Config*> config_list;
	vector<int> aux_index;
	int num_aux_spec;
	int num_mod;
	void set_num_mod(int nm){num_mod = nm;}
	int get_num_mod(){return num_mod;}
};

class AnnotatedSpectrumCounterList : public vector<AnnotatedSpectrumCounter> {
  public:
  void add_native_information(vector<int> scan_set, vector<int> scan_set_native, AnnotatedSpectrumCounterList& spectrum_vector_native, Config* config_native);
  void print_pm_charge();
  void print_pm_charge(string out);
};


void inspect_res_mgf(Config* config, ResInspect res_inspect, string path, string mgf_file, bool seq_charge);
void read_sequence(ResInspect res_inspect, vector<IndexedSequence>& seq_vec);
void read_sequence(vector<AnnotatedSpectrumCounter>& spectrum_vector, vector<IndexedSequence>& seq_vec);

class ResInspectModel {
	public:
	ResInspectModel() {
		calc_top_flag = false;
		calc_stat_flag = false;
		calc_fdr_flag = false;
	}
	bool calc_top_flag;
	bool calc_stat_flag;
	bool calc_fdr_flag;
	void set_calc_top() {calc_top_flag = true;}
	void set_calc_stat() {calc_stat_flag = true;}
	void set_calc_fdr() {calc_fdr_flag = true;}
 	void read_inspect_res(string res_inpect_file, ResInspect& res_inspect, AnnotatedSpectrumCounterList& spectrum_vector);
 	void read_inspect_res(string res_inpect_file, ResInspect& res_inspect);
};

void print_spectrum_vector(vector<AnnotatedSpectrumCounter> sv, bool flag);

void filter_msp(Config* config, string input_file_msp, string output_file_msp, bool select_feasible_mod_num, bool select_feasible_charge, vector<int> feasible_mod_num, vector<int> feasible_charge);

void filter_msp_mgf(Config* config, string input_file_msp, string output_file_mgf, bool select_feasible_mod_num, bool select_feasible_charge, vector<int> feasible_mod_num, vector<int> feasible_charge);



int filter_mgf(Config* config, string input_file_mgf, string output_file_mgf, vector<int> scan_set, int scan_index_start, bool use_spectrum_index);
int filter_mgf_seq_charge(Config* config, string input_file_mgf, string output_file_mgf, vector<int> scan_set, vector<string> seqs, vector<int> charge, int scan_index_start, bool use_spectrum_index);

int write_mgf(string output_file_mgf, AnnotatedSpectrumCounterList& spectrum_vector, vector<int> scan_set, int scan_index_start, bool use_spectrum_index);
int write_mgf_seq_charge(string output_file_mgf, AnnotatedSpectrumCounterList& spectrum_vector, vector<int> scan_set, vector<string> seqs, vector<int> charge, string spectrum_file, int scan_index_start, bool use_spectrum_index);


void read_msp(Config* config, string input_file_msp, AnnotatedSpectrumCounterList& spectrum_vector, int num_top_peaks, bool select_feasible_mod_num, bool select_feasible_charge, vector<int> feasible_mod_num, vector<int> feasible_charge);

void read_msp(Config* config, string input_file_msp, AnnotatedSpectrumCounterList& spectrum_vector, int num_top_peaks);

class ReadSpecModel {
	public:
	ReadSpecModel() {
    bring_only_ms2_flag = false;
    start_scan_flag = false;
    stop_scan_flag = false;
    de_isotope_flag = false;
    use_anal_pm_flag = false;
    de_isotope_val.clear();
    de_isotope_val.push_back(1);
    de_isotope_val.push_back(1/2);
    de_isotope_val.push_back(1/3);
    dit = 0.03;
    de_isotope_thresh.clear();
    de_isotope_thresh.push_back(dit);
    de_isotope_thresh.push_back(dit);
    de_isotope_thresh.push_back(dit);
    acc_thresh.clear();
    acc_thresh.push_back(0.5);
    acc_thresh.push_back(0.5/2);
    acc_thresh.push_back(0.5/3);
    bin_width = 0.01;
    binning_flag = false;
    fixed_charge_vector.clear();
    fix_charge_flag = false;
    fix_mass_flag = false;
    print_flag = false;
    setMinPeakCountFlag = false;
    setMinMsLevelFlag = false;
    filter_type = 0;
    num_top_peaks = -1;
    filter_step = 50.0;
    filter_peak_num = 5;
    num_top_peaks_flag = false;
    filter_step_flag = false;
    filter_peak_num_flag = false;
    log_file_flag = false;
    do_filter = true;
    integer_spectra_flag = false;
	}
  float min_anal_pm, max_anal_pm;
  bool use_anal_pm_flag;
  bool start_scan_flag, stop_scan_flag;
  int start_scan, stop_scan;
  float dit;
  vector<float> de_isotope_val;
  vector<float> de_isotope_thresh;
  
  bool fix_mass_flag;
  float fixed_mass;
  bool fix_charge_flag;
  vector<int> fixed_charge_vector;
  float bin_width;
  vector<float> acc_thresh;
  bool de_isotope_flag;
  bool binning_flag;
  bool print_flag;
  bool setMinPeakCountFlag;
  bool setMinMsLevelFlag;
  int minPeakCount;
  int minMsLevel;
  bool integer_spectra_flag;
  bool do_filter;
  bool bring_only_ms2_flag;
	bool log_file_flag;
	bool num_top_peaks_flag;
	bool filter_step_flag;
	bool filter_peak_num_flag;
	int filter_type;
	int num_top_peaks;
	int filter_step;
	int filter_peak_num;
	string log_file_string;
  
  void bring_only_ms2() {
	bring_only_ms2_flag = true;
  }
  void set_dit(float d) {
    dit = d;
    de_isotope_thresh.clear();
    de_isotope_thresh.push_back(dit);
    de_isotope_thresh.push_back(dit);
    de_isotope_thresh.push_back(dit);
  }
  void set_min_max_anal_pm(float minapm,float  maxapm) {min_anal_pm = minapm; max_anal_pm = maxapm; use_anal_pm_flag = true;}
  void set_de_isotope(float d) {set_dit(d); de_isotope_flag = true;}
  void de_isotope() {de_isotope_flag = true;}
  void set_start_scan(int ss) {start_scan_flag = true; start_scan = ss;}
  void set_stop_scan(int ss) {stop_scan_flag = true; stop_scan = ss;}
  void fix_mass(float m) {fixed_mass = m; fix_mass_flag = true;}
  void fix_charge(int c) {fixed_charge_vector.clear(); fixed_charge_vector.push_back(c); fix_charge_flag = true;}
  void add_charge(int c) {fixed_charge_vector.push_back(c); fix_charge_flag = true;}
  void set_bin_width(float bw) {bin_width = bw;}
  void set_acc_thresh(vector<float> thr) {acc_thresh = thr;}
  void set_binning() {binning_flag = true;}
  void set_print_flag() {print_flag = true;}
  void setMinPeakCount(int mpc) {minPeakCount = mpc; setMinPeakCountFlag = true;}
  void setMinMsLevel(int mml) {minMsLevel = mml; setMinMsLevelFlag = true;}
  void set_integer_spectra_flag() {integer_spectra_flag = true;}
	void set_no_filter() {
		do_filter = false;
	}
	void set_log_file_string(string lfs) {
		log_file_string = lfs;
		log_file_flag = true;
	}
	void set_filter_type(int ft) {
		filter_type = ft;
	}
	void set_filter_step(float fs) {
		filter_step = fs;
		filter_step_flag = true;
	}
	void set_filter_peak_num(int fpn) {
		filter_peak_num = fpn;
		filter_peak_num_flag = true;
	}
	void set_num_top_peaks(int ntp) {
		num_top_peaks = ntp;
		num_top_peaks_flag = true;
	}
	void read_spectra(Config* config, string input_file, AnnotatedSpectrumCounterList& spectrum_vector);
	void read_spectra(Config* config, string input_file, AnnotatedSpectrumCounterList& spectrum_vector, vector<int> scan_set);

};

bool CompareSpectrumByPeptideStr(const Spectrum& s_1, const Spectrum& S2);

void read_scan_ind(ResInspect res_inspect, vector< vector <int> >& scan_ind, vector< vector<string> >& seqs, vector< vector <int> >& charge, vector<string>& spectrum_file);
void print_scan_ind(vector< vector <int> > scan_ind, vector<string> spectrum_files, string scan_ind_file);
bool CompareSingleResInspectByFile(SingleResInspect sri_1, SingleResInspect sri_2);

class SpecPairListList: public vector< vector< SpecPair> > {
	public:
	SpecPairListList() {len = -1;}
  	vector< vector<bool> > flag_used;
	vector< vector<int> > pair_ind;
	vector< vector<int> > scan_list; 
	vector< vector<int> > scan_list_native;
	float cys_off;
	int len;
	void set_cys_off(float co) { cys_off = co;}
	void construct(vector<AnnotatedSpectrumCounter>& spectrum_vector, vector<AnnotatedSpectrumCounter>& spectrum_vector_native, float thrsh, float thr_pair, int tot_num_cys);
	void print_out(int num_cys);
	void select(int l) {
		len = l;
		for(int ind = 0; ind < scan_list.size(); ind++) {
			if(scan_list[ind].size()>len) {
				scan_list[ind].resize(len);
				scan_list_native[ind].resize(len);
			}
		}
	}
};


bool CompareSpecPairBySharePeaks(const SpecPair& sp_1, const SpecPair& sp_2);

void print_annotation(vector<PeptideAdd>, vector<AnnotatedSpectrumAdd *> ann_spec_vec);

typedef float score_t;

class TheoricSpecNode {
public:
  float mass;
  int start_ind;
  int length;
  int offset_ind;
  int charge;
  int direction;
  int structure;
};

typedef vector<TheoricSpecNode> TheoricSpecNodeList;

score_t intersect_spectrum_unique(const AnnotatedSpectrumAdd& s_1, const AnnotatedSpectrumAdd& s_2, float offset, float thr, bool fwd = true);
bool CompareSpectrumByMass(const AnnotatedSpectrumAdd& s_1, const AnnotatedSpectrumAdd& s_2);
score_t intersect_threshold_binned(float* theo_spec, int theo_spec_size, BinnedSpectrum& binned_spectrum, int thresh_index);
score_t intersect_threshold_unique(float* theo_spec, int theo_spec_size, float* exper_spec, int exper_spec_size, mass_t threshold);
score_t intersect_threshold_intensity(float* theo_spec, int theo_spec_size, float* exper_spec, float* intensity_vec, int exper_spec_size, mass_t threshold);
score_t intersect_threshold_unique_thresh(float* theo_spec, int theo_spec_size, float* exper_spec, int exper_spec_size, float* thresh);
int Partition(int low,int high,float arr[]);
void Quick_sort(int low,int high, float arr[]);
int num_greater(vector<int> score_vector, int score);
void cum_to_diff(vector<float>& cum_seq, vector<float>& diff_seq);
void diff_to_com(vector<float>& diff_seq, vector<float>& cum_seq);
bool within_threshold(vector<float> seq_1, vector<float> seq_2, float thresh);
vector<float> rotate(vector<float> seq, int pos);
int calc_num_aa(PeptideAdd& pep, int aa);

class Offset {
	public:
	vector<float> val;
	vector<float> cof;
	void add_off(float vl, float cf) {
		val.push_back(vl);
		cof.push_back(cf);
	}
};

class Non_Linear_Peptide {
  public:
    float bound_offset;
    int min_aa_mass;
    TheoricSpecNodeList cyclic_spectra;
    TheoricSpecNodeList linear_spectra;
    void generate_random_nlp(int length, int mass);
    void set_integer() {is_integer = true;} 
    void set_real() {is_integer = false;} 
    void set_by_int_seq(vector<int> sq) {
      seq.clear();
      for(int ind = 0; ind < sq.size(); ind++)
        seq.push_back(sq[ind]);
    }
    int structure;
    bool is_integer;
    float mass;
    float mass_real;
    float mass_real_cyc;
    float mass_real_lin;
    int mass_int;
    int max_charge;
    Offset offset;
    string seq_str;
    vector<float> seq;
    vector<float> cum_seq;
    vector<float> seq_lin;
    vector<float> seq_cyc;
    PeptideAdd pep;
    bool seq_lin_first; // true => start from linear part, false => start from cyclic part
    score_t score;
    int idx;

    void get_cyclic_nlp(Non_Linear_Peptide& nlp);
    void get_linear_nlp(Non_Linear_Peptide& nlp);

    void set_idx(int index) {idx = index;}
    int get_idx() {return idx;}
    int get_length() {
      return seq.size();
    }
    float get_mass() {
      if(is_integer)
        return get_mass_int();
     else
        return get_mass_real();
    }
    void scale_by(float r);
    float get_mass_real_cyc() {
	float mass_real_cyc = 0;
    	for(int ind = 0; ind < seq_cyc.size(); ind++)
	    mass_real_cyc += seq_cyc[ind];
	return mass_real_cyc;
	
    }

    float get_mass_real_lin() {
	float mass_real_lin = 0;
    	for(int ind = 0; ind < seq_lin.size(); ind++)
	    mass_real_lin += seq_lin[ind];
	return mass_real_lin;
    }
   
    float get_length_cyc() {
	return seq_cyc.size();
    }

    float get_length_lin() {
	return seq_lin.size();
    }

    float get_mass_real() {
      if(structure == 2) {
	seq.clear();
	for(int ind = 0; ind < seq_lin.size(); ind++)
		seq.push_back(seq_lin[ind]);
	for(int ind = 0; ind < seq_cyc.size(); ind++)
		seq.push_back(seq_cyc[ind]);
      }
      mass_real = 0;
      for(int ind = 0; ind < seq.size(); ind++)
        mass_real += seq[ind];
      mass_real += MASS_H2O - bound_offset;
      return mass_real;
    }

    int get_mass_int() {
      mass_int = 0;
      for(int ind = 0; ind < seq.size(); ind++)
        mass_int += seq[ind];
      return mass_int;
    }

    Non_Linear_Peptide() {
      min_aa_mass = 57;
      score = 0;
      structure = 1; // 0 for linear, 1 for cyclic, 2 for branch cyclic
      is_integer = false;
      seq.clear(); 
      seq_lin.clear(); 
      seq_cyc.clear(); 
      seq_lin_first = false;
      max_charge = 1;
      offset.val.clear();
      offset.val.push_back(0);
    };
    void calculate_theoric_cyclic_spectra();
    void calculate_theoric_linear_spectra();
    void get_nlp_fragment(TheoricSpecNode tsn, Non_Linear_Peptide& nlp_frag);
    void print();
    void print_standard();
	  // void operator= (const Non_Linear_Peptide& other);
};

class NLP_list : public vector<Non_Linear_Peptide> {
  public:
  NLP_list() {min_aa_mass = 57;}
  int min_aa_mass;
  void set_min_aa_mass(int mam) {min_aa_mass = mam;}
  void rotate_minimal(int structure);
  void sort_unique(int structure);
  void unique();
  void copy_aa(NLP_list& tmp_nlp_list, int last_aa);
  void generate(int first_step, int parent_mass, int structure);
  void sort_score();
  void select_top(int tsn);
  void print_standard(int num);
  void print_standard();
  void print(int num);
  void print();
  void add_nlp_extension(Non_Linear_Peptide& nlp);
  void extend();
  void write_to_html(string out_html, string html_prefix, string html_suffix);
  void write_to_html(string out_html);


};

// ostream& operator << (ostream& os, const vecotro<float> seq);
ostream& operator << (ostream& os, const Non_Linear_Peptide& pep);
bool CompareNLPByScore(const Non_Linear_Peptide nlp_1, const Non_Linear_Peptide nlp_2);


class TheoricMultistageTreeNode {

public:
  void sort_children();
  TheoricMultistageTreeNode();
  float scale_factor;
  int root_ms_level;
  bool is_integer;
  bool is_root;
  int ms_level_;
  int mass_int_;
  float mass_real_;
  Non_Linear_Peptide nlp_;
  void print();
  void print(int depth);
  void set_nlp(Non_Linear_Peptide nlp) {nlp_ = nlp;}
  void set_ms_level(int ms_level) {ms_level_ = ms_level;}
  void set_scale_factor(float sf) {scale_factor = sf;}
  void set_root() {is_root = true;}
  int convert_mass_to_int(float mass);

  int get_ms_level() {return ms_level_;}
  
  float get_mass() const;
  float get_mass_real() const {return mass_real_;}
  int get_mass_int() const {return mass_int_;}

  void set_mass(float m);
  void set_mass_real(float mr) {mass_real_ = mr;}
  void set_mass_int(int mi) {mass_int_ = mi;}

  vector<TheoricMultistageTreeNode> children;

  void initialize_root_from_NLP(Non_Linear_Peptide& nlp, int depth, int structure);
  void initialize_root_from_cyclic_NLP(Non_Linear_Peptide& nlp, int depth);
  void initialize_root_from_linear_NLP(Non_Linear_Peptide& nlp, int depth);
  void initialize_from_linear_NLP(Non_Linear_Peptide& nlp, TheoricSpecNode tsn, int current_depth, int depth);
};


class MultistageTreeNode {
  public:
  MultistageTreeNode* root;
  int level_num;
  vector<int> num_ms_level;
  int max_ms_level;
  bool is_integer;
  void set_integer() {is_integer = true;} 
  MultistageTreeNode();
  void sort_children();
  void initialize_from_spectra(AnnotatedSpectrumCounterList& spectrum_vector);
  int initialize_from_spectra(AnnotatedSpectrumCounterList& spectrum_vector, int spec_ind, int ms_level);
  int initialize_from_mass(AnnotatedSpectrumCounterList& spectrum_vector, int spec_index, int index);
  void print();
  void print(int depth);
  void set_spec_index(int spec_index) {spec_index_ = spec_index;}
  void set_parent_spec_index(int spec_index) {spec_index_ = spec_index;}
  void set_num_children(int num_child) {num_child_ = num_child;}
  void set_ms_level(int ms_level) {ms_level_ = ms_level;}
  void set_scale_factor(float sf) {scale_factor = sf;}
  void set_root() {is_root = true;}
  void set_leaf() {is_leaf = true;}

  float get_mass() const;
  float get_mass_real() const {return mass_real;}
  int get_mass_int() const {return mass_int;}

  void set_mass(float mr);
  void set_mass_real(float mr) {mass_real = mr;}
  void set_mass_int(int mi) {mass_int = mi;}

  int convert_mass_to_int(float mass);

  int get_spec_index() {return spec_index_;}
  int get_parent_spec_index() {return spec_index_;}
  int get_num_children() {return num_child_;}
  int get_ms_level() {return ms_level_;}

  // MultistageTreeNode* parent;
  vector<MultistageTreeNode> children;
  float scale_factor;
  bool is_root;
  bool is_leaf;
  int root_ms_level;
  int num_child_;
  float mass_real;
  int mass_int;
  int spec_index_;
  int parent_spec_index_;
  // int index;
  // int parent_node_index;
  int ms_level_;
};

class AnnotRes {
    public:
    AnnotRes() {pep_set_flag = false;}
    bool pep_set_flag;
    PeptideAdd pep;
    string pep_string;
    vector<vector<int> > spec_id_mult_vec;
    vector<vector<float> > mass_error_mult_vec;
    vector<vector<float> > mass_mult_vec;
    vector<int> num_start;
    vector<int> num_end;
    vector<int> spec_id_vec;
    vector<float> spec_val_vec;
    vector<int> charge_num_vec;
    vector<float> mass_error_vec;
    vector<float> mass_vec;
    vector<int> position_vec;
    vector<int> length_vec; 
    vector<int> direction;
    vector<float> offset_vec;
    vector<string> pep_str_vec;
    void peptide_spectrum_score(AnnotatedSpectrumCounter& input_spectrum, PeptideAdd& pep, int max_charge, vector<float> acc_thresh, Offset offset, int do_cyclic, int score_type);
    void peptide_spectrum_score(AnnotatedSpectrumCounter& input_spectrum, vector<float> seq, int max_charge, vector<float> acc_thresh, Offset offset, int do_cyclic, int score_type);
    void peptide_spectrum_score_repeat(AnnotatedSpectrumCounter& input_spectrum, vector<float> seq, int max_charge, vector<float> acc_thresh, Offset offset, int do_cyclic);
    void peptide_spectrum_score_repeat_cyclic(AnnotatedSpectrumCounter& input_spectrum, vector<float> seq, int max_charge, vector<float> acc_thresh, Offset offset);
    void construct_theoric_spec_repeat_cyclic(vector<vector<float> > seq, int max_charge, vector<float> acc_thresh, Offset offset);
    void construct_theoric_spec_repeat_cyclic(vector<PeptideAdd> pep_vec, int max_charge, vector<float> acc_thresh, Offset offset);
    void peptide_spectrum_score_mult(vector<AnnotatedSpectrumCounter*> spec_vec, vector<PeptideAdd> pep_vec, int max_charge, vector<float> acc_thresh, Offset offset, int do_cyclic, int score_type);
    void peptide_spectrum_score_repeat_mult(vector<AnnotatedSpectrumCounter*> spec_vec, vector<PeptideAdd> pep_vec, int max_charge, vector<float> acc_thresh, Offset offset, int do_cyclic);
    void peptide_spectrum_score_repeat_cyclic_mult(vector<AnnotatedSpectrumCounter*> spec_vec, vector<PeptideAdd> pep_vec, int max_charge, vector<float> acc_thresh, Offset offset);

    void print(string file_name);
    void print_mult(string file_name);
    void set_peptide(PeptideAdd& p) {
    	pep = p;
    	pep_set_flag = true;
    	pep_string = pep.getPeptideStr();
    }

    vector< vector<float> >spec_val;
    vector<float> charge_num;
    vector<float> position;
    vector<float> stop;
    vector<float> length;
    vector<float> off;
    string pep_str_rep;
    vector<int> stat;
	
};

float sum_vector(vector<mass_t> input);
float elcom2mass(string input);

class MultistageTreeScorer {
  public:
  int score_type;
  void set_integer_score() {score_type = 1;}
  void set_real_score() {score_type = 0;}
  float thresh;
  MultistageTreeScorer();
  bool print_flag;
  void set_thresh(float thr) {thresh = thr;}
  void set_print_flag() {print_flag = true;}
  void set_score_vector(vector<float> sc) {score_cof = sc;}
  float int_unique_score(TheoricMultistageTreeNode& tmtn, MultistageTreeNode& mtn);
  float real_unique_score(TheoricMultistageTreeNode& tmtn, MultistageTreeNode& mtn);
  float score(TheoricMultistageTreeNode& tmtn, MultistageTreeNode& mtn);
  vector<float> score_cof;
};
	
class MultDenovoSeqModel {
  public:
  MultDenovoSeqModel();
  MultistageTreeNode mult_tree_root;
  MultistageTreeScorer mult_tree_scorer;
  string out_html;
  bool html_flag;
  bool print_flag;
  int top_select_num;
  float scale_factor;
  void int_unique_score(Non_Linear_Peptide& nlp);
  void int_unique_score(NLP_list& nlp_list);
  int structure;
  int length;
  int ms_level;
  int first_step;
  int parent_mass;
  float parent_mass_real_no_charge;
  float min_aa_mass;
  bool parent_mass_flag;
  bool ms_level_flag;
  void set_print_flag() {print_flag = true;}
  void set_parent_mass(float pm) {parent_mass_real_no_charge = pm; parent_mass = pm*scale_factor; parent_mass_flag = true;}
  float get_parent_mass() {return parent_mass_real_no_charge;}
  void set_top_select_num(int tsn) {top_select_num = tsn;}
  void set_structure(int s) {structure = s;}
  void set_output_html(string oh) {out_html = oh; html_flag = true;}
  void set_length(int l) {length = l;}
  void set_min_aa_mass(float m) {min_aa_mass = m;}
  void set_first_step(int fs) {first_step = fs;}
  void set_ms_level(int ml) {ms_level = ml; ms_level_flag = true;}
  void denovo_sequence(AnnotatedSpectrumCounterList& spectrum_vector, NLP_list& nlp_list);
};

bool CompareNLPBySeq(const Non_Linear_Peptide& nlp_1, const Non_Linear_Peptide& nlp_2);
void reverse_nlp(Non_Linear_Peptide& nlp, Non_Linear_Peptide& nlp_rev);
void rotate_nlp(Non_Linear_Peptide& nlp, Non_Linear_Peptide& nlp_rot, int num);
void rotate_minimal_cyclic_nlp(Non_Linear_Peptide& nlp);
void rotate_minimal_linear_nlp(Non_Linear_Peptide& nlp);
void rotate_minimal_nlp(Non_Linear_Peptide& nlp, int structure);
void add_breakage(Non_Linear_Peptide& nlp, int ind, int break_pos, Non_Linear_Peptide& nlp_mod);
bool CompareNLPBySeq(const Non_Linear_Peptide& nlp_1, const Non_Linear_Peptide& nlp_2);
bool CompareNLPBySeqEq(const Non_Linear_Peptide& nlp_1, const Non_Linear_Peptide& nlp_2);
// bool ComparePeakByMass(const Peak& p_1, const Peak& p_2);



class GappedPeptide {
  public:
  PeptideAdd pep;
  Non_Linear_Peptide nlp;
  int score;
  float gap_mass;
  void extend(Config* config, GappedPeptide& gap_pep, int aa_ind);
  void load_nlp();
  void parseFromPeptide(PeptideAdd& pep, float pm);
};


class GappedPeptideList : public vector<GappedPeptide> { 
  public:
  void parseFromPeptide(Config* config, PeptideAdd& pep, float pm, int denovo_len);
  float parent_mass;
  Config* config;
  void set_parent_mass(float pm) {parent_mass = pm;}
  void set_config(Config* conf) {config = conf;}
  void generate(int first_step);
  void extend();
  void sort_score();
  void select_top(int num_top);
  void print();
  void print(string out_file);
};

class GappedPeptideListList : public vector<GappedPeptideList> { 
};

class DenovoGappedModel {
  public:
  DenovoGappedModel() {first_step = 0;}
  Config* config;
  int score_type;
  int structure;
  vector<float> acc_thresh;
  Offset offset;
  int first_step;
  int denovo_len;
  int num_top;
  void set_offset(Offset o) {offset = o;}
  void set_acc_thresh(vector<float> ac) {acc_thresh = ac;}
  void set_structure(int str) {structure = str;}
  void set_score_type(int st) {score_type = st;}
  void score(GappedPeptideList& gap_pep_list, AnnotatedSpectrumCounter& spectrum);
  void set_config(Config* conf) {config = conf;}
  void set_denovo_len(int dl) {denovo_len = dl;}
  void set_num_top(int nt) {num_top = nt;}
  void reconstruct_denovo(GappedPeptideList& gap_pep_list, AnnotatedSpectrumCounter& spectrum);
  void reconstruct_denovo(GappedPeptideListList& gap_pep_list_list, vector<AnnotatedSpectrumCounter>& spectrum);
};

class ScoreCalculator {
  public:
  MultistageTreeScorer mult_tree_scorer;
  ScoreCalculator() {ms_level_flag = false; structure = 1;}
  bool ms_level_flag;
  int ms_level;
  int structure;
  int num_pep;
  void set_real_score() {mult_tree_scorer.set_real_score();}
  void set_integer_score() {mult_tree_scorer.set_integer_score();}
  void set_thresh(float thresh) { mult_tree_scorer.set_thresh(thresh); }
  void set_structure(int s) {structure = s;}
  void set_ms_level(int ml) {ms_level = ml; ms_level_flag = true;}
  void calculate_score(AnnotatedSpectrumCounterList& spectrum_vector, NLP_list& nlp_vec);
  int calculate_score(AnnotatedSpectrumCounterList& spectrum_vector, Non_Linear_Peptide& nlp);
  int calculate_score(MultistageTreeNode& mtn, Non_Linear_Peptide& nlp);
};

class PvalCalculator : public ScoreCalculator {
  public:
  float calculate_pvalue(AnnotatedSpectrumCounterList& spectrum_vector, Non_Linear_Peptide& nlp);
  void set_num_pep(int np) {num_pep = np;}
};

#endif
