package org.pdb.beans;

/**
 *  Data items in the ATOM_SITE_ANISOTROP category record details
 *  about anisotropic displacement parameters.
 *  If the ATOM_SITE_ANISOTROP category is used for storing these
 *  data, the corresponding ATOM_SITE data items are not used.
 *  
 * <pre>
 *  Example 1 - based on NDB structure BDL005 of Holbrook, Dickerson &
 *  Kim [Acta Cryst. (1985), B41, 255-262].
 *  <PDBx:atom_site_anisotropCategory>
 *  <PDBx:atom_site_anisotrop id="1">
 *  <PDBx:type_symbol>O</PDBx:type_symbol>
 *  <PDBx:U11>8642.</PDBx:U11>
 *  <PDBx:U12>4866.</PDBx:U12>
 *  <PDBx:U13>7299.</PDBx:U13>
 *  <PDBx:U22>-342.</PDBx:U22>
 *  <PDBx:U23>-258.</PDBx:U23>
 *  <PDBx:U33>-1427.</PDBx:U33>
 *  </PDBx:atom_site_anisotrop>
 *  <PDBx:atom_site_anisotrop id="2">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:U11>5174.</PDBx:U11>
 *  <PDBx:U12>4871.</PDBx:U12>
 *  <PDBx:U13>6243.</PDBx:U13>
 *  <PDBx:U22>-1885.</PDBx:U22>
 *  <PDBx:U23>-2051.</PDBx:U23>
 *  <PDBx:U33>-1377.</PDBx:U33>
 *  </PDBx:atom_site_anisotrop>
 *  <PDBx:atom_site_anisotrop id="3">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:U11>6202.</PDBx:U11>
 *  <PDBx:U12>5020.</PDBx:U12>
 *  <PDBx:U13>4395.</PDBx:U13>
 *  <PDBx:U22>-1130.</PDBx:U22>
 *  <PDBx:U23>-556.</PDBx:U23>
 *  <PDBx:U33>-632.</PDBx:U33>
 *  </PDBx:atom_site_anisotrop>
 *  <PDBx:atom_site_anisotrop id="4">
 *  <PDBx:type_symbol>O</PDBx:type_symbol>
 *  <PDBx:U11>4224.</PDBx:U11>
 *  <PDBx:U12>4700.</PDBx:U12>
 *  <PDBx:U13>5046.</PDBx:U13>
 *  <PDBx:U22>1105.</PDBx:U22>
 *  <PDBx:U23>-161.</PDBx:U23>
 *  <PDBx:U33>345.</PDBx:U33>
 *  </PDBx:atom_site_anisotrop>
 *  <PDBx:atom_site_anisotrop id="5">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:U11>8684.</PDBx:U11>
 *  <PDBx:U12>4688.</PDBx:U12>
 *  <PDBx:U13>4171.</PDBx:U13>
 *  <PDBx:U22>-1850.</PDBx:U22>
 *  <PDBx:U23>-433.</PDBx:U23>
 *  <PDBx:U33>-292.</PDBx:U33>
 *  </PDBx:atom_site_anisotrop>
 *  <PDBx:atom_site_anisotrop id="6">
 *  <PDBx:type_symbol>O</PDBx:type_symbol>
 *  <PDBx:U11>11226.</PDBx:U11>
 *  <PDBx:U12>5255.</PDBx:U12>
 *  <PDBx:U13>3532.</PDBx:U13>
 *  <PDBx:U22>-341.</PDBx:U22>
 *  <PDBx:U23>2685.</PDBx:U23>
 *  <PDBx:U33>1328.</PDBx:U33>
 *  </PDBx:atom_site_anisotrop>
 *  <PDBx:atom_site_anisotrop id="7">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:U11>10214.</PDBx:U11>
 *  <PDBx:U12>2428.</PDBx:U12>
 *  <PDBx:U13>5614.</PDBx:U13>
 *  <PDBx:U22>-2610.</PDBx:U22>
 *  <PDBx:U23>-1940.</PDBx:U23>
 *  <PDBx:U33>902.</PDBx:U33>
 *  </PDBx:atom_site_anisotrop>
 *  <PDBx:atom_site_anisotrop id="8">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:U11>4590.</PDBx:U11>
 *  <PDBx:U12>3488.</PDBx:U12>
 *  <PDBx:U13>5827.</PDBx:U13>
 *  <PDBx:U22>751.</PDBx:U22>
 *  <PDBx:U23>-770.</PDBx:U23>
 *  <PDBx:U33>986.</PDBx:U33>
 *  </PDBx:atom_site_anisotrop>
 *  <PDBx:atom_site_anisotrop id="9">
 *  <PDBx:type_symbol>N</PDBx:type_symbol>
 *  <PDBx:U11>5014.</PDBx:U11>
 *  <PDBx:U12>4434.</PDBx:U12>
 *  <PDBx:U13>3447.</PDBx:U13>
 *  <PDBx:U22>-17.</PDBx:U22>
 *  <PDBx:U23>-1593.</PDBx:U23>
 *  <PDBx:U33>539.</PDBx:U33>
 *  </PDBx:atom_site_anisotrop>
 *  </PDBx:atom_site_anisotropCategory>
 * </pre>
 */
public class Atom_site_anisotrop 
{
		protected java.lang.Float B11;


	/**
	 *  The [1][1] element of the anisotropic atomic displacement
	 *  matrix B, which appears in the structure-factor term as:
	 *  
	 *  T = exp{-1/4 sum~i~[sum~j~(B^ij^ h~i~ h~j~ a*~i~ a*~j~)]}
	 *  
	 *  h  = the Miller indices
	 *  a* = the reciprocal space cell lengths
	 *  
	 *  These matrix elements may appear with atomic coordinates
	 *  in the ATOM_SITE category, or they may appear in the separate
	 *  ATOM_SITE_ANISOTROP category, but they may not appear in both
	 *  places. Similarly, anisotropic displacements may appear as
	 *  either B's or U's, but not as both.
	 *  
	 *  The unique elements of the real symmetric matrix are
	 *  entered by row.
	 *  
	 *  The IUCr Commission on Nomenclature recommends against the use
	 *  of B for reporting atomic displacement parameters. U, being
	 *  directly proportional to B, is preferred.
	 */
	public java.lang.Float getB11() 
	{
		return B11;
	}
 
	public void setB11(java.lang.Float B11)
	{
		this.B11 = B11;
	}

 	protected java.lang.Float B11_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute B[1][1] in category atom_site_anisotrop.
	 */
	public java.lang.Float getB11_esd() 
	{
		return B11_esd;
	}
 
	public void setB11_esd(java.lang.Float B11_esd)
	{
		this.B11_esd = B11_esd;
	}

 	protected java.lang.Float B12;


	/**
	 *  The [1][2] element of the anisotropic atomic displacement
	 *  matrix B, which appears in the structure-factor term as:
	 *  
	 *  T = exp{-1/4 sum~i~[sum~j~(B^ij^ h~i~ h~j~ a*~i~ a*~j~)]}
	 *  
	 *  h  = the Miller indices
	 *  a* = the reciprocal space cell lengths
	 *  
	 *  These matrix elements may appear with atomic coordinates
	 *  in the ATOM_SITE category, or they may appear in the separate
	 *  ATOM_SITE_ANISOTROP category, but they may not appear in both
	 *  places. Similarly, anisotropic displacements may appear as
	 *  either B's or U's, but not as both.
	 *  
	 *  The unique elements of the real symmetric matrix are
	 *  entered by row.
	 *  
	 *  The IUCr Commission on Nomenclature recommends against the use
	 *  of B for reporting atomic displacement parameters. U, being
	 *  directly proportional to B, is preferred.
	 */
	public java.lang.Float getB12() 
	{
		return B12;
	}
 
	public void setB12(java.lang.Float B12)
	{
		this.B12 = B12;
	}

 	protected java.lang.Float B12_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute B[1][2] in category atom_site_anisotrop.
	 */
	public java.lang.Float getB12_esd() 
	{
		return B12_esd;
	}
 
	public void setB12_esd(java.lang.Float B12_esd)
	{
		this.B12_esd = B12_esd;
	}

 	protected java.lang.Float B13;


	/**
	 *  The [1][3] element of the anisotropic atomic displacement
	 *  matrix B, which appears in the structure-factor term as:
	 *  
	 *  T = exp{-1/4 sum~i~[sum~j~(B^ij^ h~i~ h~j~ a*~i~ a*~j~)]}
	 *  
	 *  h  = the Miller indices
	 *  a* = the reciprocal space cell lengths
	 *  
	 *  These matrix elements may appear with atomic coordinates
	 *  in the ATOM_SITE category, or they may appear in the separate
	 *  ATOM_SITE_ANISOTROP category, but they may not appear in both
	 *  places. Similarly, anisotropic displacements may appear as
	 *  either B's or U's, but not as both.
	 *  
	 *  The unique elements of the real symmetric matrix are
	 *  entered by row.
	 *  
	 *  The IUCr Commission on Nomenclature recommends against the use
	 *  of B for reporting atomic displacement parameters. U, being
	 *  directly proportional to B, is preferred.
	 */
	public java.lang.Float getB13() 
	{
		return B13;
	}
 
	public void setB13(java.lang.Float B13)
	{
		this.B13 = B13;
	}

 	protected java.lang.Float B13_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute B[1][3] in category atom_site_anisotrop.
	 */
	public java.lang.Float getB13_esd() 
	{
		return B13_esd;
	}
 
	public void setB13_esd(java.lang.Float B13_esd)
	{
		this.B13_esd = B13_esd;
	}

 	protected java.lang.Float B22;


	/**
	 *  The [2][2] element of the anisotropic atomic displacement
	 *  matrix B, which appears in the structure-factor term as:
	 *  
	 *  T = exp{-1/4 sum~i~[sum~j~(B^ij^ h~i~ h~j~ a*~i~ a*~j~)]}
	 *  
	 *  h  = the Miller indices
	 *  a* = the reciprocal space cell lengths
	 *  
	 *  These matrix elements may appear with atomic coordinates
	 *  in the ATOM_SITE category, or they may appear in the separate
	 *  ATOM_SITE_ANISOTROP category, but they may not appear in both
	 *  places. Similarly, anisotropic displacements may appear as
	 *  either B's or U's, but not as both.
	 *  
	 *  The unique elements of the real symmetric matrix are
	 *  entered by row.
	 *  
	 *  The IUCr Commission on Nomenclature recommends against the use
	 *  of B for reporting atomic displacement parameters. U, being
	 *  directly proportional to B, is preferred.
	 */
	public java.lang.Float getB22() 
	{
		return B22;
	}
 
	public void setB22(java.lang.Float B22)
	{
		this.B22 = B22;
	}

 	protected java.lang.Float B22_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute B[2][2] in category atom_site_anisotrop.
	 */
	public java.lang.Float getB22_esd() 
	{
		return B22_esd;
	}
 
	public void setB22_esd(java.lang.Float B22_esd)
	{
		this.B22_esd = B22_esd;
	}

 	protected java.lang.Float B23;


	/**
	 *  The [2][3] element of the anisotropic atomic displacement
	 *  matrix B, which appears in the structure-factor term as:
	 *  
	 *  T = exp{-1/4 sum~i~[sum~j~(B^ij^ h~i~ h~j~ a*~i~ a*~j~)]}
	 *  
	 *  h  = the Miller indices
	 *  a* = the reciprocal space cell lengths
	 *  
	 *  These matrix elements may appear with atomic coordinates
	 *  in the ATOM_SITE category, or they may appear in the separate
	 *  ATOM_SITE_ANISOTROP category, but they may not appear in both
	 *  places. Similarly, anisotropic displacements may appear as
	 *  either B's or U's, but not as both.
	 *  
	 *  The unique elements of the real symmetric matrix are
	 *  entered by row.
	 *  
	 *  The IUCr Commission on Nomenclature recommends against the use
	 *  of B for reporting atomic displacement parameters. U, being
	 *  directly proportional to B, is preferred.
	 */
	public java.lang.Float getB23() 
	{
		return B23;
	}
 
	public void setB23(java.lang.Float B23)
	{
		this.B23 = B23;
	}

 	protected java.lang.Float B23_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute B[2][3] in category atom_site_anisotrop.
	 */
	public java.lang.Float getB23_esd() 
	{
		return B23_esd;
	}
 
	public void setB23_esd(java.lang.Float B23_esd)
	{
		this.B23_esd = B23_esd;
	}

 	protected java.lang.Float B33;


	/**
	 *  The [3][3] element of the anisotropic atomic displacement
	 *  matrix B, which appears in the structure-factor term as:
	 *  
	 *  T = exp{-1/4 sum~i~[sum~j~(B^ij^ h~i~ h~j~ a*~i~ a*~j~)]}
	 *  
	 *  h  = the Miller indices
	 *  a* = the reciprocal space cell lengths
	 *  
	 *  These matrix elements may appear with atomic coordinates
	 *  in the ATOM_SITE category, or they may appear in the separate
	 *  ATOM_SITE_ANISOTROP category, but they may not appear in both
	 *  places. Similarly, anisotropic displacements may appear as
	 *  either B's or U's, but not as both.
	 *  
	 *  The unique elements of the real symmetric matrix are
	 *  entered by row.
	 *  
	 *  The IUCr Commission on Nomenclature recommends against the use
	 *  of B for reporting atomic displacement parameters. U, being
	 *  directly proportional to B, is preferred.
	 */
	public java.lang.Float getB33() 
	{
		return B33;
	}
 
	public void setB33(java.lang.Float B33)
	{
		this.B33 = B33;
	}

 	protected java.lang.Float B33_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute B[3][3] in category atom_site_anisotrop.
	 */
	public java.lang.Float getB33_esd() 
	{
		return B33_esd;
	}
 
	public void setB33_esd(java.lang.Float B33_esd)
	{
		this.B33_esd = B33_esd;
	}

 	protected java.lang.Float U11;


	/**
	 *  The [1][1] element of the standard anisotropic atomic
	 *  displacement matrix U, which appears in the structure-factor
	 *  term as:
	 *  
	 *  T = exp{-2 pi^2^ sum~i~[sum~j~(U^ij^ h~i~ h~j~ a*~i~ a*~j~)]}
	 *  
	 *  h  = the Miller indices
	 *  a* = the reciprocal space cell lengths
	 *  
	 *  These matrix elements may appear with atomic coordinates
	 *  in the ATOM_SITE category, or they may appear in the separate
	 *  ATOM_SITE_ANISOTROP category, but they may not appear in both
	 *  places. Similarly, anisotropic displacements may appear as
	 *  either B's or U's, but not as both.
	 *  
	 *  The unique elements of the real symmetric matrix are
	 *  entered by row.
	 */
	public java.lang.Float getU11() 
	{
		return U11;
	}
 
	public void setU11(java.lang.Float U11)
	{
		this.U11 = U11;
	}

 	protected java.lang.Float U11_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute U[1][1] in category atom_site_anisotrop.
	 */
	public java.lang.Float getU11_esd() 
	{
		return U11_esd;
	}
 
	public void setU11_esd(java.lang.Float U11_esd)
	{
		this.U11_esd = U11_esd;
	}

 	protected java.lang.Float U12;


	/**
	 *  The [1][2] element of the standard anisotropic atomic
	 *  displacement matrix U, which appears in the structure-factor
	 *  term as:
	 *  
	 *  T = exp{-2 pi^2^ sum~i~[sum~j~(U^ij^ h~i~ h~j~ a*~i~ a*~j~)]}
	 *  
	 *  h  = the Miller indices
	 *  a* = the reciprocal space cell lengths
	 *  
	 *  These matrix elements may appear with atomic coordinates
	 *  in the ATOM_SITE category, or they may appear in the separate
	 *  ATOM_SITE_ANISOTROP category, but they may not appear in both
	 *  places. Similarly, anisotropic displacements may appear as
	 *  either B's or U's, but not as both.
	 *  
	 *  The unique elements of the real symmetric matrix are
	 *  entered by row.
	 */
	public java.lang.Float getU12() 
	{
		return U12;
	}
 
	public void setU12(java.lang.Float U12)
	{
		this.U12 = U12;
	}

 	protected java.lang.Float U12_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute U[1][2] in category atom_site_anisotrop.
	 */
	public java.lang.Float getU12_esd() 
	{
		return U12_esd;
	}
 
	public void setU12_esd(java.lang.Float U12_esd)
	{
		this.U12_esd = U12_esd;
	}

 	protected java.lang.Float U13;


	/**
	 *  The [1][3] element of the standard anisotropic atomic
	 *  displacement matrix U, which appears in the structure-factor
	 *  term as:
	 *  
	 *  T = exp{-2 pi^2^ sum~i~[sum~j~(U^ij^ h~i~ h~j~ a*~i~ a*~j~)]}
	 *  
	 *  h  = the Miller indices
	 *  a* = the reciprocal space cell lengths
	 *  
	 *  These matrix elements may appear with atomic coordinates
	 *  in the ATOM_SITE category, or they may appear in the separate
	 *  ATOM_SITE_ANISOTROP category, but they may not appear in both
	 *  places. Similarly, anisotropic displacements may appear as
	 *  either B's or U's, but not as both.
	 *  
	 *  The unique elements of the real symmetric matrix are
	 *  entered by row.
	 */
	public java.lang.Float getU13() 
	{
		return U13;
	}
 
	public void setU13(java.lang.Float U13)
	{
		this.U13 = U13;
	}

 	protected java.lang.Float U13_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute U[1][3] in category atom_site_anisotrop.
	 */
	public java.lang.Float getU13_esd() 
	{
		return U13_esd;
	}
 
	public void setU13_esd(java.lang.Float U13_esd)
	{
		this.U13_esd = U13_esd;
	}

 	protected java.lang.Float U22;


	/**
	 *  The [2][2] element of the standard anisotropic atomic
	 *  displacement matrix U, which appears in the structure-factor
	 *  term as:
	 *  
	 *  T = exp{-2 pi^2^ sum~i~[sum~j~(U^ij^ h~i~ h~j~ a*~i~ a*~j~)]}
	 *  
	 *  h  = the Miller indices
	 *  a* = the reciprocal space cell lengths
	 *  
	 *  These matrix elements may appear with atomic coordinates
	 *  in the ATOM_SITE category, or they may appear in the separate
	 *  ATOM_SITE_ANISOTROP category, but they may not appear in both
	 *  places. Similarly, anisotropic displacements may appear as
	 *  either B's or U's, but not as both.
	 *  
	 *  The unique elements of the real symmetric matrix are
	 *  entered by row.
	 */
	public java.lang.Float getU22() 
	{
		return U22;
	}
 
	public void setU22(java.lang.Float U22)
	{
		this.U22 = U22;
	}

 	protected java.lang.Float U22_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute U[2][2] in category atom_site_anisotrop.
	 */
	public java.lang.Float getU22_esd() 
	{
		return U22_esd;
	}
 
	public void setU22_esd(java.lang.Float U22_esd)
	{
		this.U22_esd = U22_esd;
	}

 	protected java.lang.Float U23;


	/**
	 *  The [2][3] element of the standard anisotropic atomic
	 *  displacement matrix U, which appears in the structure-factor
	 *  term as:
	 *  
	 *  T = exp{-2 pi^2^ sum~i~[sum~j~(U^ij^ h~i~ h~j~ a*~i~ a*~j~)]}
	 *  
	 *  h  = the Miller indices
	 *  a* = the reciprocal space cell lengths
	 *  
	 *  These matrix elements may appear with atomic coordinates
	 *  in the ATOM_SITE category, or they may appear in the separate
	 *  ATOM_SITE_ANISOTROP category, but they may not appear in both
	 *  places. Similarly, anisotropic displacements may appear as
	 *  either B's or U's, but not as both.
	 *  
	 *  The unique elements of the real symmetric matrix are
	 *  entered by row.
	 */
	public java.lang.Float getU23() 
	{
		return U23;
	}
 
	public void setU23(java.lang.Float U23)
	{
		this.U23 = U23;
	}

 	protected java.lang.Float U23_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute U[2][3] in category atom_site_anisotrop.
	 */
	public java.lang.Float getU23_esd() 
	{
		return U23_esd;
	}
 
	public void setU23_esd(java.lang.Float U23_esd)
	{
		this.U23_esd = U23_esd;
	}

 	protected java.lang.Float U33;


	/**
	 *  The [3][3] element of the standard anisotropic atomic
	 *  displacement matrix U, which appears in the structure-factor
	 *  term as:
	 *  
	 *  T = exp{-2 pi^2^ sum~i~[sum~j~(U^ij^ h~i~ h~j~ a*~i~ a*~j~)]}
	 *  
	 *  h  = the Miller indices
	 *  a* = the reciprocal space cell lengths
	 *  
	 *  These matrix elements may appear with atomic coordinates
	 *  in the ATOM_SITE category, or they may appear in the separate
	 *  ATOM_SITE_ANISOTROP category, but they may not appear in both
	 *  places. Similarly, anisotropic displacements may appear as
	 *  either B's or U's, but not as both.
	 *  
	 *  The unique elements of the real symmetric matrix are
	 *  entered by row.
	 */
	public java.lang.Float getU33() 
	{
		return U33;
	}
 
	public void setU33(java.lang.Float U33)
	{
		this.U33 = U33;
	}

 	protected java.lang.Float U33_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute U[3][3] in category atom_site_anisotrop.
	 */
	public java.lang.Float getU33_esd() 
	{
		return U33_esd;
	}
 
	public void setU33_esd(java.lang.Float U33_esd)
	{
		this.U33_esd = U33_esd;
	}

 	protected java.lang.String id_;


	/**
	 *  This data item is a pointer to  attribute id in category atom_site in the ATOM_SITE
	 *  category.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String pdbx_PDB_ins_code;


	/**
	 *  Pointer to  attribute pdbx_PDB_ins_code in category atom_site
	 */
	public java.lang.String getPdbx_PDB_ins_code() 
	{
		return pdbx_PDB_ins_code;
	}
 
	public void setPdbx_PDB_ins_code(java.lang.String pdbx_PDB_ins_code)
	{
		this.pdbx_PDB_ins_code = pdbx_PDB_ins_code;
	}

 	protected java.lang.String pdbx_auth_alt_id;


	/**
	 *  Pointer to  attribute pdbx_auth_alt_id in category atom_site.
	 */
	public java.lang.String getPdbx_auth_alt_id() 
	{
		return pdbx_auth_alt_id;
	}
 
	public void setPdbx_auth_alt_id(java.lang.String pdbx_auth_alt_id)
	{
		this.pdbx_auth_alt_id = pdbx_auth_alt_id;
	}

 	protected java.lang.String pdbx_auth_asym_id;


	/**
	 *  Pointer to  attribute auth_asym_id in category atom_site
	 */
	public java.lang.String getPdbx_auth_asym_id() 
	{
		return pdbx_auth_asym_id;
	}
 
	public void setPdbx_auth_asym_id(java.lang.String pdbx_auth_asym_id)
	{
		this.pdbx_auth_asym_id = pdbx_auth_asym_id;
	}

 	protected java.lang.String pdbx_auth_atom_id;


	/**
	 *  Pointer to  attribute auth_atom_id in category atom_site
	 */
	public java.lang.String getPdbx_auth_atom_id() 
	{
		return pdbx_auth_atom_id;
	}
 
	public void setPdbx_auth_atom_id(java.lang.String pdbx_auth_atom_id)
	{
		this.pdbx_auth_atom_id = pdbx_auth_atom_id;
	}

 	protected java.lang.String pdbx_auth_comp_id;


	/**
	 *  Pointer to  attribute auth_comp_id in category atom_site
	 */
	public java.lang.String getPdbx_auth_comp_id() 
	{
		return pdbx_auth_comp_id;
	}
 
	public void setPdbx_auth_comp_id(java.lang.String pdbx_auth_comp_id)
	{
		this.pdbx_auth_comp_id = pdbx_auth_comp_id;
	}

 	protected java.lang.String pdbx_auth_seq_id;


	/**
	 *  Pointer to  attribute auth_seq_id in category atom_site
	 */
	public java.lang.String getPdbx_auth_seq_id() 
	{
		return pdbx_auth_seq_id;
	}
 
	public void setPdbx_auth_seq_id(java.lang.String pdbx_auth_seq_id)
	{
		this.pdbx_auth_seq_id = pdbx_auth_seq_id;
	}

 	protected java.lang.String pdbx_label_alt_id;


	/**
	 *  Pointer to  attribute label_alt_id in category atom_site.
	 */
	public java.lang.String getPdbx_label_alt_id() 
	{
		return pdbx_label_alt_id;
	}
 
	public void setPdbx_label_alt_id(java.lang.String pdbx_label_alt_id)
	{
		this.pdbx_label_alt_id = pdbx_label_alt_id;
	}

 	protected java.lang.String pdbx_label_asym_id;


	/**
	 *  Pointer to  attribute label_asym_id in category atom_site
	 */
	public java.lang.String getPdbx_label_asym_id() 
	{
		return pdbx_label_asym_id;
	}
 
	public void setPdbx_label_asym_id(java.lang.String pdbx_label_asym_id)
	{
		this.pdbx_label_asym_id = pdbx_label_asym_id;
	}

 	protected java.lang.String pdbx_label_atom_id;


	/**
	 *  Pointer to  attribute label_atom_id in category atom_site
	 */
	public java.lang.String getPdbx_label_atom_id() 
	{
		return pdbx_label_atom_id;
	}
 
	public void setPdbx_label_atom_id(java.lang.String pdbx_label_atom_id)
	{
		this.pdbx_label_atom_id = pdbx_label_atom_id;
	}

 	protected java.lang.String pdbx_label_comp_id;


	/**
	 *  Pointer to  attribute label_comp_id in category atom_site
	 */
	public java.lang.String getPdbx_label_comp_id() 
	{
		return pdbx_label_comp_id;
	}
 
	public void setPdbx_label_comp_id(java.lang.String pdbx_label_comp_id)
	{
		this.pdbx_label_comp_id = pdbx_label_comp_id;
	}

 	protected java.lang.Integer pdbx_label_seq_id;


	/**
	 *  Pointer to  attribute label_seq_id in category atom_site
	 */
	public java.lang.Integer getPdbx_label_seq_id() 
	{
		return pdbx_label_seq_id;
	}
 
	public void setPdbx_label_seq_id(java.lang.Integer pdbx_label_seq_id)
	{
		this.pdbx_label_seq_id = pdbx_label_seq_id;
	}

 	protected java.lang.Float ratio;


	/**
	 *  Ratio of the maximum to minimum principal axes of
	 *  displacement (thermal) ellipsoids.
	 */
	public java.lang.Float getRatio() 
	{
		return ratio;
	}
 
	public void setRatio(java.lang.Float ratio)
	{
		this.ratio = ratio;
	}

 	protected java.lang.String type_symbol;


	/**
	 *  This data item is a pointer to  attribute symbol in category atom_type in the
	 *  ATOM_TYPE category.
	 */
	public java.lang.String getType_symbol() 
	{
		return type_symbol;
	}
 
	public void setType_symbol(java.lang.String type_symbol)
	{
		this.type_symbol = type_symbol;
	}

 }
