package org.pdb.beans;

/**
 *  Data items in the ATOM_SITES_ALT_ENS category record details
 *  about the ensemble structure generated from atoms with various
 *  alternative conformation IDs.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:atom_sites_alt_ensCategory>
 *  <PDBx:atom_sites_alt_ens id="Ensemble 1-A">
 *  <PDBx:details> The inhibitor binds to the enzyme in two, roughly twofold
 *  symmetric alternative conformations.
 *  This conformational ensemble includes the more populated
 *  conformation of the inhibitor (ID=1) and the amino-acid
 *  side chains and solvent structure that correlate with this
 *  inhibitor conformation.
 *  Also included are one set (ID=3) of side chains with
 *  alternative conformations when the conformations are not
 *  correlated with the inhibitor conformation.</PDBx:details>
 *  </PDBx:atom_sites_alt_ens>
 *  <PDBx:atom_sites_alt_ens id="Ensemble 1-B">
 *  <PDBx:details> The inhibitor binds to the enzyme in two, roughly twofold
 *  symmetric alternative conformations.
 *  This conformational ensemble includes the more populated
 *  conformation of the inhibitor (ID=1) and the amino-acid
 *  side chains and solvent structure that correlate with
 *  this inhibitor conformation.
 *  Also included are one set (ID=4) of side chains with
 *  alternative conformations when the conformations are not
 *  correlated with the inhibitor conformation.</PDBx:details>
 *  </PDBx:atom_sites_alt_ens>
 *  <PDBx:atom_sites_alt_ens id="Ensemble 2-A">
 *  <PDBx:details> The inhibitor binds to the enzyme in two, roughly twofold
 *  symmetric alternative conformations.
 *  This conformational ensemble includes the less populated
 *  conformation of the inhibitor (ID=2) and the amino-acid
 *  side chains and solvent structure that correlate with this
 *  inhibitor conformation.
 *  Also included are one set (ID=3) of side chains with
 *  alternative conformations when the conformations are not
 *  correlated with the inhibitor conformation.</PDBx:details>
 *  </PDBx:atom_sites_alt_ens>
 *  <PDBx:atom_sites_alt_ens id="Ensemble 2-B">
 *  <PDBx:details> The inhibitor binds to the enzyme in two, roughly twofold
 *  symmetric alternative conformations.
 *  This conformational ensemble includes the less populated
 *  conformation of the inhibitor (ID=2) and the amino-acid
 *  side chains and solvent structure that correlate with this
 *  inhibitor conformation.
 *  Also included are one set (ID=4) of side chains with
 *  alternative conformations when the conformations are not
 *  correlated with the inhibitor conformation.</PDBx:details>
 *  </PDBx:atom_sites_alt_ens>
 *  </PDBx:atom_sites_alt_ensCategory>
 * </pre>
 */
public class Atom_sites_alt_ens 
{
		protected java.lang.String details;


	/**
	 *  A description of special aspects of the ensemble structure
	 *  generated from atoms with various alternative IDs.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category atom_sites_alt_ens must uniquely identify a
	 *  record in the ATOM_SITES_ALT_ENS list.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 }
