package org.pdb.beans;

/**
 *  Data items in the ATOM_SITES_ALT_GEN category record details
 *  about the interpretation of multiple conformations in the
 *  structure.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:atom_sites_alt_genCategory>
 *  <PDBx:atom_sites_alt_gen ens_id="Ensemble 1-A" alt_id=""></PDBx:atom_sites_alt_gen>
 *  <PDBx:atom_sites_alt_gen ens_id="Ensemble 1-A" alt_id="1"></PDBx:atom_sites_alt_gen>
 *  <PDBx:atom_sites_alt_gen ens_id="Ensemble 1-A" alt_id="3"></PDBx:atom_sites_alt_gen>
 *  <PDBx:atom_sites_alt_gen ens_id="Ensemble 1-B" alt_id=""></PDBx:atom_sites_alt_gen>
 *  <PDBx:atom_sites_alt_gen ens_id="Ensemble 1-B" alt_id="1"></PDBx:atom_sites_alt_gen>
 *  <PDBx:atom_sites_alt_gen ens_id="Ensemble 1-B" alt_id="4"></PDBx:atom_sites_alt_gen>
 *  <PDBx:atom_sites_alt_gen ens_id="Ensemble 2-A" alt_id=""></PDBx:atom_sites_alt_gen>
 *  <PDBx:atom_sites_alt_gen ens_id="Ensemble 2-A" alt_id="2"></PDBx:atom_sites_alt_gen>
 *  <PDBx:atom_sites_alt_gen ens_id="Ensemble 2-A" alt_id="3"></PDBx:atom_sites_alt_gen>
 *  <PDBx:atom_sites_alt_gen ens_id="Ensemble 2-B" alt_id=""></PDBx:atom_sites_alt_gen>
 *  <PDBx:atom_sites_alt_gen ens_id="Ensemble 2-B" alt_id="2"></PDBx:atom_sites_alt_gen>
 *  <PDBx:atom_sites_alt_gen ens_id="Ensemble 2-B" alt_id="4"></PDBx:atom_sites_alt_gen>
 *  </PDBx:atom_sites_alt_genCategory>
 * </pre>
 */
public class Atom_sites_alt_gen 
{
		protected java.lang.String alt_id;


	/**
	 *  This data item is a pointer to  attribute id in category atom_sites_alt in the
	 *  ATOM_SITES_ALT category.
	 */
	public java.lang.String getAlt_id() 
	{
		return alt_id;
	}
 
	public void setAlt_id(java.lang.String alt_id)
	{
		this.alt_id = alt_id;
	}

 	protected java.lang.String ens_id;


	/**
	 *  This data item is a pointer to  attribute id in category atom_sites_alt_ens in the
	 *  ATOM_SITES_ALT_ENS category.
	 */
	public java.lang.String getEns_id() 
	{
		return ens_id;
	}
 
	public void setEns_id(java.lang.String ens_id)
	{
		this.ens_id = ens_id;
	}

 }
