package org.pdb.beans;

/**
 *  Data items in the AUDIT category record details about the
 *  creation and subsequent updating of the data block.
 *  
 *  Note that these items apply only to the creation and updating of
 *  the data block, and should not be confused with the data items
 *  in the JOURNAL category that record different stages in the
 *  publication of the material in the data block.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:auditCategory>
 *  <PDBx:audit revision_id="1">
 *  <PDBx:creation_date>1992-12-08</PDBx:creation_date>
 *  <PDBx:creation_method> Created by hand from PDB entry 5HVP, from the J. Biol.
 *  Chem. paper describing this structure and from
 *  laboratory records</PDBx:creation_method>
 *  <PDBx:update_record> 1992-12-09  adjusted to reflect comments from B. McKeever
 *  1992-12-10  adjusted to reflect comments from H. Berman
 *  1992-12-12  adjusted to reflect comments from K. Watenpaugh</PDBx:update_record>
 *  </PDBx:audit>
 *  </PDBx:auditCategory>
 *  
 *  
 *  Example 2 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:auditCategory>
 *  <PDBx:audit>
 *  <PDBx:creation_date>1991-03-20</PDBx:creation_date>
 *  <PDBx:creation_method>from_xtal_archive_file_using_CIFIO</PDBx:creation_method>
 *  <PDBx:update_record> 1991-04-09  text and data added by Tony Willis.
 *  1991-04-15  rec&apos;d by co-editor as manuscript HL0007.
 *  1991-04-17  adjustments based on first referee report.
 *  1991-04-18  adjustments based on second referee report.</PDBx:update_record>
 *  </PDBx:audit>
 *  </PDBx:auditCategory>
 * </pre>
 */
public class Audit 
{
		protected java.util.Date creation_date;


	/**
	 *  A date that the data block was created. The date format is
	 *  yyyy-mm-dd.
	 *  1990-07-12
	 */
	public java.util.Date getCreation_date() 
	{
		return creation_date;
	}
 
	public void setCreation_date(java.util.Date creation_date)
	{
		this.creation_date = creation_date;
	}

 	protected java.lang.String creation_method;


	/**
	 *  A description of how data were entered into the data block.
	 *  spawned by the program QBEE
	 */
	public java.lang.String getCreation_method() 
	{
		return creation_method;
	}
 
	public void setCreation_method(java.lang.String creation_method)
	{
		this.creation_method = creation_method;
	}

 	protected java.lang.String revision_id;


	/**
	 *  The value of  attribute revision_id in category audit must uniquely identify a record
	 *  in the AUDIT list.
	 *  rev1
	 */
	public java.lang.String getRevision_id() 
	{
		return revision_id;
	}
 
	public void setRevision_id(java.lang.String revision_id)
	{
		this.revision_id = revision_id;
	}

 	protected java.lang.String update_record;


	/**
	 *  A record of any changes to the data block. The update format is
	 *  a date (yyyy-mm-dd) followed by a description of the changes.
	 *  The latest update entry is added to the bottom of this record.
	 *  1990-07-15   Updated by the Co-editor
	 */
	public java.lang.String getUpdate_record() 
	{
		return update_record;
	}
 
	public void setUpdate_record(java.lang.String update_record)
	{
		this.update_record = update_record;
	}

 }
