package org.pdb.beans;

/**
 *  Data items in the AUDIT_CONFORM category describe the
 *  dictionary versions against which the data names appearing in
 *  the current data block are conformant.
 *  
 * <pre>
 *  Example 1 - any file conforming to the current CIF core dictionary.
 *  <PDBx:audit_conformCategory>
 *  <PDBx:audit_conform dict_name="cif_core.dic" dict_version="2.3.1">
 *  <PDBx:dict_location>ftp://ftp.iucr.org/pub/cif_core.2.3.1.dic</PDBx:dict_location>
 *  </PDBx:audit_conform>
 *  </PDBx:audit_conformCategory>
 * </pre>
 */
public class Audit_conform 
{
		protected java.lang.String dict_location;


	/**
	 *  A file name or uniform resource locator (URL) for the
	 *  dictionary to which the current data block conforms.
	 */
	public java.lang.String getDict_location() 
	{
		return dict_location;
	}
 
	public void setDict_location(java.lang.String dict_location)
	{
		this.dict_location = dict_location;
	}

 	protected java.lang.String dict_name;


	/**
	 *  The string identifying the highest-level dictionary defining
	 *  data names used in this file.
	 */
	public java.lang.String getDict_name() 
	{
		return dict_name;
	}
 
	public void setDict_name(java.lang.String dict_name)
	{
		this.dict_name = dict_name;
	}

 	protected java.lang.String dict_version;


	/**
	 *  The version number of the dictionary to which the current
	 *  data block conforms.
	 */
	public java.lang.String getDict_version() 
	{
		return dict_version;
	}
 
	public void setDict_version(java.lang.String dict_version)
	{
		this.dict_version = dict_version;
	}

 }
