package org.pdb.beans;

/**
 *  Data items in the AUDIT_CONTACT_AUTHOR category record details
 *  about the name and address of the author to be contacted
 *  concerning the content of this data block.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:audit_contact_authorCategory>
 *  <PDBx:audit_contact_author name="Fitzgerald, Paula M.D.">
 *  <PDBx:address> Department of Biophysical Chemistry
 *  Merck Research Laboratories
 *  PO Box 2000, Ry80M203
 *  Rahway, New Jersey 07065
 *  USA</PDBx:address>
 *  <PDBx:phone>1(908)5945510</PDBx:phone>
 *  <PDBx:fax>1(908)5946645</PDBx:fax>
 *  <PDBx:email>paula_fitzgerald@merck.com</PDBx:email>
 *  </PDBx:audit_contact_author>
 *  </PDBx:audit_contact_authorCategory>
 * </pre>
 */
public class Audit_contact_author 
{
		protected java.lang.String address;


	/**
	 *  The mailing address of the author of the data block to whom
	 *  correspondence should be addressed.
	 *  Department
	 *  Institute
	 *  Street
	 *  City and postcode
	 *  COUNTRY
	 */
	public java.lang.String getAddress() 
	{
		return address;
	}
 
	public void setAddress(java.lang.String address)
	{
		this.address = address;
	}

 	protected java.lang.String email;


	/**
	 *  The electronic mail address of the author of the data block to
	 *  whom correspondence should be addressed, in a form recognizable
	 *  to international networks. The format of e-mail
	 *  addresses is given in Section 3.4, Address Specification, of
	 *  Internet Message Format, RFC 2822, P. Resnick (Editor),
	 *  Network Standards Group, April 2001.
	 *  name@host.domain.country
	 *  bm@iucr.org
	 */
	public java.lang.String getEmail() 
	{
		return email;
	}
 
	public void setEmail(java.lang.String email)
	{
		this.email = email;
	}

 	protected java.lang.String fax;


	/**
	 *  The facsimile telephone number of the author of the data
	 *  block to whom correspondence should be addressed.
	 *  
	 *  The recommended style starts with the international dialing
	 *  prefix, followed by the area code in parentheses, followed by the
	 *  local number with no spaces.
	 *  12(34)9477334
	 *  12()349477334
	 */
	public java.lang.String getFax() 
	{
		return fax;
	}
 
	public void setFax(java.lang.String fax)
	{
		this.fax = fax;
	}

 	protected java.lang.String name;


	/**
	 *  The name of the author of the data block to whom correspondence
	 *  should be addressed.
	 *  
	 *  The family name(s), followed by a comma and including any
	 *  dynastic components, precedes the first name(s) or initial(s).
	 *  Bleary, Percival R.
	 *  O'Neil, F.K.
	 *  Van den Bossche, G.
	 *  Yang, D.-L.
	 *  Simonov, Yu.A
	 */
	public java.lang.String getName() 
	{
		return name;
	}
 
	public void setName(java.lang.String name)
	{
		this.name = name;
	}

 	protected java.lang.String phone;


	/**
	 *  The telephone number of the author of the data block to whom
	 *  correspondence should be addressed.
	 *  
	 *  The recommended style starts with the international dialing
	 *  prefix, followed by the area code in parentheses, followed by the
	 *  local number and any extension number prefixed by 'x',
	 *  with no spaces.
	 *  12(34)9477330
	 *  12()349477330
	 *  12(34)9477330x5543
	 */
	public java.lang.String getPhone() 
	{
		return phone;
	}
 
	public void setPhone(java.lang.String phone)
	{
		this.phone = phone;
	}

 }
