package org.pdb.beans;

/**
 *  Data items in the AUDIT_LINK category record details about the
 *  relationships between data blocks in the current CIF.
 *  
 * <pre>
 *  Example 1 - multiple structure paper, as illustrated
 *  in A Guide to CIF for Authors (1995). IUCr: Chester.
 *  <PDBx:audit_linkCategory>
 *  <PDBx:audit_link block_code="" block_description="discursive text of paper with two structures"></PDBx:audit_link>
 *  <PDBx:audit_link block_code="morA_(1)" block_description="structure 1 of 2"></PDBx:audit_link>
 *  <PDBx:audit_link block_code="morA_(2)" block_description="structure 2 of 2"></PDBx:audit_link>
 *  </PDBx:audit_linkCategory>
 *  
 *  
 *  Example 2 - example file for the one-dimensional incommensurately
 *  modulated structure of K~2~SeO~4~.
 *  <PDBx:audit_linkCategory>
 *  <PDBx:audit_link block_code="" block_description="publication details"></PDBx:audit_link>
 *  <PDBx:audit_link block_code="KSE_COM" block_description="experimental data common to ref./mod. structures"></PDBx:audit_link>
 *  <PDBx:audit_link block_code="KSE_REF" block_description="reference structure"></PDBx:audit_link>
 *  <PDBx:audit_link block_code="KSE_MOD" block_description="modulated structure"></PDBx:audit_link>
 *  </PDBx:audit_linkCategory>
 * </pre>
 */
public class Audit_link 
{
		protected java.lang.String block_code;


	/**
	 *  The value of  attribute code in category audit_block associated with a data block
	 *  in the current file related to the current data block. The
	 *  special value '.' may be used to refer to the current data
	 *  block for completeness.
	 */
	public java.lang.String getBlock_code() 
	{
		return block_code;
	}
 
	public void setBlock_code(java.lang.String block_code)
	{
		this.block_code = block_code;
	}

 	protected java.lang.String block_description;


	/**
	 *  A textual description of the relationship of the referenced
	 *  data block to the current one.
	 */
	public java.lang.String getBlock_description() 
	{
		return block_description;
	}
 
	public void setBlock_description(java.lang.String block_description)
	{
		this.block_description = block_description;
	}

 }
