package org.pdb.beans;

/**
 *  Data items in the CELL category record details about the
 *  crystallographic cell parameters.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:cellCategory>
 *  <PDBx:cell entry_id="5HVP">
 *  <PDBx:length_a>58.39</PDBx:length_a>
 *  <PDBx:length_a_esd>0.05</PDBx:length_a_esd>
 *  <PDBx:length_b>86.70</PDBx:length_b>
 *  <PDBx:length_b_esd>0.12</PDBx:length_b_esd>
 *  <PDBx:length_c>46.27</PDBx:length_c>
 *  <PDBx:length_c_esd>0.06</PDBx:length_c_esd>
 *  <PDBx:angle_alpha>90.00</PDBx:angle_alpha>
 *  <PDBx:angle_beta>90.00</PDBx:angle_beta>
 *  <PDBx:angle_gamma>90.00</PDBx:angle_gamma>
 *  <PDBx:volume>234237.</PDBx:volume>
 *  <PDBx:details> The cell parameters were refined every twenty frames during
 *  data integration. The cell lengths given are the mean of
 *  55 such refinements; the esds given are the root mean
 *  square deviations of these 55 observations from that mean.</PDBx:details>
 *  </PDBx:cell>
 *  </PDBx:cellCategory>
 *  
 *  
 *  Example 2 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:cellCategory>
 *  <PDBx:cell>
 *  <PDBx:length_a>5.959</PDBx:length_a>
 *  <PDBx:length_a_esd>0.001</PDBx:length_a_esd>
 *  <PDBx:length_b>14.956</PDBx:length_b>
 *  <PDBx:length_b_esd>0.001</PDBx:length_b_esd>
 *  <PDBx:length_c>19.737</PDBx:length_c>
 *  <PDBx:length_c_esd>0.003</PDBx:length_c_esd>
 *  <PDBx:angle_alpha>90.0</PDBx:angle_alpha>
 *  <PDBx:angle_beta>90.0</PDBx:angle_beta>
 *  <PDBx:angle_gamma>90.0</PDBx:angle_gamma>
 *  <PDBx:volume>1759.0</PDBx:volume>
 *  <PDBx:volume_esd>0.3</PDBx:volume_esd>
 *  </PDBx:cell>
 *  </PDBx:cellCategory>
 * </pre>
 */
public class Cell 
{
		protected java.lang.Integer Z_PDB;


	/**
	 *  The number of the polymeric chains in a unit cell. In the case
	 *  of heteropolymers, Z is the number of occurrences of the most
	 *  populous chain.
	 *  
	 *  This data item is provided for compatibility with the original
	 *  Protein Data Bank format, and only for that purpose.
	 */
	public java.lang.Integer getZ_PDB() 
	{
		return Z_PDB;
	}
 
	public void setZ_PDB(java.lang.Integer Z_PDB)
	{
		this.Z_PDB = Z_PDB;
	}

 	protected java.lang.Float angle_alpha;


	/**
	 *  Unit-cell angle alpha of the reported structure in degrees.
	 */
	public java.lang.Float getAngle_alpha() 
	{
		return angle_alpha;
	}
 
	public void setAngle_alpha(java.lang.Float angle_alpha)
	{
		this.angle_alpha = angle_alpha;
	}

 	protected java.lang.Float angle_alpha_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute angle_alpha in category cell.
	 */
	public java.lang.Float getAngle_alpha_esd() 
	{
		return angle_alpha_esd;
	}
 
	public void setAngle_alpha_esd(java.lang.Float angle_alpha_esd)
	{
		this.angle_alpha_esd = angle_alpha_esd;
	}

 	protected java.lang.Float angle_beta;


	/**
	 *  Unit-cell angle beta of the reported structure in degrees.
	 */
	public java.lang.Float getAngle_beta() 
	{
		return angle_beta;
	}
 
	public void setAngle_beta(java.lang.Float angle_beta)
	{
		this.angle_beta = angle_beta;
	}

 	protected java.lang.Float angle_beta_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute angle_beta in category cell.
	 */
	public java.lang.Float getAngle_beta_esd() 
	{
		return angle_beta_esd;
	}
 
	public void setAngle_beta_esd(java.lang.Float angle_beta_esd)
	{
		this.angle_beta_esd = angle_beta_esd;
	}

 	protected java.lang.Float angle_gamma;


	/**
	 *  Unit-cell angle gamma of the reported structure in degrees.
	 */
	public java.lang.Float getAngle_gamma() 
	{
		return angle_gamma;
	}
 
	public void setAngle_gamma(java.lang.Float angle_gamma)
	{
		this.angle_gamma = angle_gamma;
	}

 	protected java.lang.Float angle_gamma_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute angle_gamma in category cell.
	 */
	public java.lang.Float getAngle_gamma_esd() 
	{
		return angle_gamma_esd;
	}
 
	public void setAngle_gamma_esd(java.lang.Float angle_gamma_esd)
	{
		this.angle_gamma_esd = angle_gamma_esd;
	}

 	protected java.lang.String details;


	/**
	 *  A description of special aspects of the cell choice, noting
	 *  possible alternative settings.
	 *  pseudo-orthorhombic
	 *  standard setting from 45 deg rotation around c
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.Integer formula_units_Z;


	/**
	 *  The number of the formula units in the unit cell as specified
	 *  by _chemical_formula.structural, _chemical_formula.moiety or
	 *  attribute sum in category chemical_formula.
	 */
	public java.lang.Integer getFormula_units_Z() 
	{
		return formula_units_Z;
	}
 
	public void setFormula_units_Z(java.lang.Integer formula_units_Z)
	{
		this.formula_units_Z = formula_units_Z;
	}

 	protected java.lang.Float length_a;


	/**
	 *  Unit-cell length a corresponding to the structure reported in
	 *  angstroms.
	 */
	public java.lang.Float getLength_a() 
	{
		return length_a;
	}
 
	public void setLength_a(java.lang.Float length_a)
	{
		this.length_a = length_a;
	}

 	protected java.lang.Float length_a_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute length_a in category cell.
	 */
	public java.lang.Float getLength_a_esd() 
	{
		return length_a_esd;
	}
 
	public void setLength_a_esd(java.lang.Float length_a_esd)
	{
		this.length_a_esd = length_a_esd;
	}

 	protected java.lang.Float length_b;


	/**
	 *  Unit-cell length b corresponding to the structure reported in
	 *  angstroms.
	 */
	public java.lang.Float getLength_b() 
	{
		return length_b;
	}
 
	public void setLength_b(java.lang.Float length_b)
	{
		this.length_b = length_b;
	}

 	protected java.lang.Float length_b_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute length_b in category cell.
	 */
	public java.lang.Float getLength_b_esd() 
	{
		return length_b_esd;
	}
 
	public void setLength_b_esd(java.lang.Float length_b_esd)
	{
		this.length_b_esd = length_b_esd;
	}

 	protected java.lang.Float length_c;


	/**
	 *  Unit-cell length c corresponding to the structure reported in
	 *  angstroms.
	 */
	public java.lang.Float getLength_c() 
	{
		return length_c;
	}
 
	public void setLength_c(java.lang.Float length_c)
	{
		this.length_c = length_c;
	}

 	protected java.lang.Float length_c_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute length_c in category cell.
	 */
	public java.lang.Float getLength_c_esd() 
	{
		return length_c_esd;
	}
 
	public void setLength_c_esd(java.lang.Float length_c_esd)
	{
		this.length_c_esd = length_c_esd;
	}

 	protected java.lang.String pdbx_unique_axis;


	/**
	 *  To further identify unique axis if necessary.  E.g., P 21 with
	 *  an unique C axis will have 'C' in this field.
	 */
	public java.lang.String getPdbx_unique_axis() 
	{
		return pdbx_unique_axis;
	}
 
	public void setPdbx_unique_axis(java.lang.String pdbx_unique_axis)
	{
		this.pdbx_unique_axis = pdbx_unique_axis;
	}

 	protected java.lang.Float reciprocal_angle_alpha;


	/**
	 *  The angle (recip-alpha) defining the reciprocal cell in degrees.
	 *  (recip-alpha), (recip-alpha) and (recip-alpha) related to the
	 *  angles in the real cell by:
	 *  
	 *  cos(recip-alpha)
	 *  = [cos(beta)*cos(gamma) - cos(alpha)]/[sin(beta)*sin(gamma)]
	 *  
	 *  cos(recip-beta)
	 *  = [cos(gamma)*cos(alpha) - cos(beta)]/[sin(gamma)*sin(alpha)]
	 *  
	 *  cos(recip-gamma)
	 *  = [cos(alpha)*cos(beta) - cos(gamma)]/[sin(alpha)*sin(beta)]
	 *  
	 *  Ref: Buerger, M. J. (1942). X-ray Crystallography, p. 360.
	 *  New York: John Wiley & Sons Inc.
	 */
	public java.lang.Float getReciprocal_angle_alpha() 
	{
		return reciprocal_angle_alpha;
	}
 
	public void setReciprocal_angle_alpha(java.lang.Float reciprocal_angle_alpha)
	{
		this.reciprocal_angle_alpha = reciprocal_angle_alpha;
	}

 	protected java.lang.Float reciprocal_angle_alpha_esd;


	/**
	 *  The estimated standard deviation of  attribute reciprocal_angle_alpha in category cell.
	 */
	public java.lang.Float getReciprocal_angle_alpha_esd() 
	{
		return reciprocal_angle_alpha_esd;
	}
 
	public void setReciprocal_angle_alpha_esd(java.lang.Float reciprocal_angle_alpha_esd)
	{
		this.reciprocal_angle_alpha_esd = reciprocal_angle_alpha_esd;
	}

 	protected java.lang.Float reciprocal_angle_beta;


	/**
	 *  The angle (recip-beta) defining the reciprocal cell in degrees.
	 *  (recip-alpha), (recip-alpha) and (recip-alpha) related to the
	 *  angles in the real cell by:
	 *  
	 *  cos(recip-alpha)
	 *  = [cos(beta)*cos(gamma) - cos(alpha)]/[sin(beta)*sin(gamma)]
	 *  
	 *  cos(recip-beta)
	 *  = [cos(gamma)*cos(alpha) - cos(beta)]/[sin(gamma)*sin(alpha)]
	 *  
	 *  cos(recip-gamma)
	 *  = [cos(alpha)*cos(beta) - cos(gamma)]/[sin(alpha)*sin(beta)]
	 *  
	 *  Ref: Buerger, M. J. (1942). X-ray Crystallography, p. 360.
	 *  New York: John Wiley & Sons Inc.
	 */
	public java.lang.Float getReciprocal_angle_beta() 
	{
		return reciprocal_angle_beta;
	}
 
	public void setReciprocal_angle_beta(java.lang.Float reciprocal_angle_beta)
	{
		this.reciprocal_angle_beta = reciprocal_angle_beta;
	}

 	protected java.lang.Float reciprocal_angle_beta_esd;


	/**
	 *  The estimated standard deviation of  attribute reciprocal_angle_beta in category cell.
	 */
	public java.lang.Float getReciprocal_angle_beta_esd() 
	{
		return reciprocal_angle_beta_esd;
	}
 
	public void setReciprocal_angle_beta_esd(java.lang.Float reciprocal_angle_beta_esd)
	{
		this.reciprocal_angle_beta_esd = reciprocal_angle_beta_esd;
	}

 	protected java.lang.Float reciprocal_angle_gamma;


	/**
	 *  The angle (recip-gamma) defining the reciprocal cell in degrees.
	 *  (recip-alpha), (recip-alpha) and (recip-alpha) related to the
	 *  angles in the real cell by:
	 *  
	 *  cos(recip-alpha)
	 *  = [cos(beta)*cos(gamma) - cos(alpha)]/[sin(beta)*sin(gamma)]
	 *  
	 *  cos(recip-beta)
	 *  = [cos(gamma)*cos(alpha) - cos(beta)]/[sin(gamma)*sin(alpha)]
	 *  
	 *  cos(recip-gamma)
	 *  = [cos(alpha)*cos(beta) - cos(gamma)]/[sin(alpha)*sin(beta)]
	 *  
	 *  Ref: Buerger, M. J. (1942). X-ray Crystallography, p. 360.
	 *  New York: John Wiley & Sons Inc.
	 */
	public java.lang.Float getReciprocal_angle_gamma() 
	{
		return reciprocal_angle_gamma;
	}
 
	public void setReciprocal_angle_gamma(java.lang.Float reciprocal_angle_gamma)
	{
		this.reciprocal_angle_gamma = reciprocal_angle_gamma;
	}

 	protected java.lang.Float reciprocal_angle_gamma_esd;


	/**
	 *  The estimated standard deviation of  attribute reciprocal_angle_gamma in category cell.
	 */
	public java.lang.Float getReciprocal_angle_gamma_esd() 
	{
		return reciprocal_angle_gamma_esd;
	}
 
	public void setReciprocal_angle_gamma_esd(java.lang.Float reciprocal_angle_gamma_esd)
	{
		this.reciprocal_angle_gamma_esd = reciprocal_angle_gamma_esd;
	}

 	protected java.lang.Float reciprocal_length_a;


	/**
	 *  The reciprocal cell length (recip-a) in inverse Angstroms.
	 *  (recip-a), (recip-b) and (recip-c) are related to the real cell
	 *  by the following equation:
	 *  
	 *  recip-a = b*c*sin(alpha)/V
	 *  
	 *  recip-b = c*a*sin(beta)/V
	 *  
	 *  recip-c = a*b*sin(gamma)/V
	 *  
	 *  where V is the cell volume.
	 *  
	 *  Ref: Buerger, M. J. (1942). X-ray Crystallography, p. 360.
	 *  New York: John Wiley & Sons Inc.
	 */
	public java.lang.Float getReciprocal_length_a() 
	{
		return reciprocal_length_a;
	}
 
	public void setReciprocal_length_a(java.lang.Float reciprocal_length_a)
	{
		this.reciprocal_length_a = reciprocal_length_a;
	}

 	protected java.lang.Float reciprocal_length_a_esd;


	/**
	 *  The estimated standard deviation of  attribute reciprocal_length_a in category cell.
	 */
	public java.lang.Float getReciprocal_length_a_esd() 
	{
		return reciprocal_length_a_esd;
	}
 
	public void setReciprocal_length_a_esd(java.lang.Float reciprocal_length_a_esd)
	{
		this.reciprocal_length_a_esd = reciprocal_length_a_esd;
	}

 	protected java.lang.Float reciprocal_length_b;


	/**
	 *  The reciprocal cell length (recip-b) in inverse Angstroms.
	 *  (recip-a), (recip-b) and (recip-c) are related to the real cell
	 *  by the following equation:
	 *  
	 *  recip-a = b*c*sin(alpha)/V
	 *  
	 *  recip-b = c*a*sin(beta)/V
	 *  
	 *  recip-c = a*b*sin(gamma)/V
	 *  
	 *  where V is the cell volume.
	 *  
	 *  Ref: Buerger, M. J. (1942). X-ray Crystallography, p. 360.
	 *  New York: John Wiley & Sons Inc.
	 */
	public java.lang.Float getReciprocal_length_b() 
	{
		return reciprocal_length_b;
	}
 
	public void setReciprocal_length_b(java.lang.Float reciprocal_length_b)
	{
		this.reciprocal_length_b = reciprocal_length_b;
	}

 	protected java.lang.Float reciprocal_length_b_esd;


	/**
	 *  The estimated standard deviation of  attribute reciprocal_length_b in category cell.
	 */
	public java.lang.Float getReciprocal_length_b_esd() 
	{
		return reciprocal_length_b_esd;
	}
 
	public void setReciprocal_length_b_esd(java.lang.Float reciprocal_length_b_esd)
	{
		this.reciprocal_length_b_esd = reciprocal_length_b_esd;
	}

 	protected java.lang.Float reciprocal_length_c;


	/**
	 *  The reciprocal cell length (recip-c) in inverse Angstroms.
	 *  (recip-a), (recip-b) and (recip-c) are related to the real cell
	 *  by the following equation:
	 *  
	 *  recip-a = b*c*sin(alpha)/V
	 *  
	 *  recip-b = c*a*sin(beta)/V
	 *  
	 *  recip-c = a*b*sin(gamma)/V
	 *  
	 *  where V is the cell volume.
	 *  
	 *  Ref: Buerger, M. J. (1942). X-ray Crystallography, p. 360.
	 *  New York: John Wiley & Sons Inc.
	 */
	public java.lang.Float getReciprocal_length_c() 
	{
		return reciprocal_length_c;
	}
 
	public void setReciprocal_length_c(java.lang.Float reciprocal_length_c)
	{
		this.reciprocal_length_c = reciprocal_length_c;
	}

 	protected java.lang.Float reciprocal_length_c_esd;


	/**
	 *  The estimated standard deviation of  attribute reciprocal_length_c in category cell.
	 */
	public java.lang.Float getReciprocal_length_c_esd() 
	{
		return reciprocal_length_c_esd;
	}
 
	public void setReciprocal_length_c_esd(java.lang.Float reciprocal_length_c_esd)
	{
		this.reciprocal_length_c_esd = reciprocal_length_c_esd;
	}

 	protected java.lang.Float volume;


	/**
	 *  Cell volume V in angstroms cubed.
	 *  
	 *  V = a b c (1 - cos^2^~alpha~ - cos^2^~beta~ - cos^2^~gamma~
	 *  + 2 cos~alpha~ cos~beta~ cos~gamma~)^1/2^
	 *  
	 *  a =  attribute length_a
	 *  in category cell b =  attribute length_b
	 *  in category cell c =  attribute length_c
	 *  in category cell alpha =  attribute angle_alpha
	 *  in category cell beta =  attribute angle_beta
	 *  in category cell gamma =  attribute angle_gamma in category cell
	 */
	public java.lang.Float getVolume() 
	{
		return volume;
	}
 
	public void setVolume(java.lang.Float volume)
	{
		this.volume = volume;
	}

 	protected java.lang.Float volume_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute volume in category cell.
	 */
	public java.lang.Float getVolume_esd() 
	{
		return volume_esd;
	}
 
	public void setVolume_esd(java.lang.Float volume_esd)
	{
		this.volume_esd = volume_esd;
	}

 }
