package org.pdb.beans;

/**
 *  Data items in the CELL_MEASUREMENT_REFLN category record
 *  details about the reflections used to determine the
 *  crystallographic cell parameters.
 *  
 *  The CELL_MEASUREMENT_REFLN data items would in general be used
 *  only for diffractometer data.
 *  
 * <pre>
 *  Example 1 - extracted from the CAD-4 listing of Rb~2~S~2~O~6~ at room
 *  temperature (unpublished).
 *  <PDBx:cell_measurement_reflnCategory>
 *  <PDBx:cell_measurement_refln index_h="-2" index_k="4" index_l="1">
 *  <PDBx:theta>8.67</PDBx:theta>
 *  </PDBx:cell_measurement_refln>
 *  <PDBx:cell_measurement_refln index_h="0" index_k="3" index_l="2">
 *  <PDBx:theta>9.45</PDBx:theta>
 *  </PDBx:cell_measurement_refln>
 *  <PDBx:cell_measurement_refln index_h="3" index_k="0" index_l="2">
 *  <PDBx:theta>9.46</PDBx:theta>
 *  </PDBx:cell_measurement_refln>
 *  <PDBx:cell_measurement_refln index_h="-3" index_k="4" index_l="1">
 *  <PDBx:theta>8.93</PDBx:theta>
 *  </PDBx:cell_measurement_refln>
 *  <PDBx:cell_measurement_refln index_h="-2" index_k="1" index_l="-2">
 *  <PDBx:theta>7.53</PDBx:theta>
 *  </PDBx:cell_measurement_refln>
 *  <PDBx:cell_measurement_refln index_h="10" index_k="0" index_l="0">
 *  <PDBx:theta>23.77</PDBx:theta>
 *  </PDBx:cell_measurement_refln>
 *  <PDBx:cell_measurement_refln index_h="0" index_k="10" index_l="0">
 *  <PDBx:theta>23.78</PDBx:theta>
 *  </PDBx:cell_measurement_refln>
 *  <PDBx:cell_measurement_refln index_h="-5" index_k="4" index_l="1">
 *  <PDBx:theta>11.14</PDBx:theta>
 *  </PDBx:cell_measurement_refln>
 *  </PDBx:cell_measurement_reflnCategory>
 * </pre>
 */
public class Cell_measurement_refln 
{
		protected java.lang.Integer index_h;


	/**
	 *  Miller index h of a reflection used for measurement of the unit
	 *  cell.
	 */
	public java.lang.Integer getIndex_h() 
	{
		return index_h;
	}
 
	public void setIndex_h(java.lang.Integer index_h)
	{
		this.index_h = index_h;
	}

 	protected java.lang.Integer index_k;


	/**
	 *  Miller index k of a reflection used for measurement of the unit
	 *  cell.
	 */
	public java.lang.Integer getIndex_k() 
	{
		return index_k;
	}
 
	public void setIndex_k(java.lang.Integer index_k)
	{
		this.index_k = index_k;
	}

 	protected java.lang.Integer index_l;


	/**
	 *  Miller index l of a reflection used for measurement of the unit
	 *  cell.
	 */
	public java.lang.Integer getIndex_l() 
	{
		return index_l;
	}
 
	public void setIndex_l(java.lang.Integer index_l)
	{
		this.index_l = index_l;
	}

 	protected java.lang.Float theta;


	/**
	 *  Theta angle for a reflection used for measurement of
	 *  the unit cell in degrees.
	 */
	public java.lang.Float getTheta() 
	{
		return theta;
	}
 
	public void setTheta(java.lang.Float theta)
	{
		this.theta = theta;
	}

 }
