package org.pdb.beans;

/**
 *  Data items in the CHEM_COMP_ANGLE category record details about
 *  angles in a chemical component. Angles are designated by three
 *  atoms, with the second atom forming the vertex of the angle.
 *  Target values may be specified as angles in degrees, as a
 *  distance between the first and third atoms, or both.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:chem_comp_angleCategory>
 *  <PDBx:chem_comp_angle comp_id="phe" atom_id_1="N" atom_id_2="CA" atom_id_3="C">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="phe" atom_id_1="CA" atom_id_2="C" atom_id_3="O">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="phe" atom_id_1="CB" atom_id_2="CA" atom_id_3="C">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="phe" atom_id_1="CB" atom_id_2="CA" atom_id_3="N">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="phe" atom_id_1="CA" atom_id_2="CB" atom_id_3="CG">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="phe" atom_id_1="CB" atom_id_2="CG" atom_id_3="CD1">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="phe" atom_id_1="CB" atom_id_2="CG" atom_id_3="CD2">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="phe" atom_id_1="CD1" atom_id_2="CG" atom_id_3="CD2">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="phe" atom_id_1="CG" atom_id_2="CD1" atom_id_3="CE1">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="phe" atom_id_1="CD1" atom_id_2="CE1" atom_id_3="CZ">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="phe" atom_id_1="CE1" atom_id_2="CZ" atom_id_3="CE2">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="phe" atom_id_1="CZ" atom_id_2="CE2" atom_id_3="CD2">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="phe" atom_id_1="CG" atom_id_2="CD2" atom_id_3="CE2">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="val" atom_id_1="N" atom_id_2="CA" atom_id_3="C">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="val" atom_id_1="CA" atom_id_2="C" atom_id_3="O">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="val" atom_id_1="CB" atom_id_2="CA" atom_id_3="C">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="val" atom_id_1="CB" atom_id_2="CA" atom_id_3="N">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="val" atom_id_1="CA" atom_id_2="CB" atom_id_3="CG1">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="val" atom_id_1="CA" atom_id_2="CB" atom_id_3="CG2">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  <PDBx:chem_comp_angle comp_id="val" atom_id_1="CG1" atom_id_2="CB" atom_id_3="CG2">
 *  <PDBx:value_angle>xxx.xx</PDBx:value_angle>
 *  <PDBx:value_dist>x.xx</PDBx:value_dist>
 *  </PDBx:chem_comp_angle>
 *  </PDBx:chem_comp_angleCategory>
 * </pre>
 */
public class Chem_comp_angle 
{
		protected java.lang.String atom_id_1;


	/**
	 *  The ID of the first of the three atoms that define the angle.
	 *  
	 *  This data item is a pointer to  attribute atom_id in category chem_comp_atom in the
	 *  CHEM_COMP_ATOM category.
	 */
	public java.lang.String getAtom_id_1() 
	{
		return atom_id_1;
	}
 
	public void setAtom_id_1(java.lang.String atom_id_1)
	{
		this.atom_id_1 = atom_id_1;
	}

 	protected java.lang.String atom_id_2;


	/**
	 *  The ID of the second of the three atoms that define the angle.
	 *  The second atom is taken to be the apex of the angle.
	 *  
	 *  This data item is a pointer to  attribute atom_id in category chem_comp_atom in the
	 *  CHEM_COMP_ATOM category.
	 */
	public java.lang.String getAtom_id_2() 
	{
		return atom_id_2;
	}
 
	public void setAtom_id_2(java.lang.String atom_id_2)
	{
		this.atom_id_2 = atom_id_2;
	}

 	protected java.lang.String atom_id_3;


	/**
	 *  The ID of the third of the three atoms that define the angle.
	 *  
	 *  This data item is a pointer to  attribute atom_id in category chem_comp_atom in the
	 *  CHEM_COMP_ATOM category.
	 */
	public java.lang.String getAtom_id_3() 
	{
		return atom_id_3;
	}
 
	public void setAtom_id_3(java.lang.String atom_id_3)
	{
		this.atom_id_3 = atom_id_3;
	}

 	protected java.lang.String comp_id;


	/**
	 *  This data item is a pointer to  attribute id in category chem_comp in the CHEM_COMP
	 *  category.
	 */
	public java.lang.String getComp_id() 
	{
		return comp_id;
	}
 
	public void setComp_id(java.lang.String comp_id)
	{
		this.comp_id = comp_id;
	}

 	protected java.lang.Float value_angle;


	/**
	 *  The value that should be taken as the target value for the angle
	 *  associated with the specified atoms, expressed in degrees.
	 */
	public java.lang.Float getValue_angle() 
	{
		return value_angle;
	}
 
	public void setValue_angle(java.lang.Float value_angle)
	{
		this.value_angle = value_angle;
	}

 	protected java.lang.Float value_angle_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute value_angle in category chem_comp_angle.
	 */
	public java.lang.Float getValue_angle_esd() 
	{
		return value_angle_esd;
	}
 
	public void setValue_angle_esd(java.lang.Float value_angle_esd)
	{
		this.value_angle_esd = value_angle_esd;
	}

 	protected java.lang.Float value_dist;


	/**
	 *  The value that should be taken as the target value for the angle
	 *  associated with the specified atoms, expressed as the distance
	 *  between the atoms specified by  attribute atom_id_1 in category chem_comp_angle and
	 *  attribute atom_id_3 in category chem_comp_angle.
	 */
	public java.lang.Float getValue_dist() 
	{
		return value_dist;
	}
 
	public void setValue_dist(java.lang.Float value_dist)
	{
		this.value_dist = value_dist;
	}

 	protected java.lang.Float value_dist_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute value_dist in category chem_comp_angle.
	 */
	public java.lang.Float getValue_dist_esd() 
	{
		return value_dist_esd;
	}
 
	public void setValue_dist_esd(java.lang.Float value_dist_esd)
	{
		this.value_dist_esd = value_dist_esd;
	}

 }
