package org.pdb.beans;

/**
 *  Data items in the CHEM_COMP_CHIR_ATOM category enumerate the
 *  atoms bonded to a chiral atom within a chemical component.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:chem_comp_chir_atomCategory>
 *  <PDBx:chem_comp_chir_atom comp_id="phe" chir_id="1" atom_id="N"></PDBx:chem_comp_chir_atom>
 *  <PDBx:chem_comp_chir_atom comp_id="phe" chir_id="1" atom_id="C"></PDBx:chem_comp_chir_atom>
 *  <PDBx:chem_comp_chir_atom comp_id="phe" chir_id="1" atom_id="CB"></PDBx:chem_comp_chir_atom>
 *  <PDBx:chem_comp_chir_atom comp_id="val" chir_id="1" atom_id="N"></PDBx:chem_comp_chir_atom>
 *  <PDBx:chem_comp_chir_atom comp_id="val" chir_id="1" atom_id="C"></PDBx:chem_comp_chir_atom>
 *  <PDBx:chem_comp_chir_atom comp_id="val" chir_id="1" atom_id="CB"></PDBx:chem_comp_chir_atom>
 *  </PDBx:chem_comp_chir_atomCategory>
 * </pre>
 */
public class Chem_comp_chir_atom 
{
		protected java.lang.String atom_id;


	/**
	 *  The ID of an atom bonded to the chiral atom.
	 *  
	 *  This data item is a pointer to  attribute atom_id in category chem_comp_atom in the
	 *  CHEM_COMP_ATOM category.
	 */
	public java.lang.String getAtom_id() 
	{
		return atom_id;
	}
 
	public void setAtom_id(java.lang.String atom_id)
	{
		this.atom_id = atom_id;
	}

 	protected java.lang.String chir_id;


	/**
	 *  This data item is a pointer to  attribute id in category chem_comp_chir in the
	 *  CHEM_COMP_CHIR category.
	 */
	public java.lang.String getChir_id() 
	{
		return chir_id;
	}
 
	public void setChir_id(java.lang.String chir_id)
	{
		this.chir_id = chir_id;
	}

 	protected java.lang.String comp_id;


	/**
	 *  This data item is a pointer to  attribute id in category chem_comp in the
	 *  CHEM_COMP category.
	 */
	public java.lang.String getComp_id() 
	{
		return comp_id;
	}
 
	public void setComp_id(java.lang.String comp_id)
	{
		this.comp_id = comp_id;
	}

 	protected java.lang.Float dev;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of the position of this atom from the plane defined by
	 *  all of the atoms in the plane.
	 */
	public java.lang.Float getDev() 
	{
		return dev;
	}
 
	public void setDev(java.lang.Float dev)
	{
		this.dev = dev;
	}

 }
